/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.LongRef;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_638;
import net.minecraft.class_6558;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_733;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends class_703>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<class_703> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> BLOCK_ENTITY_OPERATIONS = new ArrayList<Runnable>();
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static boolean cancelled = false;
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<Runnable> END_TICK_EVENTS;
    private static final List<Pair<class_2960, Runnable>> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static CompletableFuture<Void> blockEntityTickFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ExecutorService EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final LongRef timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onRunAllTasks() {
        if (!SimplePropertiesConfig.isTickAsync()) {
            return;
        }
        if (blockEntityTickFuture != null && !SimplePropertiesConfig.greedyAsyncClientBlockEntityTick()) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
    }

    public static void onTickBefore(int i, int to) {
        boolean levelRunning;
        if (!SimplePropertiesConfig.isTickAsync()) {
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("async_particles");
        if (blockEntityTickFuture != null && (i != 0 || SimplePropertiesConfig.greedyAsyncClientBlockEntityTick())) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            cancelled = true;
            debug_cancelled = false;
            if (particleFuture != null) {
                particleFuture.join();
                particleFuture = null;
            }
            cancelled = false;
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                class_702 particleEngine = mc.field_1713;
                Collection values = particleEngine.field_3830.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                int k = 0;
                Queue trackingEmitters = particleEngine.field_3837;
                futures[k++] = trackingEmitters.isEmpty() ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.method_3086()), EXECUTOR);
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = CompletableFuture.completedFuture(null);
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        boolean b;
                        boolean bl = ((ParticleAddon)particle1).asyncparticles$isTickSync() ? !particle1.method_3086() : (b = ((ParticleAddon)particle1).asyncparticles$shouldRemove());
                        if (b) {
                            particle1.method_34019().ifPresent(group -> particleEngine.method_34022(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.method_15407();
    }

    public static void onTickAfter(int i, int to) {
        List<Runnable> particleOperations;
        List<Pair<class_2960, Runnable>> endTickOperations;
        CompletionStage<Void> particleFuture;
        boolean levelRunning;
        if (!SimplePropertiesConfig.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(p -> ((Runnable)p.second()).run());
            END_TICK_OPERATIONS.clear();
            END_TICK_EVENTS.forEach(Runnable::run);
            return;
        }
        class_310 mc = class_310.method_1551();
        class_3695 profiler = mc.method_16011();
        profiler.method_15396("async_particles");
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (levelRunning) {
            profiler.method_15396("particle_tick");
            if (i == to - 1) {
                mc.field_1713.method_3057();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.method_15407();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        List<Runnable> blockEntityOperations = BLOCK_ENTITY_OPERATIONS;
        if (!levelRunning || !SimplePropertiesConfig.asyncBlockEntityTick()) {
            particleFuture = CompletableFuture.runAsync(() -> timeUsageNano.set(System.nanoTime()), EXECUTOR);
            if (!blockEntityOperations.isEmpty()) {
                blockEntityOperations.clear();
            }
        } else {
            Runnable[] blockEntityTasks = blockEntityOperations.toArray(new Runnable[0]);
            blockEntityOperations.clear();
            particleFuture = CompletableFuture.runAsync(() -> {
                timeUsageNano.set(System.nanoTime());
                for (Runnable blockEntityTask : blockEntityTasks) {
                    blockEntityTask.run();
                }
            }, EXECUTOR).exceptionally(AsyncTicker::tickExceptionally);
            blockEntityTickFuture = particleFuture;
        }
        if (levelRunning) {
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(() -> {
                for (Runnable endTickEvent : END_TICK_EVENTS) {
                    try {
                        endTickEvent.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickEvent, e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(endTickOperations = END_TICK_OPERATIONS).isEmpty()) {
            Pair[] endTickTasks = endTickOperations.toArray(new Pair[0]);
            endTickOperations.clear();
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(() -> {
                for (Pair endTickTask : endTickTasks) {
                    try {
                        ((Runnable)endTickTask.second()).run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.first(), e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(particleOperations = PARTICLE_OPERATIONS).isEmpty()) {
            Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
            particleOperations.clear();
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenCompose(v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                if (!SimplePropertiesConfig.markSyncIfTickFailed() && AsyncTicker.isTolerable(e)) {
                    LOGGER.warn("Exception while executing particle operation, you can ignore it if it doesn't happen frequently.", e);
                    return null;
                }
                throw ExceptionUtil.toThrowDirectly(e);
            })).toArray(CompletableFuture[]::new)))).thenRun(() -> timeUsageNano.set(System.nanoTime() - timeUsageNano.get()));
        }
        AsyncTicker.particleFuture = particleFuture;
        profiler.method_15407();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        class_310 mc = class_310.method_1551();
        if (!AsyncTicker.isTolerable(e) && mc.field_1687 != null && mc.field_1724 != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing before particle operation", e);
        return null;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof class_6558 || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && SimplePropertiesConfig.suppressCME();
    }

    public static void onTickingParticleException(class_703 particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        if (tolerable && !EXCEPTION_TRACKER.addException(particle.getClass(), t)) {
            return;
        }
        if (SimplePropertiesConfig.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particle.getClass())) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particle.getClass());
            }
            AsyncTicker.recordSync(particle);
        } else if (tolerable) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Exception %s thrown while ticking particle %s exceeds the threshold, please contact the author: ".formatted(t.getClass().getSimpleName(), particle.getClass())).method_10852((class_2561)class_2561.method_43470((String)"https://github.com/Harveykang/AsyncParticles/issues").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Harveykang/AsyncParticles/issues")).method_30938(Boolean.valueOf(true)))));
            }
            LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
        } else {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            ParticleRainCompat.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static class_148 constructCrashReport(class_703 particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being ticked");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particle.method_18122()).toString());
        return new class_148(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        class_702 particleEngine = class_310.method_1551().field_1713;
        Iterator<class_703> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            class_703 particle = iterator.next();
            try {
                particleEngine.method_3059(particle);
                if (!(particle instanceof class_733)) {
                    if (particle instanceof LightCachedParticleAddon) {
                        LightCachedParticleAddon lightCachedParticle = (LightCachedParticleAddon)particle;
                        if (SimplePropertiesConfig.particleLightCache()) {
                            lightCachedParticle.asyncparticles$refresh();
                        }
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.method_3086()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<? extends class_703>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<? extends class_703> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_703 particle) {
        Set<class_703> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(class_703 particle) {
        particle.method_34019().ifPresent(g -> class_310.method_1551().field_1713.method_34022(g, -1));
        if (particle.method_3086()) {
            particle.method_3085();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nblock entity operations: %d,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(SimplePropertiesConfig.isTickAsync() ? (double)timeUsageNano.get() / 1000000.0 : Double.NaN, debug_cancelled, BLOCK_ENTITY_OPERATIONS.size(), PARTICLE_OPERATIONS.size(), END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), SimplePropertiesConfig.getLimit(), class_310.method_1551().field_1713.field_3830.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), class_310.method_1551().field_1713.field_3836.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        LOGGER.info((Object)class_310.method_1551().field_1713.field_3830);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        class_702 particleEngine = class_310.method_1551().field_1713;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.method_48015();
        } else {
            BusyWaitEvictingQueue<class_703> newToAdd = new BusyWaitEvictingQueue<class_703>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.field_3836);
            particleEngine.field_3836 = newToAdd;
            BusyWaitEvictingQueue<class_733> newEmitters = new BusyWaitEvictingQueue<class_733>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.field_3837);
            particleEngine.field_3837 = newEmitters;
            particleEngine.field_3830.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<class_703> newQueue = new IterationSafeEvictingQueue<class_703>(16, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        cancelled = true;
        AsyncTicker.waitForCleanUp();
        if (blockEntityTickFuture != null) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
        if (particleFuture != null) {
            particleFuture.join();
            particleFuture = null;
        }
        BLOCK_ENTITY_OPERATIONS.clear();
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
        cancelled = false;
    }

    public static void registerEndTickEvent(MinecraftConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(class_310.method_1551()));
    }

    public static void registerEndTickEvent(ClientLevelConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(class_310.method_1551().field_1687));
    }

    public static void registerEndTickEvent(Runnable operation) {
        END_TICK_EVENTS.add(operation);
    }

    public static void addEndTickTask(class_2960 resourceLocation, MinecraftConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(class_310.method_1551()));
    }

    public static void addEndTickTask(class_2960 resourceLocation, ClientLevelConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(class_310.method_1551().field_1687));
    }

    public static void addEndTickTask(class_2960 resourceLocation, Runnable operation) {
        if (shouldTickParticles || !SimplePropertiesConfig.isTickAsync()) {
            END_TICK_OPERATIONS.add((Pair<class_2960, Runnable>)Pair.of((Object)resourceLocation, (Object)operation));
        }
    }

    static {
        END_TICK_EVENTS = new ArrayList<Runnable>();
        END_TICK_OPERATIONS = new ArrayList<Pair<class_2960, Runnable>>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, () -> SimplePropertiesConfig.tickFailurePerSecondThreshold);
        timeUsageNano = new LongRef(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
    }

    @FunctionalInterface
    public static interface MinecraftConsumer {
        public void accept(class_310 var1);
    }

    @FunctionalInterface
    public static interface ClientLevelConsumer {
        public void accept(class_638 var1);
    }
}

