/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.WeatherParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class AsyncparticlesClient {
    public static final String MOD_ID = "asyncparticles";
    public static final String ISSUE_URL = "https://github.com/Harveykang/AsyncParticles/issues";

    public static void init() {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        try {
            SimplePropertiesConfig.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            WeatherParticleAddon.CollisionFunction function;
            if (ModListHelper.VS_LOADED) {
                WeatherParticleAddon.Type.RAIN.register((level, location, originalMovement, aabb) -> {
                    class_243 shipMovement = VSClientUtils.entityMovColShipOnly(null, originalMovement, aabb, level);
                    if (shipMovement == null) {
                        return originalMovement;
                    }
                    ParticleRainCompat.onShipCollision(level, location, shipMovement, aabb);
                    return shipMovement;
                });
                function = (level, location, v, aabb) -> {
                    class_243 shipMovement = VSClientUtils.entityMovColShipOnly(null, v, aabb, level);
                    return shipMovement == null ? v : shipMovement;
                };
                WeatherParticleAddon.Type.SNOW.register(function);
                WeatherParticleAddon.Type.OTHER.register(function);
            }
            if (ModListHelper.CREATE_LOADED) {
                WeatherParticleAddon.Type.RAIN.register((level, position, motion, aabb) -> {
                    class_243 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                    if (collide == null) {
                        return motion;
                    }
                    ParticleRainCompat.onCreateCollision(level, motion, collide, aabb);
                    return collide;
                });
                function = (level, position, motion, aabb) -> {
                    class_243 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                    return collide == null ? motion : collide;
                };
                WeatherParticleAddon.Type.SNOW.register(function);
                WeatherParticleAddon.Type.OTHER.register(function);
            }
        }
    }
}

