/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.compat;

import dev.architectury.injectables.annotations.ExpectPlatform;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.fabric.ModListHelperImpl;
import org.sinytra.connector.loader.ConnectorEarlyLoader;

public class ModListHelper {
    public static final boolean IS_FORGE = ModListHelper.isForge();
    public static final boolean IS_CLIENT = ModListHelper.isClient();
    public static final boolean FABRIC_API_LOADED = ModListHelper.isModLoaded("fabric");
    public static final boolean CONNECTORMOD_LOADED = ModListHelper.isModLoaded("connectormod");
    public static final boolean VS_LOADED = ModListHelper.isModLoaded("valkyrienskies");
    public static final boolean FABRIC_VS_LOADED = ModListHelper.isFabricModLoaded("valkyrienskies");
    public static final boolean FORGE_VS_LOADED = ModListHelper.isForgeModLoaded("valkyrienskies");
    public static final boolean SODIUM_LIKE_LOADED = ModListHelper.isModLoaded("sodium") || ModListHelper.isModLoaded("embeddium");
    public static final boolean SODIUM_LOADED = ModListHelper.isModLoaded("sodium");
    public static final boolean FABRIC_SODIUM_LOADED = ModListHelper.isFabricModLoaded("sodium");
    public static final boolean FORGE_EMBEDDIUM_LOADED = ModListHelper.isForgeModLoaded("embeddium");
    public static final boolean FORGE_SODIUM_LOADED = ModListHelper.isForgeModLoaded("sodium");
    public static final boolean IRIS_LIKE_LOADED = ModListHelper.isModLoaded("iris") || ModListHelper.isModLoaded("oculus");
    public static final boolean DUMMMMMMY_LOADED = ModListHelper.isModLoaded("dummmmmmy");
    public static final boolean FABRIC_EFFECTUAL_LOADED = ModListHelper.isFabricModLoaded("effectual");
    public static final boolean FORGE_FLEROVIUM_LOADED = ModListHelper.isForgeModLoaded("flerovium");
    public static final boolean FORGE_EFFECTICULARITY_LOADED = ModListHelper.isForgeModLoaded("effective") && ModListHelper.classExists("concerrox.effective.Effective");
    public static final boolean FABRIC_EFFECTICULARITY_LOADED = ModListHelper.isFabricModLoaded("effective") && ModListHelper.classExists("concerrox.effective.Effective");
    public static final boolean FABRIC_EFFECTIVE_LOADED = ModListHelper.isFabricModLoaded("effective") && ModListHelper.classExists("org.ladysnake.effective.core.Effective");
    public static final boolean PARTICLERAIN_LOADED = ModListHelper.isModLoaded("particlerain");
    public static final boolean FABRIC_PARTICLERAIN_LOADED = ModListHelper.isFabricModLoaded("particlerain");
    public static final boolean FORGE_PARTICLERAIN_LOADED = ModListHelper.isForgeModLoaded("particlerain");
    public static final boolean FLYWHEEL_LOADED = ModListHelper.isModLoaded("flywheel");
    public static final boolean CREATE_LOADED = ModListHelper.isModLoaded("create");
    public static final boolean IS_LEGACY_CREATE = CREATE_LOADED && ModListHelper.versionCheck("create", "0.5", "6.0");
    public static final boolean FABRIC_CREATE_LOADED = ModListHelper.isFabricModLoaded("create");
    public static final boolean FORGE_CREATE_LOADED = ModListHelper.isForgeModLoaded("create");
    public static final boolean EPICFIGHT_LOADED = ModListHelper.isModLoaded("epicfight");
    public static final boolean FORGE_EPICFIGHT_LOADED = ModListHelper.isForgeModLoaded("epicfight");
    public static final boolean FORGE_EPICACG_LOADED = ModListHelper.isForgeModLoaded("epicacg");
    public static final boolean A_GOOD_PLACE_LOADED = ModListHelper.isModLoaded("a_good_place");
    public static final boolean FORGE_GATEWAYS_LOADED = ModListHelper.isForgeModLoaded("gateways");
    public static final boolean TOMBSTONE_LOADED = ModListHelper.isModLoaded("tombstone");
    public static final boolean FABRIC_PARTICULAR_LOADED = ModListHelper.isFabricModLoaded("particular");
    public static final boolean FORGE_PARTICULAR_LOADED = ModListHelper.isForgeModLoaded("particular");
    public static final boolean PARTICLE_CORE_LOADED = ModListHelper.isModLoaded("particle_core");
    public static final boolean PHYSICSMOD_LOADED = ModListHelper.isModLoaded("physicsmod");
    public static final boolean FABRIC_PHYSICSMOD_LOADED = ModListHelper.isFabricModLoaded("physicsmod");
    public static final boolean FORGE_PHYSICSMOD_LOADED = ModListHelper.isForgeModLoaded("physicsmod");
    public static final boolean FORGE_DRACONIC_EVOLUTION_LOADED = ModListHelper.isForgeModLoaded("draconicevolution");
    public static final boolean MODERN_UI_LOADED = ModListHelper.isModLoaded("modernui");
    public static final boolean SUBTLE_EFFECTS_LOADED = ModListHelper.isModLoaded("subtle_effects");
    public static final boolean FABRIC_SUBTLE_EFFECTS_LOADED = ModListHelper.isFabricModLoaded("subtle_effects");
    public static final boolean FORGE_SUBTLE_EFFECTS_LOADED = ModListHelper.isForgeModLoaded("subtle_effects");
    public static final boolean WATUT_LOADED = ModListHelper.isModLoaded("watut");
    public static final boolean FORGE_WEATHER2_LOADED = ModListHelper.isForgeModLoaded("weather2");
    public static final boolean VULKAN_MOD_LOADED = ModListHelper.isModLoaded("vulkanmod");
    public static final boolean FABRIC_VULKAN_MOD_LOADED = ModListHelper.isFabricModLoaded("vulkanmod");
    public static final boolean LODESTONE_LOADED = ModListHelper.isModLoaded("lodestone");

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isForge() {
        return ModListHelperImpl.isForge();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isClient() {
        return ModListHelperImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return ModListHelperImpl.isModLoaded(modId);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean versionCheck(String modId, String minInclusive, String maxExclusive) {
        void var2_2;
        void var1_1;
        return ModListHelperImpl.versionCheck(modId, (String)var1_1, (String)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String versionToString(String modId) {
        return ModListHelperImpl.versionToString(modId);
    }

    public static boolean isForgeModLoaded(String modId) {
        return IS_FORGE && ModListHelper.isModLoaded(modId) && (!CONNECTORMOD_LOADED || !ConnectorEarlyLoader.isConnectorMod((String)modId));
    }

    public static boolean isFabricModLoaded(String modId) {
        return IS_FORGE ? CONNECTORMOD_LOADED && ConnectorEarlyLoader.isConnectorMod((String)modId) : ModListHelper.isModLoaded(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return ModListHelperImpl.isDevelopmentEnvironment();
    }

    public static boolean classExists(String className) {
        return ModListHelper.class.getClassLoader().getResource(className.replace(".", "/") + ".class") != null;
    }
}

