/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.compat.vs2;

import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.ShipHitResult;
import fabric.fun.qu_an.minecraft.asyncparticles.client.mixin.vs2.InvokerEntityShipCollisionUtils;
import fabric.fun.qu_an.minecraft.asyncparticles.client.mixin.vs2.InvokerRaycastUtils;
import java.util.List;
import kotlin.Pair;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.collision.ConvexPolygonc;
import org.valkyrienskies.core.apigame.collision.EntityPolygonCollider;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.EntityShipCollisionUtils;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.BugFixUtil;

public class VSClientUtils {
    private static final EntityPolygonCollider collider = ValkyrienSkiesMod.vsCore.getEntityPolygonCollider();

    public static Iterable<ClientShip> getShipsInAABB(class_638 level, Vector3d v1, Vector3d v2) {
        return VSClientUtils.getShipsInAABB(level, new AABBd((Vector3dc)v1, (Vector3dc)v2));
    }

    public static Iterable<ClientShip> getShipsInAABB(class_638 world, double x1, double y1, double z1, double x2, double y2, double z2) {
        return VSClientUtils.getShipsInAABB(world, new AABBd(x1, y1, z1, x2, y2, z2));
    }

    public static Iterable<ClientShip> getShipsInAABB(class_638 world, AABBd aabb) {
        return VSGameUtilsKt.getShipObjectWorld((class_638)world).getLoadedShips().getIntersecting((AABBdc)aabb.correctBounds());
    }

    public static Pair<class_243, ClientShip> entityMovColShipOnlyAndGet(@Nullable class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_638 world) {
        double inflation = entity instanceof class_1657 ? 0.5 : 0.1;
        double stepHeight = entity != null ? (double)entity.method_49476() : 0.0;
        double yMovement = movement.method_10214() + Math.max(stepHeight - inflation, 0.0);
        List<ConvexPolygonc> collidingShipPolygons = ((InvokerEntityShipCollisionUtils)EntityShipCollisionUtils.INSTANCE).invoker_getShipPolygonsCollidingWithEntity(entity, new class_243(movement.method_10216(), yMovement, movement.method_10215()), entityBoundingBox.method_1014(inflation), (class_1937)world);
        if (collidingShipPolygons.isEmpty()) {
            return new Pair((Object)movement, null);
        }
        Pair pair = collider.adjustEntityMovementForPolygonCollisions((Vector3dc)VectorConversionsMCKt.toJOML((class_243)movement), (AABBdc)VectorConversionsMCKt.toJOML((class_238)entityBoundingBox), stepHeight, collidingShipPolygons);
        Vector3dc newMovement = (Vector3dc)pair.getFirst();
        Long shipCollidingWith = (Long)pair.getSecond();
        if (shipCollidingWith != null) {
            if (entity != null) {
                ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
            }
            return new Pair((Object)VectorConversionsMCKt.toMinecraft((Vector3dc)newMovement), (Object)((ClientShip)VSGameUtilsKt.getShipObjectWorld((class_638)world).getAllShips().getById(shipCollidingWith.longValue())));
        }
        return new Pair((Object)VectorConversionsMCKt.toMinecraft((Vector3dc)newMovement), null);
    }

    public static boolean isEntityMovColShipOnly(@Nullable class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_638 world, double inflation) {
        double stepHeight = entity != null ? (double)entity.method_49476() : 0.0;
        double yMovement = movement.method_10214() + Math.max(stepHeight - inflation, 0.0);
        class_243 movement1 = new class_243(movement.method_10216(), yMovement, movement.method_10215());
        class_238 bb = entityBoundingBox.method_1014(inflation);
        return VSClientUtils.hasShipPolygonsCollidingWithEntity(entity, movement1, bb, world);
    }

    public static boolean hasShipPolygonsCollidingWithEntity(class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_638 world) {
        class_238 entityBoxWithMovement = entityBoundingBox.method_18804(movement);
        AABBd entityBoundingBoxExtended = AABBdUtilKt.extend((AABBd)VectorConversionsMCKt.toJOML((class_238)entityBoundingBox), (Vector3dc)VectorConversionsMCKt.toJOML((class_243)movement));
        for (ClientShip shipObject : VSGameUtilsKt.getShipObjectWorld((class_638)world).getLoadedShips().getIntersecting((AABBdc)entityBoundingBoxExtended)) {
            Iterable shipBlockCollisionStream;
            ShipTransform shipTransform = shipObject.getTransform();
            ConvexPolygonc entityPolyInShipCoordinates = collider.createPolygonFromAABB((AABBdc)VectorConversionsMCKt.toJOML((class_238)entityBoxWithMovement), shipTransform.getWorldToShip(), null);
            AABBd entityBoundingBoxInShipCoordinates = entityPolyInShipCoordinates.getEnclosingAABB(new AABBd());
            if (BugFixUtil.INSTANCE.isCollisionBoxToBig(VectorConversionsMCKt.toMinecraft((AABBdc)entityBoundingBoxInShipCoordinates)) || !(shipBlockCollisionStream = world.method_20812(entity, VectorConversionsMCKt.toMinecraft((AABBdc)entityBoundingBoxInShipCoordinates))).iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityMovColShipOnly(@Nullable class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_638 world) {
        double inflation = entity instanceof class_1657 ? 0.5 : 0.1;
        return VSClientUtils.isEntityMovColShipOnly(entity, movement, entityBoundingBox, world, inflation);
    }

    @Nullable
    public static class_243 entityMovColShipOnly(@Nullable class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_638 world, double inflation, double stepHeight) {
        if (entity != null) {
            stepHeight = entity.method_49476();
        }
        double yMovement = movement.method_10214() + Math.max(stepHeight - inflation, 0.0);
        List<ConvexPolygonc> collidingShipPolygons = ((InvokerEntityShipCollisionUtils)EntityShipCollisionUtils.INSTANCE).invoker_getShipPolygonsCollidingWithEntity(entity, new class_243(movement.method_10216(), yMovement, movement.method_10215()), entityBoundingBox.method_1014(inflation), (class_1937)world);
        if (collidingShipPolygons.isEmpty()) {
            return null;
        }
        Pair pair = collider.adjustEntityMovementForPolygonCollisions((Vector3dc)VectorConversionsMCKt.toJOML((class_243)movement), (AABBdc)VectorConversionsMCKt.toJOML((class_238)entityBoundingBox), stepHeight, collidingShipPolygons);
        Vector3dc newMovement = (Vector3dc)pair.getFirst();
        Long shipCollidingWith = (Long)pair.getSecond();
        if (shipCollidingWith == null) {
            return null;
        }
        if (entity != null) {
            ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
            return VectorConversionsMCKt.toMinecraft((Vector3dc)newMovement);
        }
        ClientShip ship = (ClientShip)VSGameUtilsKt.getShipObjectWorld((class_638)world).getLoadedShips().getById(shipCollidingWith.longValue());
        if (ship == null) {
            return null;
        }
        Vector3dc velocity = ship.getVelocity();
        return new class_243(0.05 * velocity.x() + newMovement.x(), 0.05 * velocity.y() + newMovement.y(), 0.05 * velocity.z() + newMovement.z());
    }

    @Nullable
    public static class_243 entityMovColShipOnly(@Nullable class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_638 world) {
        double inflation = entity instanceof class_1657 ? 0.5 : 0.1;
        return VSClientUtils.entityMovColShipOnly(entity, movement, entityBoundingBox, world, inflation, 0.0);
    }

    public static class_243 entityMovColShipOnly(class_243 movement, class_238 entityBoundingBox, class_638 world, double inflation, double stepHeight) {
        return VSClientUtils.entityMovColShipOnly(null, movement, entityBoundingBox, world, inflation, stepHeight);
    }

    public static ShipHitResult clipShip(class_638 level, class_3959 ctx, boolean shouldTransformHitPos) {
        ClientShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld((class_638)level);
        ShipHitResult closestHit = null;
        class_243 closestHitPos = null;
        double closestHitDist = Double.MAX_VALUE;
        AABBd clipAABB = new AABBd((Vector3dc)VectorConversionsMCKt.toJOML((class_243)ctx.method_17750()), (Vector3dc)VectorConversionsMCKt.toJOML((class_243)ctx.method_17747())).correctBounds();
        for (ClientShip ship : shipObjectWorld.getLoadedShips().getIntersecting((AABBdc)clipAABB)) {
            class_243 shipEnd;
            class_243 shipStart;
            class_3965 shipHit;
            Matrix4dc worldToShip = ship.getWorldToShip();
            Matrix4dc shipToWorld = ship.getShipToWorld();
            Vector3d worldPos = shipToWorld.transformPosition(VectorConversionsMCKt.toJOML((class_243)(shipHit = InvokerRaycastUtils.invoker_clip((class_1937)level, ctx, shipStart = VectorConversionsMCKt.toMinecraft((Vector3dc)worldToShip.transformPosition(VectorConversionsMCKt.toJOML((class_243)ctx.method_17750()))), shipEnd = VectorConversionsMCKt.toMinecraft((Vector3dc)worldToShip.transformPosition(VectorConversionsMCKt.toJOML((class_243)ctx.method_17747()))))).method_17784()));
            class_243 shipHitPos = VectorConversionsMCKt.toMinecraft((Vector3dc)worldPos);
            double shipHitDist = shipHitPos.method_1025(ctx.method_17750());
            if (!(shipHitDist < closestHitDist) || shipHit.method_17783() == class_239.class_240.field_1333) continue;
            Vector3d newPosInShipLocal = worldPos.sub(ship.getTransform().getPositionInWorld());
            Vector3d shipVelocity = new Vector3d(ship.getVelocity()).add((Vector3dc)new Vector3d(ship.getOmega()).cross((Vector3dc)newPosInShipLocal)).mul(0.05);
            closestHit = ShipHitResult.of(shipHit, worldToShip, shipToWorld, new class_243(shipVelocity.x(), shipVelocity.y(), shipVelocity.z()));
            closestHitPos = shipHitPos;
            closestHitDist = shipHitDist;
        }
        if (shouldTransformHitPos && closestHit != null) {
            closestHit.field_1329 = closestHitPos;
        }
        return closestHit;
    }

    public static boolean isUnderHeightMapIncludeShips(class_638 level, double x, double y, double z, int size) {
        if ((double)level.method_8624(class_2902.class_2903.field_13197, class_3532.method_15357((double)x), class_3532.method_15357((double)z)) >= y) {
            return true;
        }
        return VSClientUtils.isUnderShipHeightMap(level, x, y, z, size);
    }

    public static boolean isUnderShipHeightMap(class_638 level, double x, double y, double z, double size) {
        ClientShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld((class_638)level);
        for (ClientShip nearbyShip : shipObjectWorld.getLoadedShips().getIntersecting((AABBdc)new AABBd(x - 1.0, y - 1.0, z - 1.0, x + 1.0, Math.max(y + 16.0, (double)level.method_31600()), z + 1.0))) {
            Vector3d posInShip = nearbyShip.getWorldToShip().transformPosition(new Vector3d(x, y, z));
            if (!((double)level.method_8624(class_2902.class_2903.field_13197, class_3532.method_15357((double)posInShip.x), class_3532.method_15357((double)posInShip.z)) >= posInShip.y - size)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnderShipHeightMap(class_638 level, class_243 pos, int size) {
        return VSClientUtils.isUnderShipHeightMap(level, pos.field_1352, pos.field_1351, pos.field_1350, size);
    }

    public static boolean isUnderShipHeightMap(class_638 level, class_243 pos, Matrix4dc worldToShip) {
        Vector3d posInShip = worldToShip.transformPosition(VectorConversionsMCKt.toJOML((class_243)pos));
        return (double)level.method_8624(class_2902.class_2903.field_13197, class_3532.method_15357((double)posInShip.x), class_3532.method_15357((double)posInShip.z)) >= posInShip.y;
    }

    public static boolean isOutOfSight(class_703 particle) {
        double x1 = particle.field_3874;
        double y1 = particle.field_3854;
        double z1 = particle.field_3871;
        double inWorldX1 = x1;
        double inWorldZ1 = z1;
        Ship ship1 = VSGameUtilsKt.getShipManagingPos((class_1937)particle.field_3851, (double)x1, (double)y1, (double)z1);
        if (ship1 != null) {
            Matrix4dc m = ship1.getShipToWorld();
            inWorldX1 = m.m00() * x1 + m.m10() * y1 + m.m20() * z1 + m.m30();
            inWorldZ1 = m.m02() * x1 + m.m12() * y1 + m.m22() * z1 + m.m32();
        }
        class_310 mc = class_310.method_1551();
        int renderDistance = mc.field_1769.field_4062 << 4;
        class_4184 camera = mc.field_1773.method_19418();
        class_243 pos = camera.method_19326();
        return Math.abs(pos.field_1352 - inWorldX1) > (double)renderDistance || Math.abs(pos.field_1350 - inWorldZ1) > (double)renderDistance;
    }
}

