/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.util;

import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;

public class ExceptionTracker<T> {
    private final Map<T, Map<Class<? extends Throwable>, ExceptionQueue>> exceptions = new ConcurrentHashMap<T, Map<Class<? extends Throwable>, ExceptionQueue>>();
    private final IntSupplier duration;
    private final IntSupplier failurePerSecThreshold;

    public ExceptionTracker(IntSupplier duration, IntSupplier failurePerSecThreshold) {
        this.failurePerSecThreshold = failurePerSecThreshold;
        this.duration = duration;
    }

    public boolean addException(T obj, Throwable t) {
        return this.exceptions.computeIfAbsent(obj, k -> new ConcurrentHashMap()).computeIfAbsent(ExceptionUtil.getRootCause(t).getClass(), k -> new ExceptionQueue()).push();
    }

    public String toString() {
        return "ExceptionTracker{exceptions=" + String.valueOf(this.exceptions) + ", duration=" + this.duration.getAsInt() + ", failurePerSecThreshold=" + this.failurePerSecThreshold.getAsInt() + "}";
    }

    private class ExceptionQueue {
        private final LongPriorityQueue queue = new LongArrayFIFOQueue();

        private ExceptionQueue() {
        }

        public boolean push() {
            long time = System.currentTimeMillis();
            LongPriorityQueue queue = this.queue;
            queue.enqueue(time);
            int size = queue.size();
            while (--size >= 0 && time - queue.firstLong() > (long)ExceptionTracker.this.duration.getAsInt()) {
                queue.dequeueLong();
            }
            return (double)queue.size() / ((double)ExceptionTracker.this.duration.getAsInt() * 0.001) >= (double)ExceptionTracker.this.failurePerSecThreshold.getAsInt();
        }

        public String toString() {
            return "Exception queue size: " + this.queue.size();
        }
    }
}

