/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Supplier;

public class ReentrantSpinLock
implements AutoCloseable {
    private static final VarHandle OWNER;
    private volatile Thread owner;
    private int holdCount;

    public void lock() {
        Thread currentThread = Thread.currentThread();
        if (!OWNER.compareAndSet(this, null, currentThread)) {
            if (currentThread == this.owner) {
                ++this.holdCount;
                return;
            }
            while (!OWNER.compareAndSet(this, null, currentThread)) {
                Thread.onSpinWait();
            }
        }
        this.holdCount = 1;
    }

    public void unlock() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.owner) {
            throw new IllegalMonitorStateException("Attempt to unlock a lock held by another thread!");
        }
        if (--this.holdCount == 0) {
            this.owner = null;
        }
    }

    @Override
    public void close() {
        this.unlock();
    }

    public ReentrantSpinLock sugar() {
        this.lock();
        return this;
    }

    public void wrap(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public <T> T wrap(Supplier<T> supplier) {
        this.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.unlock();
        }
    }

    static {
        try {
            OWNER = MethodHandles.lookup().findVarHandle(ReentrantSpinLock.class, "owner", Thread.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

