/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client;

import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.LongRef;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Particle> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> BLOCK_ENTITY_OPERATIONS = new ArrayList<Runnable>();
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static boolean cancelled = false;
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<Runnable> END_TICK_EVENTS;
    private static final List<Pair<ResourceLocation, Runnable>> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static CompletableFuture<Void> blockEntityTickFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ExecutorService EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final LongRef timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onRunAllTasks() {
        if (!SimplePropertiesConfig.isTickAsync()) {
            return;
        }
        if (blockEntityTickFuture != null && !SimplePropertiesConfig.greedyAsyncClientBlockEntityTick()) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
    }

    public static void onTickBefore(int i, int to) {
        boolean levelRunning;
        if (!SimplePropertiesConfig.isTickAsync()) {
            return;
        }
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("async_particles");
        if (blockEntityTickFuture != null && (i != 0 || SimplePropertiesConfig.greedyAsyncClientBlockEntityTick())) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = levelRunning = mc.f_91073_ != null && mc.f_91074_ != null && !mc.m_91104_();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            cancelled = true;
            debug_cancelled = false;
            if (particleFuture != null) {
                particleFuture.join();
                particleFuture = null;
            }
            cancelled = false;
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                ParticleEngine particleEngine = mc.f_91061_;
                Collection values = particleEngine.f_107289_.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                int k = 0;
                Queue trackingEmitters = particleEngine.f_107290_;
                futures[k++] = trackingEmitters.isEmpty() ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.m_107276_()), EXECUTOR);
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = CompletableFuture.completedFuture(null);
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        boolean b;
                        boolean bl = ((ParticleAddon)particle1).asyncparticles$isTickSync() ? !particle1.m_107276_() : (b = ((ParticleAddon)particle1).asyncparticles$shouldRemove());
                        if (b) {
                            particle1.m_142654_().ifPresent(group -> particleEngine.m_172281_(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.m_7238_();
    }

    public static void onTickAfter(int i, int to) {
        List<Runnable> particleOperations;
        List<Pair<ResourceLocation, Runnable>> endTickOperations;
        CompletionStage<Void> particleFuture;
        boolean levelRunning;
        if (!SimplePropertiesConfig.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(p -> ((Runnable)p.second()).run());
            END_TICK_OPERATIONS.clear();
            END_TICK_EVENTS.forEach(Runnable::run);
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6180_("async_particles");
        boolean bl = levelRunning = mc.f_91073_ != null && mc.f_91074_ != null && !mc.m_91104_();
        if (levelRunning) {
            profiler.m_6180_("particle_tick");
            if (i == to - 1) {
                mc.f_91061_.m_107388_();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.m_7238_();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        List<Runnable> blockEntityOperations = BLOCK_ENTITY_OPERATIONS;
        if (!levelRunning || !SimplePropertiesConfig.asyncBlockEntityTick()) {
            particleFuture = CompletableFuture.runAsync(() -> timeUsageNano.set(System.nanoTime()), EXECUTOR);
            if (!blockEntityOperations.isEmpty()) {
                blockEntityOperations.clear();
            }
        } else {
            Runnable[] blockEntityTasks = blockEntityOperations.toArray(new Runnable[0]);
            blockEntityOperations.clear();
            particleFuture = CompletableFuture.runAsync(() -> {
                timeUsageNano.set(System.nanoTime());
                for (Runnable blockEntityTask : blockEntityTasks) {
                    blockEntityTask.run();
                }
            }, EXECUTOR).exceptionally(AsyncTicker::tickExceptionally);
            blockEntityTickFuture = particleFuture;
        }
        if (levelRunning) {
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(() -> {
                for (Runnable endTickEvent : END_TICK_EVENTS) {
                    try {
                        endTickEvent.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickEvent, e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(endTickOperations = END_TICK_OPERATIONS).isEmpty()) {
            Pair[] endTickTasks = endTickOperations.toArray(new Pair[0]);
            endTickOperations.clear();
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(() -> {
                for (Pair endTickTask : endTickTasks) {
                    try {
                        ((Runnable)endTickTask.second()).run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.first(), e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(particleOperations = PARTICLE_OPERATIONS).isEmpty()) {
            Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
            particleOperations.clear();
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenCompose(v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                if (!SimplePropertiesConfig.markSyncIfTickFailed() && AsyncTicker.isTolerable(e)) {
                    LOGGER.warn("Exception while executing particle operation, you can ignore it if it doesn't happen frequently.", e);
                    return null;
                }
                throw ExceptionUtil.toThrowDirectly(e);
            })).toArray(CompletableFuture[]::new)))).thenRun(() -> timeUsageNano.set(System.nanoTime() - timeUsageNano.get()));
        }
        AsyncTicker.particleFuture = particleFuture;
        profiler.m_7238_();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!AsyncTicker.isTolerable(e) && mc.f_91073_ != null && mc.f_91074_ != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing before particle operation", e);
        return null;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof MissingPaletteEntryException || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && SimplePropertiesConfig.suppressCME();
    }

    public static void onTickingParticleException(Particle particle, Throwable t) {
        boolean tolerable = AsyncTicker.isTolerable(t);
        if (tolerable && !EXCEPTION_TRACKER.addException(particle.getClass(), t)) {
            return;
        }
        if (SimplePropertiesConfig.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particle.getClass())) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particle.getClass());
            }
            AsyncTicker.recordSync(particle);
        } else if (tolerable) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)"Exception %s thrown while ticking particle %s exceeds the threshold, please contact the author: ".formatted(t.getClass().getSimpleName(), particle.getClass())).m_7220_((Component)Component.m_237113_((String)"https://github.com/Harveykang/AsyncParticles/issues").m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Harveykang/AsyncParticles/issues")).m_131162_(Boolean.valueOf(true)))));
            }
            LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
        } else {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            ParticleRainCompat.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static ReportedException constructCrashReport(Particle particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Ticking Particle");
        CrashReportCategory crashReportCategory = crashReport.m_127514_("Particle being ticked");
        crashReportCategory.m_128165_("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.m_128165_("Particle Type", () -> ((ParticleRenderType)particle.m_7556_()).toString());
        return new ReportedException(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        Iterator<Particle> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            try {
                particleEngine.m_107393_(particle);
                if (!(particle instanceof TrackingEmitter)) {
                    if (particle instanceof LightCachedParticleAddon) {
                        LightCachedParticleAddon lightCachedParticle = (LightCachedParticleAddon)particle;
                        if (SimplePropertiesConfig.particleLightCache()) {
                            lightCachedParticle.asyncparticles$refresh();
                        }
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.m_107276_()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<? extends Particle> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(Particle particle) {
        Set<Particle> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(Particle particle) {
        particle.m_142654_().ifPresent(g -> Minecraft.m_91087_().f_91061_.m_172281_(g, -1));
        if (particle.m_107276_()) {
            particle.m_107274_();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nblock entity operations: %d,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(SimplePropertiesConfig.isTickAsync() ? (double)timeUsageNano.get() / 1000000.0 : Double.NaN, debug_cancelled, BLOCK_ENTITY_OPERATIONS.size(), PARTICLE_OPERATIONS.size(), END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), SimplePropertiesConfig.getLimit(), Minecraft.m_91087_().f_91061_.f_107289_.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), Minecraft.m_91087_().f_91061_.f_107294_.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        LOGGER.info((Object)Minecraft.m_91087_().f_91061_.f_107289_);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.m_263560_();
        } else {
            BusyWaitEvictingQueue<Particle> newToAdd = new BusyWaitEvictingQueue<Particle>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.f_107294_);
            particleEngine.f_107294_ = newToAdd;
            BusyWaitEvictingQueue<TrackingEmitter> newEmitters = new BusyWaitEvictingQueue<TrackingEmitter>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.f_107290_);
            particleEngine.f_107290_ = newEmitters;
            particleEngine.f_107289_.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<Particle> newQueue = new IterationSafeEvictingQueue<Particle>(16, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        cancelled = true;
        AsyncTicker.waitForCleanUp();
        if (blockEntityTickFuture != null) {
            blockEntityTickFuture.join();
            blockEntityTickFuture = null;
        }
        if (particleFuture != null) {
            particleFuture.join();
            particleFuture = null;
        }
        BLOCK_ENTITY_OPERATIONS.clear();
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
        cancelled = false;
    }

    public static void registerEndTickEvent(MinecraftConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(Minecraft.m_91087_()));
    }

    public static void registerEndTickEvent(ClientLevelConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(Minecraft.m_91087_().f_91073_));
    }

    public static void registerEndTickEvent(Runnable operation) {
        END_TICK_EVENTS.add(operation);
    }

    public static void addEndTickTask(ResourceLocation resourceLocation, MinecraftConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(Minecraft.m_91087_()));
    }

    public static void addEndTickTask(ResourceLocation resourceLocation, ClientLevelConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(Minecraft.m_91087_().f_91073_));
    }

    public static void addEndTickTask(ResourceLocation resourceLocation, Runnable operation) {
        if (shouldTickParticles || !SimplePropertiesConfig.isTickAsync()) {
            END_TICK_OPERATIONS.add((Pair<ResourceLocation, Runnable>)Pair.of((Object)resourceLocation, (Object)operation));
        }
    }

    static {
        END_TICK_EVENTS = new ArrayList<Runnable>();
        END_TICK_OPERATIONS = new ArrayList<Pair<ResourceLocation, Runnable>>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, () -> SimplePropertiesConfig.tickFailurePerSecondThreshold);
        timeUsageNano = new LongRef(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.m_14045_((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::m_137495_, true);
    }

    @FunctionalInterface
    public static interface MinecraftConsumer {
        public void accept(Minecraft var1);
    }

    @FunctionalInterface
    public static interface ClientLevelConsumer {
        public void accept(ClientLevel var1);
    }
}

