/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client;

import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.WeatherParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import java.io.IOException;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AsyncparticlesClient {
    public static final String MOD_ID = "asyncparticles";
    public static final String ISSUE_URL = "https://github.com/Harveykang/AsyncParticles/issues";

    public static void init() {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        try {
            SimplePropertiesConfig.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            WeatherParticleAddon.CollisionFunction function;
            if (ModListHelper.VS_LOADED) {
                WeatherParticleAddon.Type.RAIN.register((level, location, originalMovement, aabb) -> {
                    Vec3 shipMovement = VSClientUtils.entityMovColShipOnly(null, originalMovement, aabb, level);
                    if (shipMovement == null) {
                        return originalMovement;
                    }
                    ParticleRainCompat.onShipCollision(level, location, shipMovement, aabb);
                    return shipMovement;
                });
                function = (level, location, v, aabb) -> {
                    Vec3 shipMovement = VSClientUtils.entityMovColShipOnly(null, v, aabb, level);
                    return shipMovement == null ? v : shipMovement;
                };
                WeatherParticleAddon.Type.SNOW.register(function);
                WeatherParticleAddon.Type.OTHER.register(function);
            }
            if (ModListHelper.CREATE_LOADED) {
                WeatherParticleAddon.Type.RAIN.register((level, position, motion, aabb) -> {
                    Vec3 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                    if (collide == null) {
                        return motion;
                    }
                    ParticleRainCompat.onCreateCollision(level, motion, collide, aabb);
                    return collide;
                });
                function = (level, position, motion, aabb) -> {
                    Vec3 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                    return collide == null ? motion : collide;
                };
                WeatherParticleAddon.Type.SNOW.register(function);
                WeatherParticleAddon.Type.OTHER.register(function);
            }
        }
    }
}

