/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.physicsmod;

import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.ShipHitResult;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import net.diebuddies.physics.snow.math.AABB3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class PhysicsModCompat {
    public static boolean isCollideWithShip(ClientLevel level, Vec3 movement, AABB3D aabb) {
        Vector3d min = aabb.getMin();
        Vector3d max = aabb.getMax();
        return VSClientUtils.isEntityMovColShipOnly(null, movement, new AABB(min.x, min.y, min.z, max.x, max.y, max.z), level);
    }

    public static void onShipCollide(ClientLevel level, Vec3 location, Vec3 movement) {
        if ((double)level.f_46441_.m_188501_() > 0.1) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ShipHitResult hit = VSClientUtils.clipShip(level, new ClipContext(location, location.m_82549_(movement.m_82490_(2.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)mc.f_91074_), true);
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        Vec3 shipMotion = hit.shipMotion;
        if (!SimplePropertiesConfig.doVsShipRainEffectsIfMoving() && Math.abs(shipMotion.m_82556_()) > 0.01) {
            return;
        }
        Vec3 spawnPos = hit.m_82450_().m_82549_(shipMotion);
        FluidState fluidState = level.m_6425_(hit.m_82425_());
        if (fluidState.m_76178_()) {
            mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static boolean collideWithContraptions(ClientLevel level, Vec3 movement, AABB3D aabb, boolean rain) {
        Vector3d min = aabb.getMin();
        Vector3d max = aabb.getMax();
        Vec3 clipMotion = CreateUtil.collideMotionWithContraptions(level, movement, new AABB(min.x - 0.1, min.y - 0.1, min.z - 0.1, max.x + 0.1, max.y + 0.1, max.z + 0.1));
        if (clipMotion == null) {
            return false;
        }
        if (!rain || (double)level.f_46441_.m_188501_() > 0.1) {
            return true;
        }
        double centerX = min.x + aabb.getWidth() / 2.0;
        double centerZ = min.z + aabb.getDepth() / 2.0;
        Vec3 startPos = new Vec3(centerX, min.y, centerZ);
        Vec3 spawnPos = startPos.m_82549_(clipMotion);
        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
        return true;
    }
}

