/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.forge;

import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncparticlesClient;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class APMixinPluginForge
implements IMixinConfigPlugin {
    private static final int PACKAGE_LENGTH = AsyncparticlesClient.class.getPackage().getName().length() + ".mixin.forge.".length();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!ModListHelper.IS_CLIENT) {
            return false;
        }
        String mixinPackageName = mixinClassName.substring(PACKAGE_LENGTH);
        String[] split = mixinPackageName.split("\\.");
        if (split.length == 1) {
            return true;
        }
        return switch (split[0]) {
            case "particlerain_vs" -> {
                if (ModListHelper.FORGE_PARTICLERAIN_LOADED && ModListHelper.VS_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "particlerain_create" -> {
                if (ModListHelper.FORGE_PARTICLERAIN_LOADED && ModListHelper.CREATE_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "particlerain" -> {
                if (!ModListHelper.FORGE_PARTICLERAIN_LOADED) {
                    yield false;
                }
                if (split.length == 2) {
                    yield true;
                }
                switch (split[1]) {
                    case "v1_1_2": {
                        yield ModListHelper.versionCheck("particlerain", null, "1.1.3");
                    }
                    case "v1_1_3": {
                        yield ModListHelper.versionCheck("particlerain", "1.1.3", null);
                    }
                }
                yield true;
            }
            case "create" -> {
                if (ModListHelper.FORGE_CREATE_LOADED && !ModListHelper.IS_LEGACY_CREATE) {
                    yield true;
                }
                yield false;
            }
            case "effecticularity_v1_0_2" -> {
                if (ModListHelper.FORGE_EFFECTICULARITY_LOADED && ModListHelper.versionCheck("effective", "1.0.0", "1.0.3")) {
                    yield true;
                }
                yield false;
            }
            case "flerovium" -> ModListHelper.FORGE_FLEROVIUM_LOADED;
            case "embeddium" -> ModListHelper.FORGE_EMBEDDIUM_LOADED;
            case "epicfight" -> ModListHelper.FORGE_EPICFIGHT_LOADED;
            case "epicacg" -> ModListHelper.FORGE_EPICACG_LOADED;
            case "gateways" -> ModListHelper.FORGE_GATEWAYS_LOADED;
            case "subtle_effects" -> ModListHelper.FORGE_SUBTLE_EFFECTS_LOADED;
            case "weather2" -> ModListHelper.FORGE_WEATHER2_LOADED;
            case "weather2_vs" -> {
                if (ModListHelper.FORGE_WEATHER2_LOADED && ModListHelper.VS_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "weather2_create" -> {
                if (ModListHelper.FORGE_WEATHER2_LOADED && ModListHelper.CREATE_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "particular" -> ModListHelper.FORGE_PARTICULAR_LOADED;
            default -> throw new IllegalArgumentException("Unknown forge mixin: " + mixinClassName);
        };
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

