/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.SimplePropertiesConfig;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine {
    @Shadow
    public Queue<Particle> f_107294_;
    @Shadow
    @Final
    public Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    protected ClientLevel f_107287_;
    @Mutable
    @Shadow
    public Queue<TrackingEmitter> f_107290_;
    @Shadow
    @Mutable
    public static List<ParticleRenderType> f_107288_;
    @Shadow
    @Final
    public TextureManager f_107291_;

    @Shadow
    public abstract void m_107393_(Particle var1);

    @Inject(method={"tickParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")})
    public void onTickParticle(Particle particle, CallbackInfo ci, @Local Throwable t) {
        if (SimplePropertiesConfig.isTickAsync()) {
            throw ExceptionUtil.toThrowDirectly(t);
        }
    }

    @Overwrite
    public void m_107388_() {
        this.f_107289_.forEach((particleRenderType, queue) -> {
            ProfilerFiller profiler = this.f_107287_.m_46473_();
            profiler.m_6180_(particleRenderType.toString());
            AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.m_107384_((Collection<Particle>)queue));
            profiler.m_7238_();
        });
        AsyncTicker.PARTICLE_OPERATIONS.add(this::asyncparticles$tickEmitters);
        AsyncTicker.waitForCleanUp();
        if (!this.f_107294_.isEmpty()) {
            for (Particle particle : this.f_107294_) {
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                }
                Queue queue2 = this.f_107289_.computeIfAbsent(particle.m_7556_(), k -> {
                    IterationSafeEvictingQueue<Particle> queue1 = new IterationSafeEvictingQueue<Particle>(16, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
                    AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.m_107384_(queue1));
                    if (!ModListHelper.IS_FORGE && k != ParticleRenderType.f_107434_ && !f_107288_.contains(k)) {
                        this.asyncparticles_Neo$addToOrderList((ParticleRenderType)k);
                    }
                    return queue1;
                });
                queue2.add(particle);
            }
            this.f_107294_.clear();
        }
    }

    @Unique
    private void asyncparticles$tickEmitters() {
        for (TrackingEmitter emitter : this.f_107290_) {
            if (AsyncTicker.isCancelled() && !SimplePropertiesConfig.forceDoneParticleTick()) {
                return;
            }
            if (!emitter.m_107276_()) continue;
            if (((ParticleAddon)emitter).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync((Particle)emitter);
                continue;
            }
            try {
                emitter.m_5989_();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException((Particle)emitter, t);
            }
        }
    }

    @Unique
    private void asyncparticles_Neo$addToOrderList(ParticleRenderType k) {
        ArrayList<ParticleRenderType> list = new ArrayList<ParticleRenderType>(f_107288_.size() + 1);
        for (ParticleRenderType type : f_107288_) {
            if (AsyncRenderer.getVertexFormatPair(type, this.f_107291_) == AsyncRenderer.EMPTY_FORMAT) continue;
            list.add(type);
        }
        Pair<VertexFormat.Mode, VertexFormat> pair = AsyncRenderer.getVertexFormatPair(k, this.f_107291_);
        if (pair != AsyncRenderer.EMPTY_FORMAT) {
            list.add(k);
        }
        for (ParticleRenderType type : f_107288_) {
            if (AsyncRenderer.getVertexFormatPair(type, this.f_107291_) != AsyncRenderer.EMPTY_FORMAT) continue;
            list.add(type);
        }
        if (pair == AsyncRenderer.EMPTY_FORMAT) {
            list.add(k);
        }
        f_107288_ = list;
    }

    @Overwrite
    private void m_107384_(Collection<Particle> collection) {
        if (collection.isEmpty()) {
            return;
        }
        for (Particle particle : collection) {
            LightCachedParticleAddon lightCachedParticle;
            if (AsyncTicker.isCancelled() && !SimplePropertiesConfig.forceDoneParticleTick()) {
                return;
            }
            if (!particle.m_107276_()) {
                Utils.DUMMY_ITERATOR.remove();
                continue;
            }
            if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                if (!(particle instanceof LightCachedParticleAddon)) continue;
                lightCachedParticle = (LightCachedParticleAddon)particle;
                if (!SimplePropertiesConfig.particleLightCache()) continue;
                lightCachedParticle.asyncparticles$refresh();
                continue;
            }
            if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync(particle);
                continue;
            }
            try {
                this.m_107393_(particle);
                if (particle instanceof LightCachedParticleAddon) {
                    lightCachedParticle = (LightCachedParticleAddon)particle;
                    if (SimplePropertiesConfig.particleLightCache()) {
                        lightCachedParticle.asyncparticles$refresh();
                    }
                }
                ((ParticleAddon)particle).asyncparticles$setTicked();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException(particle, t);
            }
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    public void add(Particle particle, CallbackInfo ci) {
        if (!AsyncTicker.shouldTickParticles && SimplePropertiesConfig.isTickAsync()) {
            particle.m_107274_();
        } else if (particle instanceof LightCachedParticleAddon) {
            LightCachedParticleAddon lightCachedParticle = (LightCachedParticleAddon)particle;
            if (SimplePropertiesConfig.particleLightCache()) {
                lightCachedParticle.asyncparticles$refresh();
            }
        }
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void redirectClearParticles(CallbackInfo ci) {
        this.f_107294_.forEach(AsyncTicker::onEvicted);
        this.f_107294_ = new BusyWaitEvictingQueue<Particle>(1024, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.f_107290_.forEach(AsyncTicker::onEvicted);
        this.f_107290_ = new BusyWaitEvictingQueue<TrackingEmitter>(256, SimplePropertiesConfig.getLimit(), AsyncTicker::onEvicted);
        this.f_107289_.values().forEach(queue -> queue.forEach(AsyncTicker::onEvicted));
        AsyncTicker.onParticleEngineClear();
    }
}

