/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.mixin.forge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.CustomTesselator;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FakeBufferBuilder;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FakeTesselator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine_Render {
    @Shadow
    @Final
    public Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    @Final
    public TextureManager f_107291_;

    @Overwrite(remap=false)
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, LightTexture lightTexture, Camera camera, float f, Frustum ignored) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("prepare");
        Frustum frustum = AsyncRenderer.frustum;
        lightTexture.m_109896_();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        PoseStack poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.m_85836_();
        poseStack2.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        profiler.m_7238_();
        for (ParticleRenderType particleRenderType : this.f_107289_.keySet()) {
            Tesselator tesselator;
            Collection<Object> syncParticles;
            boolean shouldSync;
            Queue<Particle> queue;
            if (particleRenderType == ParticleRenderType.f_107434_ || (queue = this.f_107289_.get(particleRenderType)) == null || queue.isEmpty()) continue;
            BufferBuilder bufferBuilder = AsyncRenderer.beginBufferBuilder(particleRenderType, this.f_107291_);
            profiler.m_6180_("render_sync");
            boolean bl = shouldSync = bufferBuilder == FakeBufferBuilder.INSTANCE;
            if (shouldSync) {
                syncParticles = AsyncRenderer.isMixedParticleRenderingSetting() ? Collections.emptyList() : queue;
                tesselator = Tesselator.m_85913_();
                bufferBuilder = tesselator.m_85915_();
            } else {
                syncParticles = AsyncRenderer.getSync(particleRenderType);
                tesselator = null;
            }
            RenderSystem.setShader(GameRenderer::m_172829_);
            particleRenderType.m_6505_((BufferBuilder)FakeBufferBuilder.INSTANCE, this.f_107291_);
            if (!syncParticles.isEmpty()) {
                float f2 = f + 1.0f;
                for (Particle particle : syncParticles) {
                    if (!particle.m_107276_() || shouldSync && particle.shouldCull() && !frustum.m_113029_(particle.m_107277_())) continue;
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.m_5744_((VertexConsumer)bufferBuilder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            profiler.m_7238_();
            if (!bufferBuilder.m_85732_()) {
                particleRenderType.m_6294_((Tesselator)FakeTesselator.INSTANCE);
                continue;
            }
            profiler.m_6180_("upload_particles");
            particleRenderType.m_6294_((Tesselator)(tesselator != null ? tesselator : CustomTesselator.of(bufferBuilder, b -> BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)b.m_231175_()))));
            if (bufferBuilder.m_85732_()) {
                bufferBuilder.m_231175_().m_231200_();
            }
            profiler.m_7238_();
        }
        profiler.m_6180_("cleanup");
        poseStack2.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        lightTexture.m_109891_();
        profiler.m_7238_();
    }
}

