/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3;

import dev.architectury.injectables.annotations.ExpectPlatform;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.ParticleRainAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.fabric.ParticleRainCompatImpl;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public abstract class ParticleRainCompat {
    public static final ParticleRainCompat INSTANCE;
    public final AtomicInteger particleCount = new AtomicInteger(0);
    public final AtomicInteger fogCount = new AtomicInteger(0);

    public static void init() {
        if (!ModListHelper.IS_LEGACY_PARTICLERAIN) {
            throw new IllegalStateException("Mod ParticleRain is not legacy.");
        }
    }

    private static void init0() {
        ParticleRainAddon.CollisionFunction function;
        if (ModListHelper.VS_LOADED) {
            ParticleRainAddon.Type.RAIN.register((level, location, originalMovement, aabb) -> {
                class_243 shipMovement = VSClientUtils.entityMovColShipOnly(originalMovement, aabb, level);
                if (shipMovement == null) {
                    return originalMovement;
                }
                INSTANCE.onShipCollision(level, location, shipMovement, aabb);
                return shipMovement;
            });
            function = (level, location, v, aabb) -> {
                class_243 shipMovement = VSClientUtils.entityMovColShipOnly(v, aabb, level);
                return shipMovement == null ? v : shipMovement;
            };
            ParticleRainAddon.Type.SNOW.register(function);
            ParticleRainAddon.Type.OTHER.register(function);
        }
        if (ModListHelper.CREATE_LOADED) {
            ParticleRainAddon.Type.RAIN.register((level, position, motion, aabb) -> {
                class_243 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                if (collide == null) {
                    return motion;
                }
                INSTANCE.onCreateCollision(level, motion, collide, aabb);
                return collide;
            });
            function = (level, position, motion, aabb) -> {
                class_243 collide = CreateUtil.collideMotionWithContraptions(level, motion, aabb);
                return collide == null ? motion : collide;
            };
            ParticleRainAddon.Type.SNOW.register(function);
            ParticleRainAddon.Type.OTHER.register(function);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static ParticleRainCompat newInstance() {
        return ParticleRainCompatImpl.newInstance();
    }

    public void clearCounters() {
        this.particleCount.set(0);
        this.fogCount.set(0);
    }

    public abstract void onShipCollision(class_638 var1, class_243 var2, class_243 var3, class_238 var4);

    public abstract void onCreateCollision(@NotNull class_638 var1, class_243 var2, @NotNull class_243 var3, @NotNull class_238 var4);

    static {
        ParticleRainCompat.init0();
        INSTANCE = ParticleRainCompat.newInstance();
    }
}

