/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionHandlerClient;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.collision.Matrix3d;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CollisionType;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.ContraptionAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.ContraptionEntityAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.ContraptionHitResult;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.Create5Util;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.Create6Util;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class CreateUtil {
    public static Collection<WeakReference<AbstractContraptionEntity>> contraptions(LevelAccessor level) {
        return CreateUtil.loadedContraptions(level).values();
    }

    @Nullable
    public static Vec3 collideMotionWithContraptions(ClientLevel level, Vec3 motion, AABB bounds) {
        Vector3d result = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        AABB finalBounds = bounds.m_82400_(0.1);
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((LevelAccessor)level);
        while (it.hasNext()) {
            Vec3 vec3;
            AbstractContraptionEntity entity = it.next();
            if (!((ContraptionEntityAddon)entity).asyncparticles$doParticleCollision() || (vec3 = CreateUtil.collideMotionWithContraption(motion, finalBounds, entity, false)) == null) continue;
            result.set(Math.abs(result.x) < Math.abs(vec3.f_82479_) ? result.x : vec3.f_82479_, Math.abs(result.y) < Math.abs(vec3.f_82480_) ? result.y : vec3.f_82480_, Math.abs(result.z) < Math.abs(vec3.f_82481_) ? result.z : vec3.f_82481_);
        }
        if (result.x == Double.MAX_VALUE || motion.f_82479_ == result.x && motion.f_82480_ == result.y && motion.f_82481_ == result.z) {
            return null;
        }
        return new Vec3(result.x, result.y, result.z);
    }

    public static Iterator<AbstractContraptionEntity> forEachContraption(LevelAccessor level) {
        final Iterator<WeakReference<AbstractContraptionEntity>> iterator = CreateUtil.contraptions(level).iterator();
        return new Iterator<AbstractContraptionEntity>(){
            private AbstractContraptionEntity next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    try {
                        this.next = (AbstractContraptionEntity)((WeakReference)iterator.next()).get();
                        if (this.next == null) {
                            continue;
                        }
                    }
                    catch (ConcurrentModificationException ignored) {
                        this.next = null;
                        return false;
                    }
                    if (!this.next.isAliveOrStale()) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public AbstractContraptionEntity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AbstractContraptionEntity result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super AbstractContraptionEntity> action) {
                while (this.hasNext()) {
                    action.accept((AbstractContraptionEntity)this.next);
                    this.next = null;
                }
            }
        };
    }

    public static Vec3 getWorldToLocalTranslation(Vec3 entityCenter, Vec3 anchorVec, Matrix3d rotationMatrix, float yawOffset) {
        Vec3 position = ContraptionCollider.worldToLocalPos((Vec3)entityCenter, (Vec3)anchorVec, (Matrix3d)rotationMatrix, (float)yawOffset);
        return position.m_82546_(entityCenter);
    }

    public static CollisionType isCollideWithContraption(Vec3 originalMotion, AABB entityBounds, AbstractContraptionEntity contraptionEntity, boolean estimate) {
        List<AABB> collidableBBs;
        AABB entityBoundingBox;
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            AABB bb0 = contraptionEntity.m_20191_();
            v0 = bb0.m_82377_(0.0, Math.max(Math.max(bb0.m_82362_(), bb0.m_82385_()) - bb0.m_82376_() * 0.3, 0.0), 0.0);
        } else {
            v0 = entityBoundingBox = contraptionEntity.m_20191_();
        }
        if (!entityBounds.m_82369_(originalMotion).m_82381_(entityBoundingBox)) {
            return CollisionType.NONE;
        }
        AbstractContraptionEntity.ContraptionRotationState rotation = contraptionEntity.getRotationState();
        Matrix3d rotationMatrix = rotation.asMatrix();
        Vec3 center = entityBounds.m_82399_();
        float yawOffset = rotation.getYawOffset();
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        Vec3 toLocalTranslation = CreateUtil.getWorldToLocalTranslation(center, anchorVec, rotationMatrix, yawOffset);
        Vec3 contactPointMotion = contraptionEntity.getContactPointMotion(center);
        Vec3 localMotion = rotationMatrix.transform(originalMotion.m_82546_(contactPointMotion));
        AABB localBB = entityBounds.m_82383_(toLocalTranslation).m_82400_(1.0E-7);
        Contraption contraption = contraptionEntity.getContraption();
        Optional collisionShapes = contraption.getSimplifiedEntityColliders();
        if (collisionShapes.isPresent()) {
            collidableBBs = (List<AABB>)collisionShapes.get();
        } else {
            if (estimate) {
                return Math.abs(contactPointMotion.f_82479_) + Math.abs(contactPointMotion.f_82480_) + Math.abs(contactPointMotion.f_82481_) > 0.005 ? CollisionType.MOVING : CollisionType.STATIONARY;
            }
            collidableBBs = ((ContraptionAddon)contraption).asyncparticles$getAabbs();
        }
        AABB localExpanded = localBB.m_82369_(localMotion);
        for (AABB bb : collidableBBs) {
            if (!localExpanded.m_82381_(bb)) continue;
            return Math.abs(contactPointMotion.f_82479_) + Math.abs(contactPointMotion.f_82480_) + Math.abs(contactPointMotion.f_82481_) > 0.005 ? CollisionType.MOVING : CollisionType.STATIONARY;
        }
        return CollisionType.NONE;
    }

    @Nullable
    public static Vec3 collideMotionWithContraption(Vec3 originalMotion, AABB entityBounds, AbstractContraptionEntity contraptionEntity, boolean estimate) {
        Vec3 clippedLocal;
        List<AABB> collidableBBs;
        AABB entityBoundingBox;
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            AABB bb0 = contraptionEntity.m_20191_();
            v0 = bb0.m_82377_(0.0, Math.max(Math.max(bb0.m_82362_(), bb0.m_82385_()) - bb0.m_82376_() * 0.3, 0.0), 0.0);
        } else {
            v0 = entityBoundingBox = contraptionEntity.m_20191_();
        }
        if (!entityBounds.m_82369_(originalMotion).m_82381_(entityBoundingBox)) {
            return null;
        }
        AbstractContraptionEntity.ContraptionRotationState rotation = contraptionEntity.getRotationState();
        Matrix3d rotationMatrix = rotation.asMatrix();
        Vec3 center = entityBounds.m_82399_();
        float yawOffset = rotation.getYawOffset();
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        Vec3 toLocalTranslation = CreateUtil.getWorldToLocalTranslation(center, anchorVec, rotationMatrix, yawOffset);
        Vec3 contactPointMotion = contraptionEntity.getContactPointMotion(center);
        Vec3 localMotion = rotationMatrix.transform(originalMotion.m_82546_(contactPointMotion));
        AABB localBB = entityBounds.m_82383_(toLocalTranslation).m_82400_(1.0E-7);
        Contraption contraption = contraptionEntity.getContraption();
        Optional collisionShapes = contraption.getSimplifiedEntityColliders();
        if (collisionShapes.isPresent()) {
            collidableBBs = (List<AABB>)collisionShapes.get();
        } else {
            if (estimate) {
                return Vec3.f_82478_;
            }
            collidableBBs = ((ContraptionAddon)contraption).asyncparticles$getAabbs();
        }
        Vec3 localCenter = localBB.m_82399_();
        double cx = localMotion.f_82479_;
        double cy = localMotion.f_82480_;
        double cz = localMotion.f_82481_;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        boolean squeezed = false;
        double localXsize = localBB.m_82362_();
        double localYsize = localBB.m_82376_();
        double localZsize = localBB.m_82385_();
        AABB localExpanded = localBB.m_82369_(localMotion);
        for (AABB bb : collidableBBs) {
            Vec3 bbCenter;
            if (!localExpanded.m_82381_(bb)) continue;
            if (localBB.m_82381_(bb)) {
                bbCenter = bb.m_82399_();
                squeezed = true;
                AABB intersect = localBB.m_82323_(bb);
                double intersectXsize = intersect.m_82362_();
                double intersectYsize = intersect.m_82376_();
                double intersectZsize = intersect.m_82385_();
                Direction.Axis squeezedAxis = CreateUtil.getSqueezedAxis(intersectXsize, intersectYsize, intersectZsize);
                switch (squeezedAxis) {
                    case X: {
                        sx = CreateUtil.getSqueezed(localCenter.f_82479_, bbCenter.f_82479_, intersectXsize, sx);
                        break;
                    }
                    case Y: {
                        sy = CreateUtil.getSqueezed(localCenter.f_82480_, bbCenter.f_82480_, intersectYsize, cy > 0.0 ? cy : sy);
                        break;
                    }
                    case Z: {
                        sz = CreateUtil.getSqueezed(localCenter.f_82481_, bbCenter.f_82481_, intersectZsize, sz);
                    }
                }
                continue;
            }
            if (squeezed) continue;
            bbCenter = bb.m_82399_();
            Vec3 relative = bbCenter.m_82546_(localCenter);
            double halfXsum = (bb.m_82362_() + localXsize) * 0.5;
            double halfYsum = (bb.m_82376_() + localYsize) * 0.5;
            double halfZsum = (bb.m_82385_() + localZsize) * 0.5;
            Direction.Axis collidedAxis = CreateUtil.getCollideAxis(halfXsum, halfYsum, halfZsum, relative);
            switch (collidedAxis) {
                case X: {
                    cx = CreateUtil.getCollided(relative.f_82479_, halfXsum, cx);
                    break;
                }
                case Y: {
                    cy = CreateUtil.getCollided(relative.f_82480_, halfYsum, cy);
                    break;
                }
                case Z: {
                    cz = CreateUtil.getCollided(relative.f_82481_, halfZsum, cz);
                }
            }
        }
        if (squeezed) {
            clippedLocal = new Vec3(sx, sy, sz);
        } else {
            clippedLocal = new Vec3(cx, cy, cz);
            if (localMotion.equals((Object)clippedLocal)) {
                return null;
            }
        }
        Vec3 clipped = rotationMatrix.transpose().transform(clippedLocal);
        double x = Math.signum(contactPointMotion.f_82479_) != Math.signum(originalMotion.f_82479_) || Math.abs(clipped.f_82479_) < Math.abs(contactPointMotion.f_82479_) ? contactPointMotion.f_82479_ * 3.0 : contactPointMotion.f_82479_;
        double y = Math.signum(contactPointMotion.f_82480_) != Math.signum(originalMotion.f_82480_) || Math.abs(clipped.f_82480_) < Math.abs(contactPointMotion.f_82480_) ? contactPointMotion.f_82480_ * 3.0 : contactPointMotion.f_82480_;
        double z = Math.signum(contactPointMotion.f_82481_) != Math.signum(originalMotion.f_82481_) || Math.abs(clipped.f_82481_) < Math.abs(contactPointMotion.f_82481_) ? contactPointMotion.f_82481_ * 3.0 : contactPointMotion.f_82481_;
        return clipped.m_82520_(x, y, z);
    }

    private static double getCollided(double relative, double halfXsum, double mx) {
        double dx;
        double d = dx = relative > 0.0 ? relative - halfXsum : relative + halfXsum;
        if (Math.abs(mx) > Math.abs(dx)) {
            mx = dx;
        }
        return mx;
    }

    private static double getSqueezed(double localCenter, double bbCenter, double intersectSize, double currentSqueezed) {
        double diff = localCenter - bbCenter;
        double halfIntersectSize = intersectSize * 0.5;
        if (diff < -halfIntersectSize) {
            return Math.min(currentSqueezed, -halfIntersectSize - diff);
        }
        if (diff > halfIntersectSize) {
            return Math.max(currentSqueezed, halfIntersectSize - diff);
        }
        return currentSqueezed;
    }

    private static Direction.Axis getSqueezedAxis(double xsize, double ysize, double zsize) {
        if (xsize < ysize) {
            if (xsize < zsize) {
                return Direction.Axis.X;
            }
            return Direction.Axis.Z;
        }
        if (ysize < zsize) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.Z;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Direction.Axis getCollideAxis(double halfXsum, double halfYsum, double halfZsum, Vec3 relative) {
        double sx = halfXsum - Math.abs(relative.f_82479_);
        double sy = halfYsum - Math.abs(relative.f_82480_);
        double sz = halfZsum - Math.abs(relative.f_82481_);
        if (sx < sy) {
            if (sx < sz) {
                return Direction.Axis.X;
            }
            return Direction.Axis.Z;
        }
        if (sy < sz) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.Z;
    }

    public static Map<Integer, WeakReference<AbstractContraptionEntity>> loadedContraptions(LevelAccessor level) {
        return ModListHelper.IS_LEGACY_CREATE ? Create5Util.loadedContraptions(level) : Create6Util.loadedContraptions(level);
    }

    public static boolean isUnderContraption(ClientLevel level, double x, double y, double z, double size) {
        AABB bounds = new AABB(x - size, y - size, z - size, x + size, y + size, z + size);
        return CollisionType.NONE != CreateUtil.isCollideWithContraption(level, new Vec3(0.0, Math.max(16.0, (double)level.m_151558_() - y), 0.0), bounds);
    }

    public static boolean isUnderContraption(ClientLevel level, Vec3 pos, double size) {
        AABB bounds = new AABB(pos.f_82479_ - size, pos.f_82480_ - size, pos.f_82481_ - size, pos.f_82479_ + size, pos.f_82480_ + size, pos.f_82481_ + size);
        return CollisionType.NONE != CreateUtil.isCollideWithContraption(level, new Vec3(0.0, Math.max(16.0, (double)level.m_151558_() - pos.f_82480_), 0.0), bounds);
    }

    public static CollisionType isCollideWithContraption(ClientLevel level, Vec3 motion, AABB bb) {
        return CreateUtil.isCollideWithContraption(level, motion, bb, true);
    }

    public static CollisionType isCollideWithContraption(ClientLevel level, Vec3 motion, AABB bb, boolean estimate) {
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((LevelAccessor)level);
        while (it.hasNext()) {
            AbstractContraptionEntity contraptionEntity = it.next();
            CollisionType collisionType = CreateUtil.isCollideWithContraption(motion, bb, contraptionEntity, estimate);
            if (collisionType == CollisionType.NONE) continue;
            return collisionType;
        }
        return CollisionType.NONE;
    }

    @Nullable
    public static Vec3 getContraptionDeltaMovement(Entity entity) {
        Entity rootEntity = entity.m_20201_();
        if (rootEntity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity ace = (AbstractContraptionEntity)rootEntity;
            return ace.getContactPointMotion(entity.m_20182_());
        }
        Iterator<AbstractContraptionEntity> iterator = CreateUtil.forEachContraption((LevelAccessor)rootEntity.m_9236_());
        while (iterator.hasNext()) {
            AbstractContraptionEntity contraptionEntity = iterator.next();
            if (!contraptionEntity.collidingEntities.containsKey(rootEntity)) continue;
            return contraptionEntity.getContactPointMotion(entity.m_20182_());
        }
        return null;
    }

    public static BlockHitResult clip(ClientLevel level, Vec3 start, Vec3 end) {
        double shortestDistance = Double.MAX_VALUE;
        BlockHitResult hitResult = null;
        Vec3 hit = null;
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((LevelAccessor)level);
        while (it.hasNext()) {
            AbstractContraptionEntity entity = it.next();
            BlockHitResult hitResult1 = ContraptionHandlerClient.rayTraceContraption((Vec3)start, (Vec3)end, (AbstractContraptionEntity)entity);
            if (hitResult1 == null || hitResult1.m_6662_() == HitResult.Type.MISS) continue;
            Vec3 hit1 = entity.toGlobalVector(hitResult1.m_82450_(), 1.0f);
            double hitDiff = start.f_82480_ - hit1.f_82480_;
            if (!(shortestDistance > hitDiff)) continue;
            hitResult = hitResult1;
            hit = hit1;
        }
        if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return new BlockHitResult(hit, hitResult.m_82434_(), BlockPos.m_274446_(hit), hitResult.m_82436_());
    }

    @Nullable
    public static ContraptionHitResult clipWithContactPointMotion(ClientLevel level, Vec3 start, Vec3 end) {
        double shortestDistance = Double.MAX_VALUE;
        BlockHitResult hitResult = null;
        Vec3 hit = null;
        AbstractContraptionEntity entity = null;
        Iterator<AbstractContraptionEntity> it = CreateUtil.forEachContraption((LevelAccessor)level);
        while (it.hasNext()) {
            BlockHitResult hitResult1;
            AABB entity1Bb;
            AABB aABB;
            AbstractContraptionEntity entity1 = it.next();
            if (entity1 instanceof CarriageContraptionEntity) {
                AABB bb0 = entity1.m_20191_();
                aABB = bb0.m_82377_(0.0, Math.max(Math.max(bb0.m_82362_(), bb0.m_82385_()) - bb0.m_82376_() * 0.3, 0.0), 0.0);
            } else {
                aABB = entity1.m_20191_();
            }
            if (!(entity1Bb = aABB).m_82335_(start, end) || (hitResult1 = ContraptionHandlerClient.rayTraceContraption((Vec3)start, (Vec3)end, (AbstractContraptionEntity)entity1)) == null) continue;
            Vec3 hit1 = entity1.toGlobalVector(hitResult1.m_82450_(), 1.0f);
            double hitDiff = start.f_82480_ - hit1.f_82480_;
            if (!(shortestDistance > hitDiff)) continue;
            hitResult = hitResult1;
            hit = hit1;
            entity = entity1;
        }
        if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
            return null;
        }
        return new ContraptionHitResult(entity.getContactPointMotion(hit), hit, hitResult.m_82434_(), BlockPos.m_274446_(hit), hitResult.m_82436_());
    }
}

