/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.physicsmod;

import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CollisionType;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.ShipHitResult;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.RainEffect;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.GameUtil;
import net.diebuddies.physics.snow.math.AABB3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class PhysicsModCompat {
    public static boolean isCollideWithShip(ClientLevel level, Vec3 movement, AABB3D aabb) {
        Vector3d min = aabb.getMin();
        Vector3d max = aabb.getMax();
        return VSClientUtils.isEntityMovColShipOnly(movement, new AABB(min.x, min.y, min.z, max.x, max.y, max.z), level);
    }

    public static void onShipCollide(ClientLevel level, Vec3 location, Vec3 movement) {
        RainEffect vsRainEffect = ConfigHelper.getVSRainEffect();
        if (vsRainEffect == RainEffect.NONE || (double)level.f_46441_.m_188501_() > 0.1) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ShipHitResult hit = VSClientUtils.clipShip(level, new ClipContext(location, location.m_82549_(movement.m_82490_(2.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)mc.f_91074_), true);
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK || hit.m_82436_()) {
            return;
        }
        Vec3 shipMotion = hit.shipMotion;
        if (vsRainEffect == RainEffect.STATIONARY && GameUtil.manhattanLength(shipMotion) > 0.05) {
            return;
        }
        Vec3 spawnPos = hit.m_82450_().m_82549_(shipMotion);
        FluidState fluidState = level.m_6425_(hit.m_82425_());
        if (fluidState.m_76178_()) {
            mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static CollisionType isCollideWithContraption(ClientLevel level, Vec3 movement, AABB aabb) {
        return CreateUtil.isCollideWithContraption(level, movement, aabb, true);
    }

    public static void onContraptionCollide(ClientLevel level, Vec3 location, Vec3 movement, CollisionType collisionType) {
        RainEffect createRainEffect = ConfigHelper.getCreateRainEffect();
        if (createRainEffect == RainEffect.NONE || (double)level.f_46441_.m_188501_() > 0.1) {
            return;
        }
        BlockHitResult hit = CreateUtil.clip(level, location, location.m_82549_(movement.m_82490_(2.0)));
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK || hit.m_82436_() || !collisionType.canSpawnRainEffect(createRainEffect)) {
            return;
        }
        Vec3 spawnPos = hit.f_82445_;
        Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
    }
}

