/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncParticlesClient;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.AsyncParticlesConfig;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;

@Mod(value="asyncparticles")
public final class AsyncParticlesClientForge {
    public AsyncParticlesClientForge() {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        AsyncParticlesClient.init();
        MinecraftForge.EVENT_BUS.addListener(this::registerClientCommands);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> AsyncParticlesConfig.newConfigScreen(parent))));
    }

    private static CompletableFuture<Suggestions> suggestModId(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(FMLLoader.getLoadingModList().getMods().stream().map(ModInfo::getModId), (SuggestionsBuilder)builder);
    }

    private void registerClientCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"asyncparticles").then(Commands.m_82127_((String)"isfabricmod").then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncParticlesClientForge::suggestModId).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(modId + " is " + (ModListHelper.isFabricModLoaded(modId) ? "fabric mod" : (ModListHelper.isModLoaded(modId) ? "not fabric mod" : "not loaded")))));
            return 1;
        })))).then(Commands.m_82127_((String)"isforgemod").then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncParticlesClientForge::suggestModId).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(modId + " is " + (ModListHelper.isForgeModLoaded(modId) ? "forge mod" : (ModListHelper.isModLoaded(modId) ? "not forge mod" : "not loaded")))));
            return 1;
        })))).then(Commands.m_82127_((String)"debug").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            AsyncTicker.debugLater(s -> source.m_243053_((Component)Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Copy to clipboard"))))));
            AsyncRenderer.debugLater(s -> source.m_243053_((Component)Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Copy to clipboard"))))));
            return 1;
        }))).then(Commands.m_82127_((String)"dump").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            AsyncTicker.dumpParticles();
            source.m_243053_((Component)Component.m_237113_((String)"Particles have been dumped to log."));
            return 1;
        }))).then(Commands.m_82127_((String)"class_exists").then(Commands.m_82129_((String)"className", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String className = StringArgumentType.getString((CommandContext)context, (String)"className");
            if (ModListHelper.classExists(className)) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Class " + className + " exists!")));
            } else {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Class " + className + " not exists.")));
            }
            return 1;
        })))).then(Commands.m_82127_((String)"load_class").then(Commands.m_82129_((String)"className", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String className = StringArgumentType.getString((CommandContext)context, (String)"className");
            if (ModListHelper.loadClass(className)) {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Class " + className + " exists!")));
            } else {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)("Class " + className + " not exists.")));
            }
            return 1;
        })))).then(Commands.m_82127_((String)"version_check").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncParticlesClientForge::suggestModId).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            if (ModListHelper.isModLoaded(modId)) {
                String version = ModListHelper.versionToString(modId);
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(modId + " version " + version)));
            } else {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(modId + " is not loaded")));
            }
            return 1;
        })).then(Commands.m_82129_((String)"min_inclusive", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"max_exclusive", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
            String minInclusive = StringArgumentType.getString((CommandContext)context, (String)"min_inclusive");
            String maxExclusive = StringArgumentType.getString((CommandContext)context, (String)"max_exclusive");
            if (ModListHelper.isModLoaded(modId)) {
                boolean b = ModListHelper.versionCheck(modId, minInclusive, maxExclusive);
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(modId + " version " + (b ? "is within" : "is not within") + " [" + minInclusive + ", " + maxExclusive + ")")));
            } else {
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)(modId + " is not loaded")));
            }
            return 1;
        })))))).then(Commands.m_82127_((String)"config").executes(context -> {
            Minecraft mc = Minecraft.m_91087_();
            ThreadUtil.enqueueClientTask(() -> mc.m_91152_(AsyncParticlesConfig.newConfigScreen(null)));
            return 1;
        }))).then(Commands.m_82127_((String)"reload").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            try {
                ConfigHelper.load();
            }
            catch (Exception e) {
                source.m_243053_((Component)Component.m_237113_((String)"Failed to reload config").m_130946_(e.getMessage()));
                return 1;
            }
            AsyncTicker.reloadLater();
            source.m_243053_((Component)Component.m_237113_((String)"AsyncParticles config reloaded"));
            return 1;
        })));
    }
}

