/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.mixin.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleEngineAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.CustomTesselator;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FakeBufferBuilder;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public class MixinParticleEngine_Render
implements ParticleEngineAddon {
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    @Final
    public TextureManager f_107291_;
    @Shadow
    @Mutable
    public static List<ParticleRenderType> f_107288_;

    @Override
    public void asyncparticle$addRenderType(ParticleRenderType particleRenderType) {
        if (!f_107288_.contains(particleRenderType)) {
            if (!(f_107288_ instanceof ArrayList)) {
                f_107288_ = new ArrayList<ParticleRenderType>(f_107288_);
            }
            f_107288_.add(particleRenderType);
            this.asyncparticle$sortRenderOrder();
        }
    }

    @Override
    public void asyncparticle$sortRenderOrder() {
        LinkedHashSet<ParticleRenderType> renderTypes = new LinkedHashSet<ParticleRenderType>((int)((double)f_107288_.size() * 1.34) + 1);
        for (ParticleRenderType type : f_107288_) {
            if (AsyncRenderer.getVertexFormatPair(type, this.f_107291_) == AsyncRenderer.EMPTY_FORMAT) continue;
            renderTypes.add(type);
        }
        for (ParticleRenderType type : f_107288_) {
            if (AsyncRenderer.getVertexFormatPair(type, this.f_107291_) != AsyncRenderer.EMPTY_FORMAT) continue;
            renderTypes.add(type);
        }
        f_107288_ = new ArrayList<ParticleRenderType>(renderTypes);
    }

    @Overwrite
    public void m_107336_(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, LightTexture lightTexture, Camera camera, float f) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        boolean renderAsync = AsyncRenderer.isRenderAsync();
        if (renderAsync) {
            profiler.m_6180_("wait_for_async_tasks");
            AsyncRenderer.tryWaitingForAsyncTasks();
            profiler.m_7238_();
        }
        profiler.m_6180_("prepare");
        lightTexture.m_109896_();
        RenderSystem.enableDepthTest();
        PoseStack poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.m_85836_();
        poseStack2.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        profiler.m_7238_();
        Frustum frustum = AsyncRenderer.frustum;
        boolean irisEarlyOpaquePhase = AsyncRenderer.isIrisEarlyOpaquePhase();
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        for (ParticleRenderType particleRenderType : f_107288_) {
            BufferBuilder toBegin;
            Tesselator tesselator;
            Collection<Object> syncParticles;
            ParticleCullingMode realCullMode;
            Queue<Particle> queue = this.f_107289_.get(particleRenderType);
            if (queue == null || queue.isEmpty()) continue;
            profiler.m_6180_("render_sync");
            BufferBuilder bufferBuilder = AsyncRenderer.beginBufferBuilder(particleRenderType, this.f_107291_);
            if (bufferBuilder == FakeBufferBuilder.INSTANCE) {
                realCullMode = particleCullingMode;
                syncParticles = irisEarlyOpaquePhase ? Collections.emptyList() : queue;
                tesselator = Tesselator.m_85913_();
                toBegin = bufferBuilder = tesselator.m_85915_();
            } else if (!renderAsync) {
                realCullMode = particleCullingMode;
                syncParticles = queue;
                tesselator = Tesselator.m_85913_();
                toBegin = bufferBuilder = tesselator.m_85915_();
            } else {
                realCullMode = ParticleCullingMode.DISABLED;
                syncParticles = AsyncRenderer.getSync(particleRenderType);
                tesselator = CustomTesselator.of(bufferBuilder, b -> BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)b.m_231175_()));
                toBegin = FakeBufferBuilder.INSTANCE;
            }
            RenderSystem.setShader(GameRenderer::m_172829_);
            particleRenderType.m_6505_(toBegin, this.f_107291_);
            if (!syncParticles.isEmpty()) {
                float f2 = f + 1.0f;
                block8: for (Particle particle : syncParticles) {
                    if (!particle.m_107276_()) continue;
                    ParticleAddon particleAddon = (ParticleAddon)particle;
                    switch (realCullMode) {
                        case AABB: {
                            if (!particleAddon.shouldCull() || FrustumUtil.isVisible(frustum, particle.m_107277_())) break;
                            continue block8;
                        }
                        case SPHERE: {
                            if (!particleAddon.shouldCull() || FrustumUtil.isVisible(frustum, particle)) break;
                            continue block8;
                        }
                        case ASYNC_AABB: 
                        case ASYNC_SPHERE: {
                            if (!particleAddon.shouldCull() || particleAddon.asyncparticles$isVisibleOnScreen()) break;
                            continue block8;
                        }
                    }
                    float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    try {
                        particle.m_5744_((VertexConsumer)bufferBuilder, camera, f3);
                    }
                    catch (Throwable t) {
                        throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                    }
                }
            }
            profiler.m_6182_("upload_particles");
            particleRenderType.m_6294_(tesselator);
            if (bufferBuilder.m_85732_()) {
                bufferBuilder.m_231175_().m_231200_();
            }
            profiler.m_7238_();
        }
        profiler.m_6180_("cleanup");
        poseStack2.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        lightTexture.m_109891_();
        profiler.m_7238_();
    }
}

