/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.mixin.tick;

import com.llamalad7.mixinextras.sugar.Local;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.GameUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class}, priority=500)
public abstract class MixinParticleEngine {
    @Shadow
    public Queue<Particle> f_107294_;
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> f_107289_;
    @Shadow
    protected ClientLevel f_107287_;
    @Mutable
    @Shadow
    public Queue<TrackingEmitter> f_107290_;

    @Shadow
    public abstract void m_107393_(Particle var1);

    @Shadow
    public abstract void m_172281_(ParticleGroup var1, int var2);

    @Inject(method={"tickParticle"}, at={@At(value="INVOKE", target="Lnet/minecraft/CrashReport;forThrowable(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/CrashReport;")})
    public void onTickParticle(Particle particle, CallbackInfo ci, @Local Throwable t) {
        if (ConfigHelper.isTickAsync()) {
            throw ExceptionUtil.toThrowDirectly(t);
        }
    }

    @Overwrite
    public void m_107388_() {
        this.f_107289_.forEach((particleRenderType, queue) -> {
            ProfilerFiller profiler = this.f_107287_.m_46473_();
            profiler.m_6180_(particleRenderType.toString());
            AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.m_107384_((Collection<Particle>)queue));
            profiler.m_7238_();
        });
        AsyncTicker.PARTICLE_OPERATIONS.add(this::asyncparticles$tickEmitters);
        boolean tickAsync = ConfigHelper.isTickAsync();
        if (tickAsync) {
            AsyncTicker.waitForCleanUp();
        } else {
            AsyncTicker.PARTICLE_OPERATIONS.forEach(Runnable::run);
            AsyncTicker.PARTICLE_OPERATIONS.clear();
            AsyncTicker.tickSyncParticles();
            this.f_107289_.values().forEach(q -> q.removeIf(p -> {
                if (p.m_107276_()) {
                    return false;
                }
                p.m_142654_().ifPresent(group -> this.m_172281_((ParticleGroup)group, -1));
                return true;
            }));
        }
        if (!this.f_107294_.isEmpty()) {
            for (Particle particle : this.f_107294_) {
                if (tickAsync && ((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                }
                Queue queue2 = this.f_107289_.computeIfAbsent(particle.m_7556_(), k -> {
                    Queue<Particle> queue1 = GameUtil.newParticleQueue();
                    if (tickAsync) {
                        AsyncTicker.PARTICLE_OPERATIONS.add(() -> this.m_107384_(queue1));
                    }
                    return queue1;
                });
                queue2.add(particle);
            }
            this.f_107294_.clear();
        }
    }

    @Unique
    private void asyncparticles$tickEmitters() {
        boolean forceDone = ConfigHelper.forceDoneParticleTick();
        for (TrackingEmitter emitter : this.f_107290_) {
            if (AsyncTicker.isCancelled() && !forceDone) {
                return;
            }
            if (!emitter.m_107276_()) continue;
            if (!ThreadUtil.isOnMainThread() && ((ParticleAddon)emitter).asyncparticles$isTickSync()) {
                AsyncTicker.recordSync((Particle)emitter);
                continue;
            }
            try {
                emitter.m_5989_();
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException((Particle)emitter, t);
            }
        }
    }

    @Overwrite
    private void m_107384_(Collection<Particle> collection) {
        if (collection.isEmpty()) {
            return;
        }
        boolean enableLightCache = ConfigHelper.particleLightCache();
        boolean isNotOnMainThread = !ThreadUtil.isOnMainThread();
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        boolean forceDone = ConfigHelper.forceDoneParticleTick();
        for (Particle particle : collection) {
            if (AsyncTicker.isCancelled() && !forceDone) {
                return;
            }
            if (!particle.m_107276_()) {
                Utils.DUMMY_ITERATOR.remove();
                continue;
            }
            if (isNotOnMainThread) {
                if (((ParticleAddon)particle).asyncparticles$isTicked()) {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    }
                    switch (particleCullingMode) {
                        case ASYNC_AABB: {
                            ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                            break;
                        }
                        case ASYNC_SPHERE: {
                            ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                        }
                    }
                    continue;
                }
                if (((ParticleAddon)particle).asyncparticles$isTickSync()) {
                    AsyncTicker.recordSync(particle);
                    continue;
                }
            }
            try {
                this.m_107393_(particle);
            }
            catch (Throwable t) {
                AsyncTicker.onTickingParticleException(particle, t);
            }
            ((ParticleAddon)particle).asyncparticles$setTicked();
            if (enableLightCache) {
                ((LightCachedParticleAddon)particle).asyncparticles$refresh();
            }
            switch (particleCullingMode) {
                case ASYNC_AABB: {
                    ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                    break;
                }
                case ASYNC_SPHERE: {
                    ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                }
            }
        }
    }

    @Inject(method={"add"}, at={@At(value="HEAD")})
    public void add(Particle particle, CallbackInfo ci) {
        if (!AsyncTicker.shouldTickParticles && ConfigHelper.isTickAsync()) {
            particle.m_107274_();
        } else {
            if (ConfigHelper.particleLightCache()) {
                ((LightCachedParticleAddon)particle).asyncparticles$enableLightCache();
                ((LightCachedParticleAddon)particle).asyncparticles$refresh();
            }
            switch (ConfigHelper.getParticleCullingMode()) {
                case ASYNC_AABB: {
                    ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                    break;
                }
                case ASYNC_SPHERE: {
                    ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                }
            }
        }
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void onClearParticles(CallbackInfo ci) {
        this.f_107294_.forEach(AsyncTicker::onEvicted);
        this.f_107294_ = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.f_107290_.forEach(AsyncTicker::onEvicted);
        this.f_107290_ = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
        this.f_107289_.values().forEach(queue -> queue.forEach(AsyncTicker::onEvicted));
        AsyncTicker.onParticleEngineClear();
    }
}

