/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import net.minecraft.client.Minecraft;

public class ThreadUtil {
    public static void assertNotParticleThread() {
        if (ThreadUtil.isOnParticleThread()) {
            throw new IllegalStateException("Cannot call this method from particle thread");
        }
    }

    public static void assertNotParticleRendererThread() {
        if (ThreadUtil.isOnParticleRendererThread()) {
            throw new IllegalStateException("Cannot call this method from particle renderer thread");
        }
    }

    public static void assertParticleRendererThread() {
        if (!ThreadUtil.isOnParticleRendererThread()) {
            throw new IllegalStateException("Cannot call this method from NON particle renderer thread");
        }
    }

    public static void assertNotParticleTickerThread() {
        if (ThreadUtil.isOnParticleTickerThread()) {
            throw new IllegalStateException("Cannot call this method from particle ticker thread");
        }
    }

    public static void assertParticleTickerThread() {
        if (!ThreadUtil.isOnParticleTickerThread()) {
            throw new IllegalStateException("Cannot call this method from NON particle ticker thread");
        }
    }

    public static boolean isOnParticleThread() {
        Class<?> tClass = Thread.currentThread().getClass();
        return tClass == AsyncRenderer.AsyncRendererThread.class || tClass == AsyncTicker.AsyncTickerThread.class;
    }

    public static boolean isOnParticleRendererThread() {
        return Thread.currentThread().getClass() == AsyncRenderer.AsyncRendererThread.class;
    }

    public static boolean isOnParticleTickerThread() {
        return Thread.currentThread().getClass() == AsyncTicker.AsyncTickerThread.class;
    }

    public static boolean isOnClientTickThread() {
        return ThreadUtil.isOnMainThread() || ThreadUtil.isOnParticleTickerThread();
    }

    public static void runOnClient(Runnable runnable) {
        Minecraft.m_91087_().execute(runnable);
    }

    public static void enqueueClientTask(Runnable runnable) {
        Minecraft.m_91087_().f_18682_.add(runnable);
    }

    public static boolean isOnMainThread() {
        return RenderSystem.isOnRenderThread();
    }

    public static void assertOnMainThread() {
        RenderSystem.assertOnRenderThread();
    }
}

