/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.api.EndTickEvent;
import fabric.fun.qu_an.minecraft.asyncparticles.client.api.EndTickOperation;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.ParticleRainCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.AsyncParticleWorkerThread;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_6558;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_733;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends class_703>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<class_703> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static final AtomicBoolean cancelled = new AtomicBoolean(false);
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<EndTickEvent> SEQUENCED_END_TICK_EVENTS;
    private static final List<EndTickEvent> PARALLEL_END_TICK_EVENTS;
    private static final List<EndTickOperation> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final AtomicLong timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled.getOpaque()) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onTickBefore(int i, int to) {
        boolean levelRunning;
        if (!ConfigHelper.isTickAsync()) {
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("async_particles");
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            if (particleFuture != null) {
                cancelled.setOpaque(true);
                debug_cancelled = false;
                particleFuture.join();
                particleFuture = null;
                cancelled.setOpaque(false);
            }
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                class_702 particleEngine = mc.field_1713;
                Collection values = particleEngine.field_3830.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                Queue trackingEmitters = particleEngine.field_3837;
                futures[0] = trackingEmitters.isEmpty() ? Utils.NULL_FUTURE : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.method_3086()), EXECUTOR);
                int k = 1;
                boolean removeIfMissedTick = ConfigHelper.isRemoveIfMissedTick();
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = Utils.NULL_FUTURE;
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        if (!particle1.method_3086()) {
                            particle1.method_34019().ifPresent(group -> particleEngine.method_34022(group, -1));
                            return true;
                        }
                        ParticleAddon particleAddon = (ParticleAddon)particle1;
                        if (particleAddon.asyncparticles$isTickSync()) {
                            return false;
                        }
                        if (particleAddon.asyncparticles$isTicked()) {
                            particleAddon.asyncparticles$resetTicked();
                            return false;
                        }
                        if (removeIfMissedTick) {
                            particle1.method_3085();
                            particle1.method_34019().ifPresent(group -> particleEngine.method_34022(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.method_15407();
    }

    public static void onTickAfter(int i, int to) {
        List<EndTickOperation> endTickOperations;
        boolean levelRunning;
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (!ConfigHelper.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(Runnable::run);
            END_TICK_OPERATIONS.clear();
            if (levelRunning) {
                SEQUENCED_END_TICK_EVENTS.forEach(Runnable::run);
                PARALLEL_END_TICK_EVENTS.forEach(Runnable::run);
            }
            return;
        }
        class_3695 profiler = mc.method_16011();
        profiler.method_15396("async_particles");
        if (levelRunning) {
            profiler.method_15396("particle_tick");
            if (i == to - 1) {
                mc.field_1713.method_3057();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.method_15407();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        CompletableFuture<Void> particleFuture = CompletableFuture.runAsync(() -> timeUsageNano.setRelease(System.nanoTime()), EXECUTOR);
        CompletionStage<Void> sequencedTaskFuture = particleFuture;
        CompletionStage<Object> parallelEventsFuture = Utils.NULL_FUTURE;
        CompletionStage<Object> parallelOperationsFuture = Utils.NULL_FUTURE;
        if (levelRunning) {
            sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenRun(() -> {
                for (Runnable runnable : SEQUENCED_END_TICK_EVENTS) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(runnable, e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
            parallelEventsFuture = ((CompletableFuture)particleFuture.thenCompose(v -> {
                CompletableFuture[] completableFutures = new CompletableFuture[PARALLEL_END_TICK_EVENTS.size()];
                int j = 0;
                for (Runnable runnable : PARALLEL_END_TICK_EVENTS) {
                    completableFutures[j++] = CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                        if (!AsyncTicker.isTolerable(e) || EXCEPTION_TRACKER.addException(endTickEvent, (Throwable)e)) {
                            throw ExceptionUtil.toThrowDirectly(e);
                        }
                        return null;
                    });
                }
                return CompletableFuture.allOf(completableFutures);
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(endTickOperations = END_TICK_OPERATIONS).isEmpty()) {
            EndTickOperation[] endTickTasks = endTickOperations.toArray(new EndTickOperation[0]);
            endTickOperations.clear();
            sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenRun(() -> {
                for (EndTickOperation endTickTask : endTickTasks) {
                    if (endTickTask.isParallel()) continue;
                    try {
                        endTickTask.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.getId(), e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
            parallelOperationsFuture = ((CompletableFuture)particleFuture.thenCompose(v -> {
                CompletableFuture[] futures = new CompletableFuture[endTickTasks.length];
                int j = 0;
                for (EndTickOperation endTickTask : endTickTasks) {
                    if (!endTickTask.isParallel()) continue;
                    futures[j++] = CompletableFuture.runAsync(endTickTask, EXECUTOR).exceptionally(e -> {
                        if (!AsyncTicker.isTolerable(e) || EXCEPTION_TRACKER.addException(endTickTask.getId(), (Throwable)e)) {
                            throw ExceptionUtil.toThrowDirectly(e);
                        }
                        return null;
                    });
                }
                return j == 0 ? Utils.nullFuture() : CompletableFuture.allOf(Arrays.copyOf(futures, j));
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        sequencedTaskFuture = CompletableFuture.allOf(new CompletableFuture[]{sequencedTaskFuture, parallelEventsFuture, parallelOperationsFuture});
        List<Runnable> particleOperations = PARTICLE_OPERATIONS;
        if (!particleOperations.isEmpty()) {
            if (!levelRunning) {
                particleOperations.clear();
            } else {
                Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
                particleOperations.clear();
                Function<Void, CompletableFuture> function = v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR)).toArray(CompletableFuture[]::new)).exceptionally(AsyncTicker::tickExceptionally);
                sequencedTaskFuture = ((CompletableFuture)sequencedTaskFuture).thenCompose(function);
            }
        }
        AsyncTicker.particleFuture = ((CompletableFuture)sequencedTaskFuture).thenRunAsync(() -> timeUsageNano.setRelease(System.nanoTime() - timeUsageNano.getAcquire()), EXECUTOR);
        profiler.method_15407();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        class_310 mc = class_310.method_1551();
        if (!AsyncTicker.isTolerable(e) || mc.field_1687 != null && mc.field_1724 != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing tick tasks.", e);
        return null;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof class_6558 || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static void onTickingParticleException(class_703 particle, Throwable t) {
        if (ThreadUtil.isOnMainThread()) {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends class_703> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        if (ConfigHelper.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particleClass)) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particleClass);
            }
        } else {
            if (tolerable) {
                throw AsyncTicker.constructCrashReport(particle, new RuntimeException("Exception %s thrown while ticking particle %s, exceeds the threshold, please contact the author: %s".formatted(t.getClass().getName(), particle, "https://github.com/Harveykang/AsyncParticles/issues"), t));
            }
            throw AsyncTicker.constructCrashReport(particle, t);
        }
        AsyncTicker.recordSync(particle);
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED && ModListHelper.IS_LEGACY_PARTICLERAIN) {
            ParticleRainCompat.INSTANCE.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static class_148 constructCrashReport(class_703 particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being ticked");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particle.method_18122()).toString());
        return new class_148(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles && ConfigHelper.isTickAsync() || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        class_702 particleEngine = class_310.method_1551().field_1713;
        boolean enableLightCache = ConfigHelper.particleLightCache();
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        Iterator<class_703> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            class_703 particle = iterator.next();
            try {
                particleEngine.method_3059(particle);
                if (!(particle instanceof class_733)) {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    }
                    switch (particleCullingMode) {
                        case ASYNC_AABB: {
                            ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                            break;
                        }
                        case ASYNC_SPHERE: {
                            ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                        }
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.method_3086()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<? extends class_703>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_703 particle) {
        Set<class_703> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(class_703 particle) {
        particle.method_34019().ifPresent(g -> class_310.method_1551().field_1713.method_34022(g, -1));
        if (particle.method_3086()) {
            particle.method_3085();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        class_702 particleEngine = class_310.method_1551().field_1713;
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(ConfigHelper.isTickAsync() ? (double)timeUsageNano.getAcquire() / 1000000.0 : Double.NaN, debug_cancelled, PARTICLE_OPERATIONS.size(), SEQUENCED_END_TICK_EVENTS.size() + PARALLEL_END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), ConfigHelper.getParticleLimit(), class_310.method_1551().field_1713.field_3830.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), class_310.method_1551().field_1713.field_3836.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        class_702 particleEngine = class_310.method_1551().field_1713;
        LOGGER.info((ModListHelper.IS_FORGE ? particleEngine.field_3830.keySet() : class_702.field_17820).stream().collect(Collectors.toMap(class_3999::getClass, Object::toString)));
        LOGGER.info((Object)particleEngine.field_3830);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        class_702 particleEngine = class_310.method_1551().field_1713;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.method_48015();
        } else {
            BusyWaitEvictingQueue<class_703> newToAdd = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.field_3836);
            particleEngine.field_3836 = newToAdd;
            BusyWaitEvictingQueue<class_733> newEmitters = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.field_3837);
            particleEngine.field_3837 = newEmitters;
            boolean enableLightCache = ConfigHelper.particleLightCache();
            ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
            particleEngine.field_3830.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<class_703> newQueue = IterationSafeEvictingQueue.newInstance(queue.size(), ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                newQueue.forEach(p -> {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)p).asyncparticles$enableLightCache();
                        ((LightCachedParticleAddon)p).asyncparticles$refresh();
                    } else {
                        ((LightCachedParticleAddon)p).asyncparticles$disableLightCache();
                    }
                    switch (particleCullingMode) {
                        case ASYNC_AABB: {
                            ((ParticleAddon)p).asyncparticles$tickAABBCulling();
                            break;
                        }
                        case ASYNC_SPHERE: {
                            ((ParticleAddon)p).asyncparticles$tickSphereCulling();
                        }
                    }
                });
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        AsyncTicker.waitForCleanUp();
        if (particleFuture != null) {
            cancelled.setOpaque(true);
            particleFuture.join();
            particleFuture = null;
        }
        cancelled.setOpaque(false);
        timeUsageNano.set(0L);
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void registerEvent(EndTickEvent task) {
        if (task.isParallel()) {
            List<EndTickEvent> list = PARALLEL_END_TICK_EVENTS;
            synchronized (list) {
                PARALLEL_END_TICK_EVENTS.add(task);
                PARALLEL_END_TICK_EVENTS.sort(Comparator.comparingInt(EndTickEvent::getPriority));
            }
        }
        List<EndTickEvent> list = SEQUENCED_END_TICK_EVENTS;
        synchronized (list) {
            SEQUENCED_END_TICK_EVENTS.add(task);
            SEQUENCED_END_TICK_EVENTS.sort(Comparator.comparingInt(EndTickEvent::getPriority));
        }
    }

    @ApiStatus.Internal
    public static void scheduleOperation(EndTickOperation task) {
        if (!shouldTickParticles && ConfigHelper.isTickAsync()) {
            return;
        }
        if (ThreadUtil.isOnMainThread()) {
            END_TICK_OPERATIONS.add(task);
        } else {
            ThreadUtil.enqueueClientTask(() -> END_TICK_OPERATIONS.add(task));
        }
    }

    static {
        SEQUENCED_END_TICK_EVENTS = new ArrayList<EndTickEvent>();
        PARALLEL_END_TICK_EVENTS = new ArrayList<EndTickEvent>();
        END_TICK_OPERATIONS = new ArrayList<EndTickOperation>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
        timeUsageNano = new AtomicLong(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            AsyncTickerThread forkJoinWorkerThread = new AsyncTickerThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
    }

    public static class AsyncTickerThread
    extends AsyncParticleWorkerThread {
        public AsyncTickerThread(ForkJoinPool forkJoinPool) {
            super(forkJoinPool);
        }

        @Override
        protected void onTermination(Throwable throwable) {
            if (throwable != null) {
                LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
            } else {
                LOGGER.debug("{} shutdown", (Object)this.getName());
            }
            super.onTermination(throwable);
        }
    }
}

