/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client;

import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.api.EndTickEvent;
import forge.fun.qu_an.minecraft.asyncparticles.client.api.EndTickOperation;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.ParticleRainCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.AsyncParticleWorkerThread;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Particle> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static final AtomicBoolean cancelled = new AtomicBoolean(false);
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<EndTickEvent> SEQUENCED_END_TICK_EVENTS;
    private static final List<EndTickEvent> PARALLEL_END_TICK_EVENTS;
    private static final List<EndTickOperation> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final AtomicLong timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled.getOpaque()) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onTickBefore(int i, int to) {
        boolean levelRunning;
        if (!ConfigHelper.isTickAsync()) {
            return;
        }
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("async_particles");
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = levelRunning = mc.f_91073_ != null && mc.f_91074_ != null && !mc.m_91104_();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            if (particleFuture != null) {
                cancelled.setOpaque(true);
                debug_cancelled = false;
                particleFuture.join();
                particleFuture = null;
                cancelled.setOpaque(false);
            }
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                ParticleEngine particleEngine = mc.f_91061_;
                Collection values = particleEngine.f_107289_.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                Queue trackingEmitters = particleEngine.f_107290_;
                futures[0] = trackingEmitters.isEmpty() ? Utils.NULL_FUTURE : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.m_107276_()), EXECUTOR);
                int k = 1;
                boolean removeIfMissedTick = ConfigHelper.isRemoveIfMissedTick();
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = Utils.NULL_FUTURE;
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        if (!particle1.m_107276_()) {
                            particle1.m_142654_().ifPresent(group -> particleEngine.m_172281_(group, -1));
                            return true;
                        }
                        ParticleAddon particleAddon = (ParticleAddon)particle1;
                        if (particleAddon.asyncparticles$isTickSync()) {
                            return false;
                        }
                        if (particleAddon.asyncparticles$isTicked()) {
                            particleAddon.asyncparticles$resetTicked();
                            return false;
                        }
                        if (removeIfMissedTick) {
                            particle1.m_107274_();
                            particle1.m_142654_().ifPresent(group -> particleEngine.m_172281_(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.m_7238_();
    }

    public static void onTickAfter(int i, int to) {
        List<EndTickOperation> endTickOperations;
        boolean levelRunning;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = levelRunning = mc.f_91073_ != null && mc.f_91074_ != null && !mc.m_91104_();
        if (!ConfigHelper.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(Runnable::run);
            END_TICK_OPERATIONS.clear();
            if (levelRunning) {
                SEQUENCED_END_TICK_EVENTS.forEach(Runnable::run);
                PARALLEL_END_TICK_EVENTS.forEach(Runnable::run);
            }
            return;
        }
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6180_("async_particles");
        if (levelRunning) {
            profiler.m_6180_("particle_tick");
            if (i == to - 1) {
                mc.f_91061_.m_107388_();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.m_7238_();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        CompletableFuture<Void> particleFuture = CompletableFuture.runAsync(() -> timeUsageNano.setRelease(System.nanoTime()), EXECUTOR);
        CompletionStage<Void> sequencedTaskFuture = particleFuture;
        CompletionStage<Object> parallelEventsFuture = Utils.NULL_FUTURE;
        CompletionStage<Object> parallelOperationsFuture = Utils.NULL_FUTURE;
        if (levelRunning) {
            sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenRun(() -> {
                for (Runnable runnable : SEQUENCED_END_TICK_EVENTS) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(runnable, e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
            parallelEventsFuture = ((CompletableFuture)particleFuture.thenCompose(v -> {
                CompletableFuture[] completableFutures = new CompletableFuture[PARALLEL_END_TICK_EVENTS.size()];
                int j = 0;
                for (Runnable runnable : PARALLEL_END_TICK_EVENTS) {
                    completableFutures[j++] = CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                        if (!AsyncTicker.isTolerable(e) || EXCEPTION_TRACKER.addException(endTickEvent, (Throwable)e)) {
                            throw ExceptionUtil.toThrowDirectly(e);
                        }
                        return null;
                    });
                }
                return CompletableFuture.allOf(completableFutures);
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(endTickOperations = END_TICK_OPERATIONS).isEmpty()) {
            EndTickOperation[] endTickTasks = endTickOperations.toArray(new EndTickOperation[0]);
            endTickOperations.clear();
            sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenRun(() -> {
                for (EndTickOperation endTickTask : endTickTasks) {
                    if (endTickTask.isParallel()) continue;
                    try {
                        endTickTask.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.getId(), e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
            parallelOperationsFuture = ((CompletableFuture)particleFuture.thenCompose(v -> {
                CompletableFuture[] futures = new CompletableFuture[endTickTasks.length];
                int j = 0;
                for (EndTickOperation endTickTask : endTickTasks) {
                    if (!endTickTask.isParallel()) continue;
                    futures[j++] = CompletableFuture.runAsync(endTickTask, EXECUTOR).exceptionally(e -> {
                        if (!AsyncTicker.isTolerable(e) || EXCEPTION_TRACKER.addException(endTickTask.getId(), (Throwable)e)) {
                            throw ExceptionUtil.toThrowDirectly(e);
                        }
                        return null;
                    });
                }
                return j == 0 ? Utils.nullFuture() : CompletableFuture.allOf(Arrays.copyOf(futures, j));
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        sequencedTaskFuture = CompletableFuture.allOf(new CompletableFuture[]{sequencedTaskFuture, parallelEventsFuture, parallelOperationsFuture});
        List<Runnable> particleOperations = PARTICLE_OPERATIONS;
        if (!particleOperations.isEmpty()) {
            if (!levelRunning) {
                particleOperations.clear();
            } else {
                Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
                particleOperations.clear();
                Function<Void, CompletableFuture> function = v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR)).toArray(CompletableFuture[]::new)).exceptionally(AsyncTicker::tickExceptionally);
                sequencedTaskFuture = ((CompletableFuture)sequencedTaskFuture).thenCompose(function);
            }
        }
        AsyncTicker.particleFuture = ((CompletableFuture)sequencedTaskFuture).thenRunAsync(() -> timeUsageNano.setRelease(System.nanoTime() - timeUsageNano.getAcquire()), EXECUTOR);
        profiler.m_7238_();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!AsyncTicker.isTolerable(e) || mc.f_91073_ != null && mc.f_91074_ != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing tick tasks.", e);
        return null;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof MissingPaletteEntryException || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static void onTickingParticleException(Particle particle, Throwable t) {
        if (ThreadUtil.isOnMainThread()) {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends Particle> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        if (ConfigHelper.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particleClass)) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particleClass);
            }
        } else {
            if (tolerable) {
                throw AsyncTicker.constructCrashReport(particle, new RuntimeException("Exception %s thrown while ticking particle %s, exceeds the threshold, please contact the author: %s".formatted(t.getClass().getName(), particle, "https://github.com/Harveykang/AsyncParticles/issues"), t));
            }
            throw AsyncTicker.constructCrashReport(particle, t);
        }
        AsyncTicker.recordSync(particle);
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED && ModListHelper.IS_LEGACY_PARTICLERAIN) {
            ParticleRainCompat.INSTANCE.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static ReportedException constructCrashReport(Particle particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Ticking Particle");
        CrashReportCategory crashReportCategory = crashReport.m_127514_("Particle being ticked");
        crashReportCategory.m_128165_("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.m_128165_("Particle Type", () -> ((ParticleRenderType)particle.m_7556_()).toString());
        return new ReportedException(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles && ConfigHelper.isTickAsync() || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        boolean enableLightCache = ConfigHelper.particleLightCache();
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        Iterator<Particle> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            try {
                particleEngine.m_107393_(particle);
                if (!(particle instanceof TrackingEmitter)) {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    }
                    switch (particleCullingMode) {
                        case ASYNC_AABB: {
                            ((ParticleAddon)particle).asyncparticles$tickAABBCulling();
                            break;
                        }
                        case ASYNC_SPHERE: {
                            ((ParticleAddon)particle).asyncparticles$tickSphereCulling();
                        }
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.m_107276_()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(Particle particle) {
        Set<Particle> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(Particle particle) {
        particle.m_142654_().ifPresent(g -> Minecraft.m_91087_().f_91061_.m_172281_(g, -1));
        if (particle.m_107276_()) {
            particle.m_107274_();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(ConfigHelper.isTickAsync() ? (double)timeUsageNano.getAcquire() / 1000000.0 : Double.NaN, debug_cancelled, PARTICLE_OPERATIONS.size(), SEQUENCED_END_TICK_EVENTS.size() + PARALLEL_END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), ConfigHelper.getParticleLimit(), Minecraft.m_91087_().f_91061_.f_107289_.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), Minecraft.m_91087_().f_91061_.f_107294_.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        LOGGER.info((ModListHelper.IS_FORGE ? particleEngine.f_107289_.keySet() : ParticleEngine.f_107288_).stream().collect(Collectors.toMap(ParticleRenderType::getClass, Object::toString)));
        LOGGER.info((Object)particleEngine.f_107289_);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.m_263560_();
        } else {
            BusyWaitEvictingQueue<Particle> newToAdd = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.f_107294_);
            particleEngine.f_107294_ = newToAdd;
            BusyWaitEvictingQueue<TrackingEmitter> newEmitters = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.f_107290_);
            particleEngine.f_107290_ = newEmitters;
            boolean enableLightCache = ConfigHelper.particleLightCache();
            ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
            particleEngine.f_107289_.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<Particle> newQueue = IterationSafeEvictingQueue.newInstance(queue.size(), ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                newQueue.forEach(p -> {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)p).asyncparticles$enableLightCache();
                        ((LightCachedParticleAddon)p).asyncparticles$refresh();
                    } else {
                        ((LightCachedParticleAddon)p).asyncparticles$disableLightCache();
                    }
                    switch (particleCullingMode) {
                        case ASYNC_AABB: {
                            ((ParticleAddon)p).asyncparticles$tickAABBCulling();
                            break;
                        }
                        case ASYNC_SPHERE: {
                            ((ParticleAddon)p).asyncparticles$tickSphereCulling();
                        }
                    }
                });
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        AsyncTicker.waitForCleanUp();
        if (particleFuture != null) {
            cancelled.setOpaque(true);
            particleFuture.join();
            particleFuture = null;
        }
        cancelled.setOpaque(false);
        timeUsageNano.set(0L);
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void registerEvent(EndTickEvent task) {
        if (task.isParallel()) {
            List<EndTickEvent> list = PARALLEL_END_TICK_EVENTS;
            synchronized (list) {
                PARALLEL_END_TICK_EVENTS.add(task);
                PARALLEL_END_TICK_EVENTS.sort(Comparator.comparingInt(EndTickEvent::getPriority));
            }
        }
        List<EndTickEvent> list = SEQUENCED_END_TICK_EVENTS;
        synchronized (list) {
            SEQUENCED_END_TICK_EVENTS.add(task);
            SEQUENCED_END_TICK_EVENTS.sort(Comparator.comparingInt(EndTickEvent::getPriority));
        }
    }

    @ApiStatus.Internal
    public static void scheduleOperation(EndTickOperation task) {
        if (!shouldTickParticles && ConfigHelper.isTickAsync()) {
            return;
        }
        if (ThreadUtil.isOnMainThread()) {
            END_TICK_OPERATIONS.add(task);
        } else {
            ThreadUtil.enqueueClientTask(() -> END_TICK_OPERATIONS.add(task));
        }
    }

    static {
        SEQUENCED_END_TICK_EVENTS = new ArrayList<EndTickEvent>();
        PARALLEL_END_TICK_EVENTS = new ArrayList<EndTickEvent>();
        END_TICK_OPERATIONS = new ArrayList<EndTickOperation>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
        timeUsageNano = new AtomicLong(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.m_14045_((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            AsyncTickerThread forkJoinWorkerThread = new AsyncTickerThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::m_137495_, true);
    }

    public static class AsyncTickerThread
    extends AsyncParticleWorkerThread {
        public AsyncTickerThread(ForkJoinPool forkJoinPool) {
            super(forkJoinPool);
        }

        @Override
        protected void onTermination(Throwable throwable) {
            if (throwable != null) {
                LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
            } else {
                LOGGER.debug("{} shutdown", (Object)this.getName());
            }
            super.onTermination(throwable);
        }
    }
}

