/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.forge;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRegistry;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.create.CreateUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.ParticleRainCompat;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.RippleParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.ShipHitResult;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.VSClientUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.RainEffect;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.GameUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ParticleRainCompatImpl
extends ParticleRainCompat {
    public static ParticleRainCompat newInstance() {
        if (ModListHelper.FABRIC_PARTICLERAIN_LOADED) {
            return forge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.v3.fabric.ParticleRainCompatImpl.newInstance();
        }
        return new ParticleRainCompatImpl();
    }

    @Override
    public void onShipCollision(ClientLevel level, Vec3 location, Vec3 movement, AABB aabb) {
        RainEffect vsRainEffect = ConfigHelper.getVSRainEffect();
        if (vsRainEffect == RainEffect.NONE || !ParticleRainClient.config.doRippleParticles && !ParticleRainClient.config.doSplashParticles) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ShipHitResult hit = VSClientUtils.clipShip(level, new ClipContext(location, location.m_82549_(movement.m_82541_().m_82490_(aabb.m_82309_())), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)mc.f_91074_), true);
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        Vec3 shipMotion = hit.shipMotion;
        if (vsRainEffect == RainEffect.STATIONARY && GameUtil.manhattanLength(shipMotion) > 0.05) {
            return;
        }
        Vec3 spawnPos = hit.m_82450_().m_82549_(shipMotion);
        FluidState fluidState = level.m_6425_(hit.m_82425_());
        if (ParticleRainClient.config.doRippleParticles && fluidState.m_164512_((Fluid)Fluids.f_76193_)) {
            Particle particle = mc.f_91061_.m_107370_((ParticleOptions)ParticleRegistry.RIPPLE.get(), spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
            if (particle != null) {
                Vec3i normal = hit.m_82434_().m_122436_();
                Vector3f normal1 = hit.shipToWorld.transformDirection(new Vector3f((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_())).normalize();
                ((RippleParticleAddon)particle).asyncedParticles$setNormal(normal1);
            }
            if (level.m_46470_() && ParticleRainClient.config.doSplashParticles) {
                mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
            }
        } else if (ParticleRainClient.config.doSplashParticles && fluidState.m_76178_()) {
            mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onCreateCollision(@NotNull ClientLevel level, Vec3 originalMotion, @NotNull Vec3 clipMotion, @NotNull AABB aabb) {
        RainEffect createRainEffect = ConfigHelper.getCreateRainEffect();
        if (createRainEffect != RainEffect.NONE && ParticleRainClient.config.doSplashParticles) {
            Vec3 center = aabb.m_82399_();
            AABB aabb1 = new AABB(center.f_82479_, aabb.f_82289_ - 1.0, center.f_82481_, center.f_82479_, aabb.f_82289_, center.f_82481_);
            Vec3 motion1 = originalMotion.m_82490_(2.0);
            if (CreateUtil.isCollideWithContraption(level, motion1, aabb1, false).canSpawnRainEffect(createRainEffect)) {
                Vec3 startPos = new Vec3(center.f_82479_, aabb.f_82289_, center.f_82481_);
                Vec3 spawnPos = startPos.m_82549_(clipMotion);
                Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123761_, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }
}

