/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.util;

import com.mojang.logging.LogUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;
import org.slf4j.Logger;

public class ExceptionTracker<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<T, Map<Class<? extends Throwable>, ExceptionQueue>> exceptions = new ConcurrentHashMap<T, Map<Class<? extends Throwable>, ExceptionQueue>>();
    private final IntSupplier duration;
    private final IntSupplier failurePerSecThreshold;

    public ExceptionTracker(IntSupplier duration, IntSupplier failurePerSecThreshold) {
        this.failurePerSecThreshold = failurePerSecThreshold;
        this.duration = duration;
    }

    public boolean addException(T obj, Throwable t) {
        Throwable rootCause = ExceptionUtil.getRootCause(t);
        return this.exceptions.computeIfAbsent(obj, k -> new ConcurrentHashMap()).computeIfAbsent(rootCause.getClass(), k -> {
            LOGGER.warn("Captured exception: (Note: If you encountered a crash, this exception is likely not the cause, please check the crash report for details)", t);
            return new ExceptionQueue();
        }).push();
    }

    public String toString() {
        return "ExceptionTracker{exceptions=" + String.valueOf(this.exceptions) + ", duration=" + this.duration.getAsInt() + ", failurePerSecThreshold=" + this.failurePerSecThreshold.getAsInt() + "}";
    }

    private class ExceptionQueue {
        private final LongPriorityQueue queue = new LongArrayFIFOQueue();

        private ExceptionQueue() {
        }

        public synchronized boolean push() {
            long time = System.currentTimeMillis();
            LongPriorityQueue queue = this.queue;
            int size = queue.size();
            while (size-- > 0 && time - queue.firstLong() > (long)ExceptionTracker.this.duration.getAsInt()) {
                queue.dequeueLong();
            }
            queue.enqueue(time);
            return (double)queue.size() / ((double)ExceptionTracker.this.duration.getAsInt() * 0.001) >= (double)ExceptionTracker.this.failurePerSecThreshold.getAsInt();
        }

        public String toString() {
            return "Exception queue size: " + this.queue.size();
        }
    }
}

