/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.util;

import forge.fun.qu_an.minecraft.asyncparticles.client.util.AsyncParticleWorkerThread;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ParticleThreadLocal<T> {
    public final int index = AsyncParticleWorkerThread.nextThreadLocalIndex();
    protected ThreadLocal<T> fallback;

    public static <S> ParticleThreadLocal<S> withInitial(Supplier<? extends S> supplier) {
        return new SuppliedParticleThreadLocal<S>(supplier);
    }

    public void setUnsafe(T value) {
        AsyncParticleWorkerThread wt = (AsyncParticleWorkerThread)Thread.currentThread();
        wt.setThreadLocalValue(this.index, value);
    }

    public T getUnsafe() {
        AsyncParticleWorkerThread wt = (AsyncParticleWorkerThread)Thread.currentThread();
        return (T)wt.getThreadLocalValue(this.index);
    }

    public T getSafe(T orElse) {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof AsyncParticleWorkerThread)) {
            return orElse;
        }
        return this.getUnsafe();
    }

    public T getSafe(Supplier<T> orElse) {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof AsyncParticleWorkerThread)) {
            return orElse.get();
        }
        return this.getUnsafe();
    }

    public T get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof AsyncParticleWorkerThread) {
            return this.getUnsafe();
        }
        if (this.fallback == null) {
            this.fallback = this.newFallbackThreadLocal();
            return this.fallback.get();
        }
        return this.fallback.get();
    }

    protected ThreadLocal<T> newFallbackThreadLocal() {
        return new ThreadLocal();
    }

    public void set(T value) {
        Thread thread = Thread.currentThread();
        if (thread instanceof AsyncParticleWorkerThread) {
            AsyncParticleWorkerThread wt = (AsyncParticleWorkerThread)thread;
            this.setUnsafe(value);
        } else if (this.fallback == null) {
            this.fallback = this.newFallbackThreadLocal();
            this.fallback.set(value);
        } else {
            this.fallback.set(value);
        }
    }

    public void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof AsyncParticleWorkerThread) {
            AsyncParticleWorkerThread wt = (AsyncParticleWorkerThread)thread;
            this.setUnsafe(null);
        } else if (this.fallback != null) {
            this.fallback.remove();
        }
    }

    protected static final class SuppliedParticleThreadLocal<S>
    extends ParticleThreadLocal<S> {
        private static final Object NULL_VALUE = new Object();
        private final Supplier<? extends S> supplier;

        private SuppliedParticleThreadLocal(Supplier<? extends S> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void setUnsafe(S value) {
            AsyncParticleWorkerThread wt = (AsyncParticleWorkerThread)Thread.currentThread();
            wt.setThreadLocalValue(this.index, value == null ? NULL_VALUE : value);
        }

        @Override
        public S getUnsafe() {
            AsyncParticleWorkerThread wt = (AsyncParticleWorkerThread)Thread.currentThread();
            Object value = wt.getThreadLocalValue(this.index);
            if (value == null) {
                S value1 = this.supplier.get();
                this.setUnsafe(value1);
                return value1;
            }
            return (S)(value == NULL_VALUE ? null : value);
        }

        @Override
        protected ThreadLocal<S> newFallbackThreadLocal() {
            return ThreadLocal.withInitial(this.supplier);
        }
    }
}

