/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BindingTesselator;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_9801;
import net.minecraft.class_9976;
import org.jetbrains.annotations.Nullable;

public class WeatherRenderer {
    private static CompletableFuture<Void> weatherTask;
    static class_9976.class_9977[] rainColumns;
    static class_9976.class_9977[] snowColumns;
    @Nullable
    private static BindingTesselator rainBTesselator;
    @Nullable
    private static BindingTesselator snowBTesselator;
    private static boolean weatherEnabled;

    public static void beginWeather(float partialTick, class_243 cameraPos, int rainDistance, class_9976 weatherRenderer, int ticks) {
        if (!weatherEnabled) {
            WeatherRenderer.waitForWeatherTask();
            return;
        }
        weatherEnabled = false;
        class_310 mc = class_310.method_1551();
        float rainLevel = mc.field_1687.method_8430(partialTick);
        if (rainLevel > 0.0f) {
            weatherTask = CompletableFuture.runAsync(() -> {
                ObjectArrayList rainColumns = ObjectArrayList.wrap((Object[])rainColumns, (int)0);
                ObjectArrayList snowColumns = ObjectArrayList.wrap((Object[])snowColumns, (int)0);
                weatherRenderer.method_62315((class_1937)mc.field_1687, ticks, partialTick, cameraPos, rainDistance, (List)rainColumns, (List)snowColumns);
                rainColumns = (class_9976.class_9977[])rainColumns.elements();
                snowColumns = (class_9976.class_9977[])snowColumns.elements();
                if (!rainColumns.isEmpty()) {
                    if (rainBTesselator == null) {
                        rainBTesselator = new BindingTesselator(1536, VertexFormat.class_5596.field_27382, class_290.field_1584);
                    }
                    weatherRenderer.method_62318((class_4588)rainBTesselator.begin(), (List)rainColumns, cameraPos, 1.0f, rainDistance, rainLevel);
                }
                if (!snowColumns.isEmpty()) {
                    if (snowBTesselator == null) {
                        snowBTesselator = new BindingTesselator(1536, VertexFormat.class_5596.field_27382, class_290.field_1584);
                    }
                    weatherRenderer.method_62318((class_4588)snowBTesselator.begin(), (List)snowColumns, cameraPos, 0.8f, rainDistance, rainLevel);
                }
            }, AsyncRenderer.EXECUTOR).exceptionally(throwable -> {
                throw ExceptionUtil.toThrowDirectly(throwable);
            });
        }
    }

    public static void endRain(class_1921 renderType) {
        WeatherRenderer.end0(rainBTesselator, renderType);
    }

    public static void endSnow(class_1921 renderType) {
        WeatherRenderer.end0(snowBTesselator, renderType);
    }

    private static void end0(@Nullable BindingTesselator tesselator, class_1921 renderType) {
        if (tesselator == null) {
            return;
        }
        class_287 builder = tesselator.getBuilder();
        if (builder == null || !builder.field_1556) {
            return;
        }
        class_9801 meshData = builder.method_60794();
        if (meshData == null) {
            return;
        }
        if (renderType.method_60894()) {
            meshData.method_60819(tesselator.buffer, RenderSystem.getProjectionType().method_65045());
        }
        renderType.method_60895(meshData);
    }

    public static void waitForWeatherTask() {
        if (weatherTask != null) {
            weatherTask.join();
            weatherTask = null;
        }
    }

    public static void reset() {
        weatherEnabled = false;
        if (rainBTesselator != null) {
            rainBTesselator.close();
            rainBTesselator = null;
        }
        if (snowBTesselator != null) {
            snowBTesselator.close();
            snowBTesselator = null;
        }
        rainColumns = new class_9976.class_9977[0];
        snowColumns = new class_9976.class_9977[0];
    }

    public static boolean shouldRenderRain() {
        class_287 builder;
        WeatherRenderer.waitForWeatherTask();
        return rainBTesselator != null && (builder = rainBTesselator.getBuilder()) != null && builder.field_1556;
    }

    public static boolean shouldRenderSnow() {
        class_287 builder;
        WeatherRenderer.waitForWeatherTask();
        return snowBTesselator != null && (builder = snowBTesselator.getBuilder()) != null && builder.field_1556;
    }

    public static void markWeatherEnabled() {
        weatherEnabled = true;
    }

    static {
        rainColumns = new class_9976.class_9977[0];
        snowColumns = new class_9976.class_9977[0];
    }
}

