/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.fabric;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncParticlesClient;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.AsyncParticlesConfig;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public final class AsyncParticlesClientFabric
implements ClientModInitializer {
    private static CompletableFuture<Suggestions> suggestModId(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(FabricLoader.getInstance().getAllMods().stream().map(modContainer -> modContainer.getMetadata().getId()), (SuggestionsBuilder)builder);
    }

    public void onInitializeClient() {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        AsyncParticlesClient.init();
        if (ModListHelper.FABRIC_API_LOADED) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"asyncparticles").then(ClientCommandManager.literal((String)"isfabricmod").then(ClientCommandManager.argument((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncParticlesClientFabric::suggestModId).executes(context -> {
                String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(modId + " is " + (ModListHelper.isFabricModLoaded(modId) ? "fabric mod" : (ModListHelper.isModLoaded(modId) ? "not fabric mod" : "not loaded")))));
                return 1;
            })))).then(ClientCommandManager.literal((String)"isforgemod").then(ClientCommandManager.argument((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncParticlesClientFabric::suggestModId).executes(context -> {
                String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(modId + " is " + (ModListHelper.isForgeModLoaded(modId) ? "forge mod" : (ModListHelper.isModLoaded(modId) ? "not forge mod" : "not loaded")))));
                return 1;
            })))).then(ClientCommandManager.literal((String)"debug").executes(context -> {
                FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
                AsyncTicker.debugLater(s -> source.sendFeedback((class_2561)class_2561.method_43470((String)s).method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(s)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Copy to clipboard"))))));
                AsyncRenderer.debugLater(s -> source.sendFeedback((class_2561)class_2561.method_43470((String)s).method_27696(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(s)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Copy to clipboard"))))));
                return 1;
            }))).then(ClientCommandManager.literal((String)"dump").executes(context -> {
                FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
                AsyncTicker.dumpParticles();
                source.sendFeedback((class_2561)class_2561.method_43470((String)"Particles have been dumped to log."));
                return 1;
            }))).then(ClientCommandManager.literal((String)"class_exists").then(ClientCommandManager.argument((String)"className", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String className = StringArgumentType.getString((CommandContext)context, (String)"className");
                if (ModListHelper.classExists(className)) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Class " + className + " exists!")));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Class " + className + " not exists.")));
                }
                return 1;
            })))).then(ClientCommandManager.literal((String)"load_class").then(ClientCommandManager.argument((String)"className", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String className = StringArgumentType.getString((CommandContext)context, (String)"className");
                if (ModListHelper.loadClass(className)) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Class " + className + " exists!")));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Class " + className + " not exists.")));
                }
                return 1;
            })))).then(ClientCommandManager.literal((String)"version_check").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"modid", (ArgumentType)StringArgumentType.word()).suggests(AsyncParticlesClientFabric::suggestModId).executes(context -> {
                String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
                if (ModListHelper.isModLoaded(modId)) {
                    String version = ModListHelper.versionToString(modId);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(modId + " version " + version)));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(modId + " is not loaded")));
                }
                return 1;
            })).then(ClientCommandManager.argument((String)"min_inclusive", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"max_exclusive", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String modId = StringArgumentType.getString((CommandContext)context, (String)"modid");
                String minInclusive = StringArgumentType.getString((CommandContext)context, (String)"min_inclusive");
                String maxExclusive = StringArgumentType.getString((CommandContext)context, (String)"max_exclusive");
                if (ModListHelper.isModLoaded(modId)) {
                    boolean b = ModListHelper.versionCheck(modId, minInclusive, maxExclusive);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(modId + " version " + (b ? "is within" : "is not within") + " [" + minInclusive + ", " + maxExclusive + ")")));
                } else {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(modId + " is not loaded")));
                }
                return 1;
            })))))).then(ClientCommandManager.literal((String)"config").executes(context -> {
                class_310 mc = class_310.method_1551();
                ThreadUtil.enqueueClientTask(() -> mc.method_1507(AsyncParticlesConfig.newConfigScreen(null)));
                return 1;
            }))).then(ClientCommandManager.literal((String)"reload").executes(context -> {
                FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
                try {
                    ConfigHelper.load();
                }
                catch (Exception e) {
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"Failed to reload config"));
                    return 1;
                }
                AsyncTicker.reloadLater();
                source.sendFeedback((class_2561)class_2561.method_43470((String)"AsyncParticles config reloaded"));
                return 1;
            }))));
        }
    }
}

