/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.neoforge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleEngineAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.InternalRenderingMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ParticleCullingMode;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.FrustumUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class}, priority=500)
public class MixinParticleEngine_Render
implements ParticleEngineAddon {
    @Shadow
    public Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow
    public static List<ParticleRenderType> RENDER_ORDER;
    private static Enum<?> phase;

    @Overwrite(remap=false)
    private static void renderParticleType(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, ParticleRenderType particleRenderType, Queue<Particle> particles, @Nullable Frustum frustum) {
        VertexConsumer vertexconsumer = bufferSource.getBuffer(Objects.requireNonNull(particleRenderType.renderType()));
        if (frustum == null) {
            frustum = AsyncRenderer.frustum;
        }
        float f2 = f + 1.0f;
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        block7: for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            switch (particleCullingMode) {
                case AABB: {
                    float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    if (!((ParticleAddon)particle).asyncparticles$shouldCull() || FrustumUtil.isVisible(frustum, ((ParticleAddon)particle).getRenderBoundingBox(f3))) break;
                    continue block7;
                }
                case SPHERE: {
                    if (((ParticleAddon)particle).asyncparticles$shouldCull() && !FrustumUtil.isVisible(frustum, particle)) continue block7;
                    f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    break;
                }
                case ASYNC_AABB: 
                case ASYNC_SPHERE: {
                    if (!((ParticleAddon)particle).asyncparticles$isVisibleOnScreen()) continue block7;
                    f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    break;
                }
                default: {
                    float f5 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                }
            }
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            try {
                particle.render(vertexconsumer, camera, f3);
            }
            catch (Throwable t) {
                throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
            }
        }
    }

    @Overwrite(remap=false)
    public static void renderCustomParticles(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, Queue<Particle> particles, Frustum frustum) {
        PoseStack poseStack = new PoseStack();
        if (frustum == null) {
            frustum = AsyncRenderer.frustum;
        }
        float f2 = f + 1.0f;
        ParticleCullingMode particleCullingMode = ConfigHelper.getParticleCullingMode();
        block7: for (Particle particle : particles) {
            float f3;
            if (!particle.isAlive()) continue;
            switch (particleCullingMode) {
                case AABB: {
                    float f4 = f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    if (!((ParticleAddon)particle).asyncparticles$shouldCull() || FrustumUtil.isVisible(frustum, ((ParticleAddon)particle).getRenderBoundingBox(f3))) break;
                    continue block7;
                }
                case SPHERE: {
                    if (((ParticleAddon)particle).asyncparticles$shouldCull() && !FrustumUtil.isVisible(frustum, particle)) continue block7;
                    f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    break;
                }
                case ASYNC_AABB: 
                case ASYNC_SPHERE: {
                    if (!((ParticleAddon)particle).asyncparticles$isVisibleOnScreen()) continue block7;
                    f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                    break;
                }
                default: {
                    f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                }
            }
            try {
                particle.renderCustom(poseStack, (MultiBufferSource)bufferSource, camera, f3);
            }
            catch (Throwable t) {
                throw AsyncRenderer.constructCrashReport(particle, particle.getRenderType(), t);
            }
        }
    }

    @Overwrite(remap=false)
    public void render(Camera camera, float partialTick, MultiBufferSource.BufferSource bufferSource, @Nullable Frustum frustum, Predicate<ParticleRenderType> renderTypePredicate) {
        Queue<Particle> queue2;
        AsyncRenderer.particlePhase = true;
        Set<ParticleRenderType> renderOrder = this.particles.keySet();
        if (InternalRenderingMode.isAsync()) {
            AsyncRenderer.endAll(camera, partialTick, renderOrder, renderTypePredicate);
        } else {
            for (ParticleRenderType particleRenderType : renderOrder) {
                Queue<Particle> queue;
                if (particleRenderType.renderType() == null || !renderTypePredicate.test(particleRenderType) || (queue = this.particles.get(particleRenderType)) == null || queue.isEmpty()) continue;
                MixinParticleEngine_Render.renderParticleType(camera, partialTick, bufferSource, particleRenderType, queue, frustum);
            }
        }
        if (renderTypePredicate.test(ParticleRenderType.PARTICLE_SHEET_OPAQUE) && (queue2 = this.particles.get(ParticleRenderType.CUSTOM)) != null && !queue2.isEmpty()) {
            MixinParticleEngine_Render.renderCustomParticles(camera, partialTick, bufferSource, queue2, frustum);
        }
        bufferSource.endBatch();
        AsyncRenderer.particlePhase = false;
    }

    @Override
    public void asyncparticle$addRenderType(ParticleRenderType particleRenderType) {
    }

    @Override
    public void asyncparticle$sortRenderOrder() {
        List<ParticleRenderType> original = RENDER_ORDER;
        ArrayList<ParticleRenderType> renderOrder = new ArrayList<ParticleRenderType>(new LinkedHashSet<ParticleRenderType>(original));
        ArrayList<RenderType> indexHolder = new ArrayList<RenderType>(renderOrder.size());
        for (ParticleRenderType particleRenderType : renderOrder) {
            indexHolder.add(Objects.requireNonNull(particleRenderType.renderType()));
        }
        renderOrder.sort((a, b) -> {
            ParticleRenderType right;
            ParticleRenderType left;
            List l;
            RenderType renderTypeA = a.renderType();
            RenderType renderTypeB = b.renderType();
            int iA = -1;
            int iB = -1;
            if (renderTypeA == renderTypeB) {
                l = original;
                left = a;
                right = b;
            } else {
                l = indexHolder;
                left = renderTypeA;
                right = renderTypeB;
            }
            for (int i = 0; i < l.size(); ++i) {
                Object geti = l.get(i);
                if (iA == -1 && geti == left) {
                    iA = i;
                } else if (iB == -1 && geti == right) {
                    iB = i;
                }
                if (iA >= 0 && iB >= 0) break;
            }
            return Integer.compare(iA, iB);
        });
        RENDER_ORDER = ImmutableList.copyOf(renderOrder);
        TreeMap newTreeMap = Maps.newTreeMap((Comparator)ClientHooks.makeParticleRenderTypeComparator((List)RENDER_ORDER));
        newTreeMap.putAll(this.particles);
        this.particles = newTreeMap;
    }
}

