/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.LongRef;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_638;
import net.minecraft.class_6558;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_733;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends class_703>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<class_703> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static boolean cancelled = false;
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<Runnable> END_TICK_EVENTS;
    private static final List<Pair<class_2960, Runnable>> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ExecutorService EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final LongRef timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onTickBefore(int i, int to) {
        boolean levelRunning;
        if (!ConfigHelper.isTickAsync()) {
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("async_particles");
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            cancelled = true;
            debug_cancelled = false;
            if (particleFuture != null) {
                particleFuture.join();
                particleFuture = null;
            }
            cancelled = false;
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                class_702 particleEngine = mc.field_1713;
                Collection values = particleEngine.field_3830.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                Queue trackingEmitters = particleEngine.field_3837;
                futures[0] = trackingEmitters.isEmpty() ? Utils.NULL_FUTURE : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.method_3086()), EXECUTOR);
                int k = 1;
                boolean removeIfMissedTick = ConfigHelper.isRemoveIfMissedTick();
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = Utils.NULL_FUTURE;
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        if (!particle1.method_3086()) {
                            particle1.method_34019().ifPresent(group -> particleEngine.method_34022(group, -1));
                            return true;
                        }
                        ParticleAddon particleAddon = (ParticleAddon)particle1;
                        if (particleAddon.asyncparticles$isTickSync()) {
                            return false;
                        }
                        if (particleAddon.asyncparticles$isTicked()) {
                            particleAddon.asyncparticles$resetTicked();
                            return false;
                        }
                        if (removeIfMissedTick) {
                            particle1.method_3085();
                            particle1.method_34019().ifPresent(group -> particleEngine.method_34022(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.method_15407();
    }

    public static void onTickAfter(int i, int to) {
        List<Runnable> particleOperations;
        boolean levelRunning;
        class_310 mc = class_310.method_1551();
        boolean bl = levelRunning = mc.field_1687 != null && mc.field_1724 != null && !mc.method_1493();
        if (!ConfigHelper.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(p -> ((Runnable)p.second()).run());
            END_TICK_OPERATIONS.clear();
            if (levelRunning) {
                END_TICK_EVENTS.forEach(Runnable::run);
            }
            return;
        }
        class_3695 profiler = mc.method_16011();
        profiler.method_15396("async_particles");
        if (levelRunning) {
            profiler.method_15396("particle_tick");
            if (i == to - 1) {
                mc.field_1713.method_3057();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.method_15407();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        CompletionStage<Void> particleFuture = !levelRunning ? CompletableFuture.runAsync(() -> timeUsageNano.set(System.nanoTime()), EXECUTOR) : CompletableFuture.runAsync(() -> {
            timeUsageNano.set(System.nanoTime());
            for (Runnable endTickEvent : END_TICK_EVENTS) {
                try {
                    endTickEvent.run();
                }
                catch (Exception e) {
                    if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickEvent, e)) continue;
                    throw e;
                }
            }
        }, EXECUTOR).exceptionally(AsyncTicker::tickExceptionally);
        List<Pair<class_2960, Runnable>> endTickOperations = END_TICK_OPERATIONS;
        if (!endTickOperations.isEmpty()) {
            Pair[] endTickTasks = endTickOperations.toArray(new Pair[0]);
            endTickOperations.clear();
            Runnable runnable = () -> {
                for (Pair endTickTask : endTickTasks) {
                    try {
                        ((Runnable)endTickTask.second()).run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.first(), e)) continue;
                        throw e;
                    }
                }
            };
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenRun(runnable)).exceptionally(AsyncTicker::tickExceptionally);
        }
        if ((particleOperations = PARTICLE_OPERATIONS).isEmpty()) {
            particleFuture = ((CompletableFuture)particleFuture).thenRun(() -> timeUsageNano.set(System.nanoTime() - timeUsageNano.get()));
        } else if (!levelRunning) {
            particleOperations.clear();
            particleFuture = ((CompletableFuture)particleFuture).thenRun(() -> timeUsageNano.set(System.nanoTime() - timeUsageNano.get()));
        } else {
            Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
            particleOperations.clear();
            Function<Void, CompletableFuture> function = v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                if (!ConfigHelper.markSyncIfTickFailed() && AsyncTicker.isTolerable(e)) {
                    LOGGER.warn("Exception while executing particle operation, you can ignore it if it doesn't happen frequently.", e);
                    return null;
                }
                throw ExceptionUtil.toThrowDirectly(e);
            })).toArray(CompletableFuture[]::new));
            particleFuture = ((CompletableFuture)((CompletableFuture)particleFuture).thenCompose(function)).thenRun(() -> timeUsageNano.set(System.nanoTime() - timeUsageNano.get()));
        }
        AsyncTicker.particleFuture = particleFuture;
        profiler.method_15407();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        class_310 mc = class_310.method_1551();
        if (!AsyncTicker.isTolerable(e) && mc.field_1687 != null && mc.field_1724 != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing before particle operation", e);
        return null;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof class_6558 || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static void onTickingParticleException(class_703 particle, Throwable t) {
        if (RenderSystem.isOnRenderThread()) {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends class_703> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        if (ConfigHelper.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particleClass)) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particleClass);
            }
            AsyncTicker.recordSync(particle);
        } else if (tolerable) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Exception %s thrown while ticking particle %s exceeds the threshold, please contact the author: ".formatted(t.getClass().getSimpleName(), particleClass)).method_10852((class_2561)class_2561.method_43470((String)"https://github.com/Harveykang/AsyncParticles/issues").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Harveykang/AsyncParticles/issues")).method_30938(Boolean.valueOf(true)))));
            }
            LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
        } else {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            ParticleRainCompat.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static class_148 constructCrashReport(class_703 particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        class_128 crashReport = class_128.method_560((Throwable)t, (String)"Ticking Particle");
        class_129 crashReportCategory = crashReport.method_562("Particle being ticked");
        crashReportCategory.method_577("Particle", () -> ((class_703)particle).toString());
        crashReportCategory.method_577("Particle Type", () -> ((class_3999)particle.method_18122()).toString());
        return new class_148(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles && ConfigHelper.isTickAsync() || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        class_702 particleEngine = class_310.method_1551().field_1713;
        boolean enableLightCache = ConfigHelper.particleLightCache();
        Iterator<class_703> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            class_703 particle = iterator.next();
            try {
                particleEngine.method_3059(particle);
                if (!(particle instanceof class_733)) {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.method_3086()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends class_703> aClass) {
        Set<Class<? extends class_703>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(class_703 particle) {
        Set<class_703> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(class_703 particle) {
        particle.method_34019().ifPresent(g -> class_310.method_1551().field_1713.method_34022(g, -1));
        if (particle.method_3086()) {
            particle.method_3085();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(ConfigHelper.isTickAsync() ? (double)timeUsageNano.get() / 1000000.0 : Double.NaN, debug_cancelled, PARTICLE_OPERATIONS.size(), END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), ConfigHelper.getParticleLimit(), class_310.method_1551().field_1713.field_3830.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), class_310.method_1551().field_1713.field_3836.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        LOGGER.info((Object)class_310.method_1551().field_1713.field_3830);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        class_702 particleEngine = class_310.method_1551().field_1713;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.method_48015();
        } else {
            BusyWaitEvictingQueue<class_703> newToAdd = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.field_3836);
            particleEngine.field_3836 = newToAdd;
            BusyWaitEvictingQueue<class_733> newEmitters = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.field_3837);
            particleEngine.field_3837 = newEmitters;
            particleEngine.field_3830.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<class_703> newQueue = IterationSafeEvictingQueue.newInstance(queue.size(), ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        cancelled = true;
        AsyncTicker.waitForCleanUp();
        if (particleFuture != null) {
            particleFuture.join();
            particleFuture = null;
        }
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
        cancelled = false;
    }

    public static void registerEndTickEvent(MinecraftConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(class_310.method_1551()));
    }

    public static void registerEndTickEvent(ClientLevelConsumer consumer) {
        AsyncTicker.registerEndTickEvent(() -> consumer.accept(class_310.method_1551().field_1687));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEndTickEvent(Runnable operation) {
        List<Runnable> list = END_TICK_EVENTS;
        synchronized (list) {
            END_TICK_EVENTS.add(operation);
        }
    }

    public static void addEndTickTask(class_2960 resourceLocation, MinecraftConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(class_310.method_1551()));
    }

    public static void addEndTickTask(class_2960 resourceLocation, ClientLevelConsumer consumer) {
        AsyncTicker.addEndTickTask(resourceLocation, () -> consumer.accept(class_310.method_1551().field_1687));
    }

    public static void addEndTickTask(class_2960 resourceLocation, Runnable operation) {
        if (shouldTickParticles || !ConfigHelper.isTickAsync()) {
            if (RenderSystem.isOnRenderThread()) {
                END_TICK_OPERATIONS.add((Pair<class_2960, Runnable>)Pair.of((Object)resourceLocation, (Object)operation));
            } else {
                ThreadUtil.enqueueClientTask(() -> END_TICK_OPERATIONS.add((Pair<class_2960, Runnable>)Pair.of((Object)resourceLocation, (Object)operation)));
            }
        }
    }

    static {
        END_TICK_EVENTS = new ArrayList<Runnable>();
        END_TICK_OPERATIONS = new ArrayList<Pair<class_2960, Runnable>>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
        timeUsageNano = new LongRef(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
    }

    @FunctionalInterface
    public static interface MinecraftConsumer {
        public void accept(class_310 var1);
    }

    @FunctionalInterface
    public static interface ClientLevelConsumer {
        public void accept(class_638 var1);
    }
}

