/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2;

import forge.fun.qu_an.minecraft.asyncparticles.client.compat.vs2.ShipHitResult;
import forge.fun.qu_an.minecraft.asyncparticles.client.mixin.vs2.InvokerEntityShipCollisionUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.mixin.vs2.InvokerRaycastUtils;
import java.util.List;
import kotlin.Pair;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.collision.ConvexPolygonc;
import org.valkyrienskies.core.apigame.collision.EntityPolygonCollider;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.util.EntityShipCollisionUtils;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.BugFixUtil;

public class VSClientUtils {
    private static final EntityPolygonCollider collider = ValkyrienSkiesMod.vsCore.getEntityPolygonCollider();

    public static Iterable<ClientShip> getShipsInAABB(ClientLevel level, Vector3d v1, Vector3d v2) {
        return VSClientUtils.getShipsInAABB(level, new AABBd((Vector3dc)v1, (Vector3dc)v2));
    }

    public static Iterable<ClientShip> getShipsInAABB(ClientLevel world, double x1, double y1, double z1, double x2, double y2, double z2) {
        return VSClientUtils.getShipsInAABB(world, new AABBd(x1, y1, z1, x2, y2, z2));
    }

    public static Iterable<ClientShip> getShipsInAABB(ClientLevel world, AABBd aabb) {
        return VSGameUtilsKt.getShipObjectWorld((ClientLevel)world).getLoadedShips().getIntersecting((AABBdc)aabb.correctBounds());
    }

    public static Pair<Vec3, ClientShip> entityMovColShipOnlyAndGet(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, ClientLevel world) {
        double inflation = entity instanceof Player ? 0.5 : 0.1;
        double stepHeight = entity != null ? (double)entity.m_274421_() : 0.0;
        double yMovement = movement.m_7098_() + Math.max(stepHeight - inflation, 0.0);
        List<ConvexPolygonc> collidingShipPolygons = ((InvokerEntityShipCollisionUtils)EntityShipCollisionUtils.INSTANCE).invoker_getShipPolygonsCollidingWithEntity(entity, new Vec3(movement.m_7096_(), yMovement, movement.m_7094_()), entityBoundingBox.m_82400_(inflation), (Level)world);
        if (collidingShipPolygons.isEmpty()) {
            return new Pair((Object)movement, null);
        }
        Pair pair = collider.adjustEntityMovementForPolygonCollisions((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)movement), (AABBdc)VectorConversionsMCKt.toJOML((AABB)entityBoundingBox), stepHeight, collidingShipPolygons);
        Vector3dc newMovement = (Vector3dc)pair.getFirst();
        Long shipCollidingWith = (Long)pair.getSecond();
        if (shipCollidingWith != null) {
            if (entity != null) {
                ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
            }
            return new Pair((Object)VectorConversionsMCKt.toMinecraft((Vector3dc)newMovement), (Object)((ClientShip)VSGameUtilsKt.getShipObjectWorld((ClientLevel)world).getAllShips().getById(shipCollidingWith.longValue())));
        }
        return new Pair((Object)VectorConversionsMCKt.toMinecraft((Vector3dc)newMovement), null);
    }

    public static boolean isEntityMovColShipOnly(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, ClientLevel world, double inflation) {
        double stepHeight = entity != null ? (double)entity.m_274421_() : 0.0;
        double yMovement = movement.m_7098_() + Math.max(stepHeight - inflation, 0.0);
        Vec3 movement1 = new Vec3(movement.m_7096_(), yMovement, movement.m_7094_());
        AABB bb = entityBoundingBox.m_82400_(inflation);
        return VSClientUtils.hasShipPolygonsCollidingWithEntity(entity, movement1, bb, world);
    }

    public static boolean hasShipPolygonsCollidingWithEntity(Entity entity, Vec3 movement, AABB entityBoundingBox, ClientLevel world) {
        AABB entityBoxWithMovement = entityBoundingBox.m_82369_(movement);
        AABBd entityBoundingBoxExtended = AABBdUtilKt.extend((AABBd)VectorConversionsMCKt.toJOML((AABB)entityBoundingBox), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)movement));
        for (ClientShip shipObject : VSGameUtilsKt.getShipObjectWorld((ClientLevel)world).getLoadedShips().getIntersecting((AABBdc)entityBoundingBoxExtended)) {
            Iterable shipBlockCollisionStream;
            ShipTransform shipTransform = shipObject.getTransform();
            ConvexPolygonc entityPolyInShipCoordinates = collider.createPolygonFromAABB((AABBdc)VectorConversionsMCKt.toJOML((AABB)entityBoxWithMovement), shipTransform.getWorldToShip(), null);
            AABBd entityBoundingBoxInShipCoordinates = entityPolyInShipCoordinates.getEnclosingAABB(new AABBd());
            if (BugFixUtil.INSTANCE.isCollisionBoxToBig(VectorConversionsMCKt.toMinecraft((AABBdc)entityBoundingBoxInShipCoordinates)) || !(shipBlockCollisionStream = world.m_186434_(entity, VectorConversionsMCKt.toMinecraft((AABBdc)entityBoundingBoxInShipCoordinates))).iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityMovColShipOnly(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, ClientLevel world) {
        double inflation = entity instanceof Player ? 0.5 : 0.1;
        return VSClientUtils.isEntityMovColShipOnly(entity, movement, entityBoundingBox, world, inflation);
    }

    @Nullable
    public static Vec3 entityMovColShipOnly(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, ClientLevel world, double inflation, double stepHeight) {
        if (entity != null) {
            stepHeight = entity.m_274421_();
        }
        double yMovement = movement.m_7098_() + Math.max(stepHeight - inflation, 0.0);
        List<ConvexPolygonc> collidingShipPolygons = ((InvokerEntityShipCollisionUtils)EntityShipCollisionUtils.INSTANCE).invoker_getShipPolygonsCollidingWithEntity(entity, new Vec3(movement.m_7096_(), yMovement, movement.m_7094_()), entityBoundingBox.m_82400_(inflation), (Level)world);
        if (collidingShipPolygons.isEmpty()) {
            return null;
        }
        Pair pair = collider.adjustEntityMovementForPolygonCollisions((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)movement), (AABBdc)VectorConversionsMCKt.toJOML((AABB)entityBoundingBox), stepHeight, collidingShipPolygons);
        Vector3dc newMovement = (Vector3dc)pair.getFirst();
        Long shipCollidingWith = (Long)pair.getSecond();
        if (shipCollidingWith == null) {
            return null;
        }
        if (entity != null) {
            ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
            return VectorConversionsMCKt.toMinecraft((Vector3dc)newMovement);
        }
        ClientShip ship = (ClientShip)VSGameUtilsKt.getShipObjectWorld((ClientLevel)world).getLoadedShips().getById(shipCollidingWith.longValue());
        if (ship == null) {
            return null;
        }
        Vector3dc velocity = ship.getVelocity();
        return new Vec3(0.05 * velocity.x() + newMovement.x(), 0.05 * velocity.y() + newMovement.y(), 0.05 * velocity.z() + newMovement.z());
    }

    @Nullable
    public static Vec3 entityMovColShipOnly(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, ClientLevel world) {
        double inflation = entity instanceof Player ? 0.5 : 0.1;
        return VSClientUtils.entityMovColShipOnly(entity, movement, entityBoundingBox, world, inflation, 0.0);
    }

    public static Vec3 entityMovColShipOnly(Vec3 movement, AABB entityBoundingBox, ClientLevel world, double inflation, double stepHeight) {
        return VSClientUtils.entityMovColShipOnly(null, movement, entityBoundingBox, world, inflation, stepHeight);
    }

    public static ShipHitResult clipShip(ClientLevel level, ClipContext ctx, boolean shouldTransformHitPos) {
        ClientShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld((ClientLevel)level);
        ShipHitResult closestHit = null;
        Vec3 closestHitPos = null;
        double closestHitDist = Double.MAX_VALUE;
        AABBd clipAABB = new AABBd((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)ctx.m_45702_()), (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)ctx.m_45693_())).correctBounds();
        for (ClientShip ship : shipObjectWorld.getLoadedShips().getIntersecting((AABBdc)clipAABB)) {
            Vec3 shipEnd;
            Vec3 shipStart;
            BlockHitResult shipHit;
            Matrix4dc worldToShip = ship.getWorldToShip();
            Matrix4dc shipToWorld = ship.getShipToWorld();
            Vector3d worldPos = shipToWorld.transformPosition(VectorConversionsMCKt.toJOML((Vec3)(shipHit = InvokerRaycastUtils.invoker_clip((Level)level, ctx, shipStart = VectorConversionsMCKt.toMinecraft((Vector3dc)worldToShip.transformPosition(VectorConversionsMCKt.toJOML((Vec3)ctx.m_45702_()))), shipEnd = VectorConversionsMCKt.toMinecraft((Vector3dc)worldToShip.transformPosition(VectorConversionsMCKt.toJOML((Vec3)ctx.m_45693_()))))).m_82450_()));
            Vec3 shipHitPos = VectorConversionsMCKt.toMinecraft((Vector3dc)worldPos);
            double shipHitDist = shipHitPos.m_82557_(ctx.m_45702_());
            if (!(shipHitDist < closestHitDist) || shipHit.m_6662_() == HitResult.Type.MISS) continue;
            Vector3d newPosInShipLocal = worldPos.sub(ship.getTransform().getPositionInWorld());
            Vector3d shipVelocity = new Vector3d(ship.getVelocity()).add((Vector3dc)new Vector3d(ship.getOmega()).cross((Vector3dc)newPosInShipLocal)).mul(0.05);
            closestHit = ShipHitResult.of(shipHit, worldToShip, shipToWorld, new Vec3(shipVelocity.x(), shipVelocity.y(), shipVelocity.z()));
            closestHitPos = shipHitPos;
            closestHitDist = shipHitDist;
        }
        if (shouldTransformHitPos && closestHit != null) {
            closestHit.f_82445_ = closestHitPos;
        }
        return closestHit;
    }

    public static boolean isUnderHeightMapIncludeShips(ClientLevel level, double x, double y, double z, int size) {
        if ((double)level.m_6924_(Heightmap.Types.MOTION_BLOCKING, Mth.m_14107_((double)x), Mth.m_14107_((double)z)) >= y) {
            return true;
        }
        return VSClientUtils.isUnderShipHeightMap(level, x, y, z, size);
    }

    public static boolean isUnderShipHeightMap(ClientLevel level, double x, double y, double z, double size) {
        ClientShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld((ClientLevel)level);
        for (ClientShip nearbyShip : shipObjectWorld.getLoadedShips().getIntersecting((AABBdc)new AABBd(x - 1.0, y - 1.0, z - 1.0, x + 1.0, Math.max(y + 16.0, (double)level.m_151558_()), z + 1.0))) {
            Vector3d posInShip = nearbyShip.getWorldToShip().transformPosition(new Vector3d(x, y, z));
            if (!((double)level.m_6924_(Heightmap.Types.MOTION_BLOCKING, Mth.m_14107_((double)posInShip.x), Mth.m_14107_((double)posInShip.z)) >= posInShip.y - size)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnderShipHeightMap(ClientLevel level, Vec3 pos, int size) {
        return VSClientUtils.isUnderShipHeightMap(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, size);
    }

    public static boolean isUnderShipHeightMap(ClientLevel level, Vec3 pos, Matrix4dc worldToShip) {
        Vector3d posInShip = worldToShip.transformPosition(VectorConversionsMCKt.toJOML((Vec3)pos));
        return (double)level.m_6924_(Heightmap.Types.MOTION_BLOCKING, Mth.m_14107_((double)posInShip.x), Mth.m_14107_((double)posInShip.z)) >= posInShip.y;
    }

    public static boolean isOutOfSight(ClientLevel level, double x1, double y1, double z1) {
        double inWorldX1 = x1;
        double inWorldZ1 = z1;
        Ship ship1 = VSGameUtilsKt.getShipManagingPos((Level)level, (double)x1, (double)y1, (double)z1);
        if (ship1 != null) {
            Matrix4dc m = ship1.getShipToWorld();
            inWorldX1 = m.m00() * x1 + m.m10() * y1 + m.m20() * z1 + m.m30();
            inWorldZ1 = m.m02() * x1 + m.m12() * y1 + m.m22() * z1 + m.m32();
        }
        Minecraft mc = Minecraft.m_91087_();
        int renderDistance = mc.f_91066_.m_193772_() << 4;
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 pos = camera.m_90583_();
        return Math.abs(pos.f_82479_ - inWorldX1) > (double)renderDistance || Math.abs(pos.f_82481_ - inWorldZ1) > (double)renderDistance;
    }
}

