/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncTicker;
import forge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FakeBufferBuilder;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.FakeTesselator;
import forge.fun.qu_an.minecraft.asyncparticles.client.util.TryAndStoreFakeBufferBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.fantastic.ParticleRenderingPhase;
import net.irisshaders.iris.fantastic.PhasedParticleEngine;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.properties.ParticleRenderingSettings;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.MobAppearanceParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AsyncRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static boolean renderAsync = false;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    public static Frustum frustum;
    private static Consumer<String> debugConsumer;
    private static CompletableFuture<Void> asyncTask;
    private static boolean mixedParticleRenderingSetting;
    private static int asyncTasksSize;
    private static final ExceptionTracker<Class<? extends Particle>> EXCEPTION_TRACKER;
    private static final Map<ParticleRenderType, Pair<VertexFormat.Mode, VertexFormat>> FORMATS;
    public static final Pair<VertexFormat.Mode, VertexFormat> EMPTY_FORMAT;
    private static final Map<ParticleRenderType, BufferBuilder> BUFFER_BUILDERS;
    private static final Map<ParticleRenderType, Set<Particle>> SYNC_PARTICLES;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static void start(float f, Camera camera, boolean isRenderAsync) {
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        if (!isRenderAsync) {
            AsyncRenderer.captureParticleRenderingSetting();
            AsyncRenderer.tryDebug();
            return;
        }
        profiler.m_6182_("async_particles");
        AsyncRenderer.tryDebug();
        AsyncRenderer.clearSync();
        AsyncRenderer.captureParticleRenderingSetting();
        profiler.m_6180_("render_async");
        ParticleEngine particleEngine = mc.f_91061_;
        TextureManager textureManager = particleEngine.f_107291_;
        ObjectArrayList asyncTasks = new ObjectArrayList(asyncTasksSize);
        for (ParticleRenderType particleRenderType : ModListHelper.IS_FORGE ? particleEngine.f_107289_.keySet() : ParticleEngine.f_107288_) {
            BufferBuilder bufferBuilder;
            Queue queue;
            if (particleRenderType == ParticleRenderType.f_107434_ || (queue = (Queue)particleEngine.f_107289_.get(particleRenderType)) == null || queue.isEmpty() || (bufferBuilder = AsyncRenderer.beginBufferBuilder(particleRenderType, textureManager)) == FakeBufferBuilder.INSTANCE) continue;
            asyncTasks.add((Object)CompletableFuture.runAsync(() -> AsyncRenderer.renderParticles(f, camera, queue, particleRenderType, bufferBuilder), EXECUTOR).exceptionally(AsyncRenderer::renderAsyncExceptionally));
        }
        int size = asyncTasksSize = asyncTasks.size();
        asyncTask = CompletableFuture.allOf((CompletableFuture[])asyncTasks.toArray((Object[])new CompletableFuture[size]));
        profiler.m_7238_();
    }

    private static void renderParticles(float f, Camera camera, Queue<Particle> particles, ParticleRenderType particleRenderType, BufferBuilder bufferBuilder) {
        Frustum frustum = AsyncRenderer.frustum;
        boolean enableCull = ConfigHelper.isCullParticles();
        float f2 = f + 1.0f;
        for (Particle particle : particles) {
            if (!particle.m_107276_() || enableCull && ((ParticleAddon)particle).shouldCull() && !frustum.m_113029_(particle.m_107277_())) continue;
            if (((ParticleAddon)particle).asyncparticles$isRenderSync()) {
                AsyncRenderer.recordSync(particleRenderType, particle);
                continue;
            }
            float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
            try {
                particle.m_5744_((VertexConsumer)bufferBuilder, camera, f3);
            }
            catch (Throwable t) {
                boolean tolerable = AsyncTicker.isTolerable(t);
                if (tolerable && !EXCEPTION_TRACKER.addException(particle.getClass(), t)) continue;
                ((ParticleAddon)particle).asyncparticles$setRenderSync();
                if (!AsyncRenderer.shouldSync(particle.getClass())) {
                    if (!tolerable) {
                        LOGGER.warn("Exception while rendering particle {}, marking as sync", (Object)particle, (Object)t);
                    } else {
                        LOGGER.warn("Exception {} thrown while rendering particle {} exceeds the threshold, please contact the author: {}", new Object[]{t.getClass().getSimpleName(), particle, "https://github.com/Harveykang/AsyncParticles/issues", t});
                    }
                    AsyncRenderer.markAsSync(particle.getClass());
                }
                AsyncRenderer.recordSync(particleRenderType, particle);
            }
        }
    }

    private static Void renderAsyncExceptionally(Throwable e) {
        LOGGER.error("Error rendering particle", e);
        Minecraft mc1 = Minecraft.m_91087_();
        if (mc1.f_91073_ != null && mc1.f_91074_ != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        return null;
    }

    public static void join(PoseStack poseStack, float f, Camera camera, LightTexture lightTexture) {
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6182_("async_particles");
        LevelRenderer levelRenderer = mc.f_91060_;
        if (levelRenderer.f_109418_ != null) {
            RenderTarget particlesTarget = levelRenderer.m_109830_();
            particlesTarget.m_83954_(Minecraft.f_91002_);
            particlesTarget.m_83945_(mc.m_91385_());
            RenderStateShard.f_110126_.m_110185_();
        }
        MultiBufferSource.BufferSource bufferSource = mc.f_91060_.f_109464_.m_110104_();
        ParticleEngine particleEngine = mc.f_91061_;
        if (ModListHelper.IRIS_LIKE_LOADED) {
            ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.EVERYTHING);
        }
        renderAsync = ConfigHelper.isRenderAsync();
        particleEngine.m_107336_(poseStack, bufferSource, lightTexture, camera, f);
        renderAsync = false;
        if (levelRenderer.f_109418_ != null) {
            RenderStateShard.f_110126_.m_110188_();
        }
    }

    public static void irisOpaque(PoseStack poseStack, float f, Camera camera, LightTexture lightTexture) {
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6182_("async_particles");
        LevelRenderer levelRenderer = mc.f_91060_;
        MultiBufferSource.BufferSource bufferSource = levelRenderer.f_109464_.m_110104_();
        ParticleEngine particleEngine = mc.f_91061_;
        ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.OPAQUE);
        renderAsync = ConfigHelper.isRenderAsync();
        particleEngine.m_107336_(poseStack, bufferSource, lightTexture, camera, f);
        renderAsync = false;
    }

    public static void irisTranslucent(PoseStack poseStack, float f, Camera camera, LightTexture lightTexture) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91307_().m_6182_("async_particles");
        LevelRenderer levelRenderer = mc.f_91060_;
        MultiBufferSource.BufferSource bufferSource = levelRenderer.f_109464_.m_110104_();
        if (levelRenderer.f_109418_ != null) {
            RenderTarget particlesTarget = levelRenderer.m_109830_();
            particlesTarget.m_83954_(Minecraft.f_91002_);
            particlesTarget.m_83945_(mc.m_91385_());
            RenderStateShard.f_110126_.m_110185_();
        }
        ParticleEngine particleEngine = mc.f_91061_;
        ((PhasedParticleEngine)particleEngine).setParticleRenderingPhase(ParticleRenderingPhase.TRANSLUCENT);
        renderAsync = ConfigHelper.isRenderAsync();
        particleEngine.m_107336_(poseStack, bufferSource, lightTexture, camera, f);
        renderAsync = false;
        if (levelRenderer.f_109418_ != null) {
            RenderStateShard.f_110126_.m_110188_();
        }
    }

    public static void irisSync(PoseStack poseStack, float f, Camera camera, LightTexture lightTexture) {
        PoseStack poseStack2 = null;
        Minecraft mc = Minecraft.m_91087_();
        ParticleEngine particleEngine = mc.f_91061_;
        Frustum frustum = AsyncRenderer.frustum;
        boolean enableCull = ConfigHelper.isCullParticles();
        float f2 = f + 1.0f;
        for (Map.Entry entry : particleEngine.f_107289_.entrySet()) {
            Queue queue;
            ParticleRenderType particleRenderType = (ParticleRenderType)entry.getKey();
            if (particleRenderType == ParticleRenderType.f_107434_ || (queue = (Queue)entry.getValue()).isEmpty() || FORMATS.get(particleRenderType) != EMPTY_FORMAT) continue;
            if (poseStack2 == null) {
                lightTexture.m_109896_();
                RenderSystem.enableDepthTest();
                if (ModListHelper.IS_FORGE) {
                    RenderSystem.activeTexture((int)33986);
                    RenderSystem.activeTexture((int)33984);
                }
                poseStack2 = RenderSystem.getModelViewStack();
                poseStack2.m_85836_();
                poseStack2.m_252931_(poseStack.m_85850_().m_252922_());
                RenderSystem.applyModelViewMatrix();
            }
            RenderSystem.setShader(GameRenderer::m_172829_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            boolean began = false;
            for (Particle particle : queue) {
                if (!particle.m_107276_() || enableCull && ((ParticleAddon)particle).shouldCull() && !frustum.m_113029_(particle.m_107277_())) continue;
                if (!began) {
                    particleRenderType.m_6505_(bufferBuilder, particleEngine.f_107291_);
                    began = true;
                }
                float f3 = ((ParticleAddon)particle).asyncparticles$isTicked() ? f : f2;
                try {
                    particle.m_5744_((VertexConsumer)bufferBuilder, camera, f3);
                }
                catch (Throwable t) {
                    throw AsyncRenderer.constructCrashReport(particle, particleRenderType, t);
                }
            }
            if (!began) continue;
            particleRenderType.m_6294_(tesselator);
        }
        if (poseStack2 != null) {
            poseStack2.m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            lightTexture.m_109891_();
        }
    }

    public static boolean isRenderAsync() {
        return renderAsync;
    }

    private static void waitForAsyncTasks() {
        if (asyncTask != null) {
            asyncTask.join();
            asyncTask = null;
        }
    }

    public static void tryWaitForAsyncTasks() {
        AsyncRenderer.waitForAsyncTasks();
    }

    public static ReportedException constructCrashReport(Particle particle, ParticleRenderType particleRenderType, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.m_127521_((Throwable)t, (String)"Rendering Particle");
        CrashReportCategory crashReportCategory = crashReport.m_127514_("Particle being rendered");
        crashReportCategory.m_128165_("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.m_128165_("Particle Type", () -> ((ParticleRenderType)particleRenderType).toString());
        return new ReportedException(crashReport);
    }

    private static void captureParticleRenderingSetting() {
        if (ModListHelper.IRIS_LIKE_LOADED) {
            mixedParticleRenderingSetting = IrisApi.getInstance().isShaderPackInUse() && AsyncRenderer.getParticleRenderingSettings0() == ParticleRenderingSettings.MIXED;
        }
    }

    public static boolean isMixedParticleRendering() {
        return mixedParticleRenderingSetting;
    }

    private static ParticleRenderingSettings getParticleRenderingSettings0() {
        if (!IrisApi.getInstance().isShaderPackInUse()) {
            return null;
        }
        return Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getParticleRenderingSettings).orElse(ParticleRenderingSettings.MIXED);
    }

    public static BufferBuilder beginBufferBuilder(ParticleRenderType particleRenderType, TextureManager textureManager) {
        Pair<VertexFormat.Mode, VertexFormat> pair = AsyncRenderer.getVertexFormatPair(particleRenderType, textureManager);
        if (pair == EMPTY_FORMAT) {
            return FakeBufferBuilder.INSTANCE;
        }
        BufferBuilder builder = BUFFER_BUILDERS.computeIfAbsent(particleRenderType, k -> new BufferBuilder(256));
        if (builder.m_85732_()) {
            return builder;
        }
        builder.m_166779_((VertexFormat.Mode)pair.first(), (VertexFormat)pair.second());
        return builder;
    }

    @NotNull
    public static Pair<VertexFormat.Mode, VertexFormat> getVertexFormatPair(ParticleRenderType particleRenderType, TextureManager textureManager) {
        return FORMATS.computeIfAbsent(particleRenderType, k -> AsyncRenderer.computeVertexFormatPair(k, textureManager));
    }

    @NotNull
    private static Pair<VertexFormat.Mode, VertexFormat> computeVertexFormatPair(ParticleRenderType k, TextureManager textureManager) {
        TryAndStoreFakeBufferBuilder fakeBufferBuilder = new TryAndStoreFakeBufferBuilder();
        k.m_6505_((BufferBuilder)fakeBufferBuilder, textureManager);
        Exception exception = null;
        try {
            k.m_6294_((Tesselator)FakeTesselator.INSTANCE);
        }
        catch (Exception e) {
            exception = e;
            LOGGER.error("Exception try&store-ing vertex format/mode for particle render type: {}", (Object)k, (Object)e);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.defaultBlendFunc();
        }
        VertexFormat.Mode mode = fakeBufferBuilder.getMode();
        VertexFormat format = fakeBufferBuilder.getFormat();
        if (mode != null && format != null) {
            return Pair.of((Object)mode, (Object)format);
        }
        if (exception != null) {
            throw ExceptionUtil.toThrowDirectly(exception);
        }
        return EMPTY_FORMAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<? extends Particle> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(ParticleRenderType particleRenderType, Particle particle) {
        Set particles;
        Set set = particles = SYNC_PARTICLES.computeIfAbsent(particleRenderType, k -> Collections.newSetFromMap(new IdentityHashMap()));
        synchronized (set) {
            particles.add(particle);
        }
    }

    public static Set<Particle> getSync(ParticleRenderType particleRenderType) {
        Set<Particle> set = SYNC_PARTICLES.get(particleRenderType);
        return set == null ? Collections.emptySet() : set;
    }

    private static void clearSync() {
        SYNC_PARTICLES.clear();
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    static void tryDebug() {
        if (debugConsumer != null) {
            debugConsumer.accept("[Debug AsyncRenderer]\nasync queue size: %d,\nbuffer capacity: %s,\nrender order: %s,\nsync particle count: %d,\nsync particle types: %s,\nsync particle render types: %s,\niris particle state: %s".formatted(asyncTasksSize, BUFFER_BUILDERS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() instanceof FakeBufferBuilder ? 0 : ((BufferBuilder)e.getValue()).f_85648_.capacity())), ModListHelper.IS_FORGE ? Minecraft.m_91087_().f_91061_.f_107289_.keySet() : ParticleEngine.f_107288_, SYNC_PARTICLES.values().stream().mapToInt(Set::size).sum(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList(), FORMATS.entrySet().stream().filter(e -> e.getValue() == EMPTY_FORMAT).map(Map.Entry::getKey).toList(), ModListHelper.IRIS_LIKE_LOADED && IrisApi.getInstance().isShaderPackInUse() ? AsyncRenderer.getParticleRenderingSettings0().name() : "disabled"));
            debugConsumer = null;
        }
    }

    public static void reset() {
        AsyncRenderer.waitForAsyncTasks();
        FORMATS.clear();
        AsyncRenderer.clearSync();
    }

    static {
        SYNC_PARTICLE_TYPES.add(ItemPickupParticle.class);
        SYNC_PARTICLE_TYPES.add(MobAppearanceParticle.class);
        if (ModListHelper.DUMMMMMMY_LOADED) {
            AsyncRenderer.addSyncByClassName("net.mehvahdjukaar.dummmmmmy.client.DamageNumberParticle");
        }
        if (ModListHelper.FABRIC_EFFECTIVE_LOADED) {
            AsyncRenderer.addSyncByClassName("org.ladysnake.effective.core.particle.SplashParticle");
        }
        if (ModListHelper.FORGE_EFFECTICULARITY_LOADED) {
            AsyncRenderer.addSyncByClassName("concerrox.effective.particle.SplashParticle");
        }
        if (ModListHelper.TOMBSTONE_LOADED) {
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleCasting");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGhost");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleGraveSoul");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMagicCircle");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleMarker");
            AsyncRenderer.addSyncByClassName("ovh.corail.tombstone.particle.ParticleRounding");
        }
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.m_14045_((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::m_137495_, true);
        mixedParticleRenderingSetting = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getRenderFailurePerSecondThreshold);
        FORMATS = new ConcurrentHashMap<ParticleRenderType, Pair<VertexFormat.Mode, VertexFormat>>();
        EMPTY_FORMAT = Pair.of(null, null);
        BUFFER_BUILDERS = new IdentityHashMap<ParticleRenderType, BufferBuilder>();
        SYNC_PARTICLES = Collections.synchronizedMap(new IdentityHashMap());
    }
}

