/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.curio;

import com.tetra_loopback.effects.gui.ModEffectStats;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="tetra_loopback")
public class AttributeCurioEffect {
    private static final Map<UUID, Map<Attribute, AttributeModifier>> playerModifiers = new HashMap<UUID, Map<Attribute, AttributeModifier>>();
    private static final Map<ItemEffect, Attribute> effectToAttribute = Map.of(ModEffectStats.attackDamageEffect, Attributes.f_22281_, ModEffectStats.armorEffect, Attributes.f_22284_, ModEffectStats.armorToughnessEffect, Attributes.f_22285_, ModEffectStats.movementSpeedEffect, Attributes.f_22279_);

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        UUID playerId = player.m_20148_();
        AttributeCurioEffect.clearOldModifiers(player);
        HashMap<Attribute, Integer> totalLevels = new HashMap<Attribute, Integer>();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.findCurios(itemStack -> itemStack.m_41720_() instanceof ModularItem).forEach(slotResult -> {
            ItemStack stack = slotResult.stack();
            ModularItem item = (ModularItem)stack.m_41720_();
            effectToAttribute.forEach((effect, attribute) -> {
                int level = item.getEffectLevel(stack, effect);
                if (level > 0) {
                    totalLevels.merge((Attribute)attribute, level, Integer::sum);
                }
            });
        }));
        AttributeCurioEffect.applyModifiers(player, totalLevels);
    }

    private static void clearOldModifiers(Player player) {
        Map modifiers = playerModifiers.getOrDefault(player.m_20148_(), new HashMap());
        modifiers.forEach((attribute, modifier) -> {
            if (player.m_21051_(attribute) != null) {
                player.m_21051_(attribute).m_22130_(modifier);
            }
        });
        playerModifiers.remove(player.m_20148_());
    }

    private static void applyModifiers(Player player, Map<Attribute, Integer> totalLevels) {
        HashMap applied = new HashMap();
        totalLevels.forEach((attribute, level) -> {
            double value = AttributeCurioEffect.getValueByAttribute(attribute, level);
            AttributeModifier modifier = new AttributeModifier(UUID.nameUUIDFromBytes(attribute.m_22087_().getBytes()), "tetra_loopback_attribute", value, AttributeCurioEffect.getOperation(attribute));
            if (player.m_21051_(attribute) != null) {
                player.m_21051_(attribute).m_22118_(modifier);
                applied.put(attribute, modifier);
            }
        });
        playerModifiers.put(player.m_20148_(), applied);
    }

    private static double getValueByAttribute(Attribute attribute, int level) {
        if (attribute == Attributes.f_22279_) {
            return 0.01 * (double)level;
        }
        return level;
    }

    private static AttributeModifier.Operation getOperation(Attribute attribute) {
        return attribute == Attributes.f_22279_ ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION;
    }
}

