/*
 * Decompiled with CFR 0.152.
 */
package com.tetra_loopback.effects.gui.client;

import com.tetra_loopback.effects.gui.ModEffectStats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.ILabelGetter;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

@OnlyIn(value=Dist.CLIENT)
public class ClientGuiRegistry {
    public static void registerAllBars() {
        ClientGuiRegistry.registerThunderingBar();
        ClientGuiRegistry.registerGuardianBar();
        ClientGuiRegistry.registerAttributeBars();
        ClientGuiRegistry.registerAttackSpeedBar();
        ClientGuiRegistry.registerMovementSpeedBar();
    }

    private static void registerThunderingBar() {
        StatGetterEffectLevel thunderingGetter = new StatGetterEffectLevel(ModEffectStats.thunderingEffect, 1.0);
        TooltipGetterInteger thunderingTooltip = new TooltipGetterInteger("tetra_loopback.effect.thundering.tooltip", (IStatGetter)thunderingGetter);
        GuiStatBar thunderingBar = new GuiStatBar(0, 0, 59, "tetra_loopback.effect.thundering.name", 0.0, 10.0, false, false, false, (IStatGetter)thunderingGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)thunderingTooltip);
        WorkbenchStatsGui.addBar((GuiStatBase)thunderingBar);
        HoloStatsGui.addBar((GuiStatBase)thunderingBar);
    }

    private static void registerGuardianBar() {
        StatGetterEffectLevel guardianGetter = new StatGetterEffectLevel(ModEffectStats.guardianEffect, 1.0);
        GuiStatBar guardianBar = new GuiStatBar(0, 0, 59, "tetra_loopback.effect.guardian.name", 0.0, 10.0, false, false, false, (IStatGetter)guardianGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterInteger("tetra_loopback.effect.guardian.tooltip", (IStatGetter)guardianGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)guardianBar);
        HoloStatsGui.addBar((GuiStatBase)guardianBar);
    }

    private static void registerAttributeBars() {
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.armorEffect, "tetra_loopback.effect.armor.name", "tetra_loopback.effect.armor.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.armorEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.armorToughnessEffect, "tetra_loopback.effect.armor_toughness.name", "tetra_loopback.effect.armor_toughness.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.armorToughnessEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.attackDamageEffect, "tetra_loopback.effect.attack_damage.name", "tetra_loopback.effect.attack_damage.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.attackDamageEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.attackKnockbackEffect, "tetra_loopback.effect.attack_knockback.name", "tetra_loopback.effect.attack_knockback.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.attackKnockbackEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.flyingSpeedEffect, "tetra_loopback.effect.flying_speed.name", "tetra_loopback.effect.flying_speed.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.flyingSpeedEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.followRangeEffect, "tetra_loopback.effect.follow_range.name", "tetra_loopback.effect.follow_range.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.followRangeEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.knockbackResistanceEffect, "tetra_loopback.effect.knockback_resistance.name", "tetra_loopback.effect.knockback_resistance.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.knockbackResistanceEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.luckEffect, "tetra_loopback.effect.luck.name", "tetra_loopback.effect.luck.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.luckEffect, 1.0));
        ClientGuiRegistry.registerAttributeBar(ModEffectStats.maxHealthEffect, "tetra_loopback.effect.max_health.name", "tetra_loopback.effect.max_health.tooltip", (IStatGetter)new StatGetterEffectLevel(ModEffectStats.maxHealthEffect, 1.0));
    }

    private static void registerAttackSpeedBar() {
        StatGetterEffectLevel attackSpeedGetter = new StatGetterEffectLevel(ModEffectStats.attackSpeedEffect, 1.0);
        GuiStatBar attackSpeedBar = new GuiStatBar(0, 0, 59, "tetra_loopback.effect.attack_speed.name", -10.0, 10.0, false, false, false, (IStatGetter)attackSpeedGetter, new ILabelGetter(){

            public String getLabel(double value, double diffValue, boolean flipped) {
                return String.format("%+d", (int)value);
            }

            public String getLabelMerged(double value, double diffValue) {
                return "";
            }
        }, (ITooltipGetter)new TooltipGetterInteger("tetra_loopback.effect.attack_speed.tooltip", (IStatGetter)attackSpeedGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)attackSpeedBar);
        HoloStatsGui.addBar((GuiStatBase)attackSpeedBar);
    }

    private static void registerMovementSpeedBar() {
        StatGetterEffectLevel movementSpeedGetter = new StatGetterEffectLevel(ModEffectStats.movementSpeedEffect, 1.0);
        GuiStatBar movementSpeedBar = new GuiStatBar(0, 0, 59, "tetra_loopback.effect.movement_speed.name", -10.0, 10.0, false, false, false, (IStatGetter)movementSpeedGetter, new ILabelGetter(){

            public String getLabel(double value, double diffValue, boolean flipped) {
                return String.format("%+d", (int)value);
            }

            public String getLabelMerged(double value, double diffValue) {
                return "";
            }
        }, (ITooltipGetter)new TooltipGetterInteger("tetra_loopback.effect.movement_speed.tooltip", (IStatGetter)movementSpeedGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)movementSpeedBar);
        HoloStatsGui.addBar((GuiStatBase)movementSpeedBar);
    }

    private static void registerAttributeBar(ItemEffect effect, String nameKey, String tooltipKey, IStatGetter getter) {
        GuiStatBar bar = new GuiStatBar(0, 0, 59, nameKey, 0.0, 10.0, false, false, false, getter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterInteger(tooltipKey, getter));
        WorkbenchStatsGui.addBar((GuiStatBase)bar);
        HoloStatsGui.addBar((GuiStatBase)bar);
    }
}

