/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.attributes;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.attributes.AttributeRegistry;

public class ElytraAttributes {
    public static Map<class_1309, class_243> velocityMap = new WeakHashMap<class_1309, class_243>();

    public static void movementUpdate(@NotNull class_1309 livingEntity) {
        if (!livingEntity.method_5787()) {
            return;
        }
        if (velocityMap.containsKey(livingEntity) && livingEntity instanceof class_1657) {
            if (ElytraAttributes.isElytraFlying(livingEntity)) {
                class_243 lastVelocity = ElytraAttributes.from(velocityMap.get(livingEntity));
                class_243 currentVelocity = ElytraAttributes.from(livingEntity.method_18798());
                double glideEfficiency = livingEntity.method_6127().method_26852(AttributeRegistry.ELYTRA_GLIDE_EFFICIENCY) / 100.0;
                double turnEfficiency = livingEntity.method_6127().method_26852(AttributeRegistry.ELYTRA_TURN_EFFICIENCY) / 100.0;
                double lastSpeed = lastVelocity.method_1033();
                double currentSpeed = currentVelocity.method_1033();
                if (Math.abs(Math.max(0.1, lastSpeed) / Math.max(0.1, currentSpeed) - 1.0) > 0.9) {
                    velocityMap.put(livingEntity, livingEntity.method_18798());
                    return;
                }
                double horizontalDotProduct = currentVelocity.method_1029().method_1026(new class_243(0.0, 1.0, 0.0));
                double horizontalRatio = Math.min(1.0, 1.0 + horizontalDotProduct);
                if (horizontalDotProduct > 0.1) {
                    horizontalRatio = 0.0;
                }
                double turnHorizontalRation = Math.min(1.0, (-horizontalDotProduct + 1.0) * 5.0);
                double directionChange = Math.min(1.0, (1.0 - ElytraAttributes.from(lastVelocity).method_1029().method_1026(ElytraAttributes.from(currentVelocity).method_1029())) * 100.0);
                double speedLoss = Math.max(0.0, lastSpeed - currentSpeed);
                double speedRecovery = Math.min(1.0, directionChange * turnEfficiency * turnHorizontalRation + (1.0 - directionChange) * (glideEfficiency *= horizontalRatio));
                double speed = Math.max(1.0E-8, currentSpeed + speedLoss * speedRecovery);
                class_243 vec3d = ElytraAttributes.from(currentVelocity);
                vec3d = ElytraAttributes.from(vec3d.method_1029());
                vec3d = vec3d.method_1021(speed);
                livingEntity.method_18799(vec3d);
                velocityMap.put(livingEntity, livingEntity.method_18798());
            } else {
                velocityMap.remove(livingEntity);
            }
        } else if (ElytraAttributes.isElytraFlying(livingEntity)) {
            velocityMap.put(livingEntity, livingEntity.method_18798());
        }
    }

    private static class_243 from(class_243 vec3d) {
        if (vec3d == null) {
            return new class_243(0.0, 0.0, 0.0);
        }
        double x = Double.isNaN(vec3d.field_1352) ? 0.0 : vec3d.field_1352;
        double y = Double.isNaN(vec3d.field_1351) ? 0.0 : vec3d.field_1351;
        double z = Double.isNaN(vec3d.field_1350) ? 0.0 : vec3d.field_1350;
        return new class_243(x, y, z);
    }

    static boolean isElytraFlying(class_1309 livingEntity) {
        return livingEntity.method_6128();
    }
}

