/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.util.MiscUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.IStatProvidingBlock;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.craft.stat.StatProvidersMap;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.registries.RegistryInventory;

public class ModularWorkBenchEntity
extends class_2586
implements class_3908,
class_5714 {
    public static final Map<class_5712, CustomGameEventHandler> gameEventHandlers = (Map)MiscUtil.initialize(new ConcurrentHashMap(), map -> {
        map.put(RegistryInventory.statProviderCreatedEvent, (bench, world, event, emitter, emitterPos) -> {
            if (emitter.comp_714() != null) {
                class_2338 pos = new class_2338((int)emitterPos.field_1352, (int)emitterPos.field_1351, (int)emitterPos.field_1350);
                class_2248 block = emitter.comp_714().method_26204();
                if (block instanceof IStatProvidingBlock) {
                    IStatProvidingBlock statProvider = (IStatProvidingBlock)block;
                    bench.persistentStats.computeIfAbsent(pos.toString(), s -> new StatProvidersMap());
                    bench.persistentStats.get(pos.toString()).putAll(statProvider.getProviders(bench, emitter.comp_714(), pos, world));
                }
            }
            return false;
        });
        map.put(RegistryInventory.statProviderRemovedEvent, (bench, world, event, emitter, emitterPos) -> {
            if (emitter.comp_714() != null) {
                class_2338 pos = new class_2338((int)emitterPos.field_1352, (int)emitterPos.field_1351, (int)emitterPos.field_1350);
                bench.persistentStats.remove(pos.toString());
            }
            return false;
        });
    });
    protected final class_3913 propertyDelegate;
    public class_1799 stack;
    public final Map<String, StatProvidersMap> persistentStats = new HashMap<String, StatProvidersMap>();
    protected final Map<CraftingStat, Object> stats = new HashMap<CraftingStat, Object>();
    public int x;
    public int y;
    public int z;
    protected class_5707 blockPositionSource;
    List<WeakReference<CraftingScreenHandler>> handlers = new ArrayList<WeakReference<CraftingScreenHandler>>();

    public ModularWorkBenchEntity(class_2338 pos, class_2680 state) {
        super(RegistryInventory.modularWorkBenchEntityType, pos, state);
        this.stack = class_1799.field_8037;
        this.x = pos.method_10263();
        this.y = pos.method_10264();
        this.z = pos.method_10260();
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> 1;
                    case 1 -> (short)(ModularWorkBenchEntity.this.x >> 16);
                    case 2 -> (short)ModularWorkBenchEntity.this.x;
                    case 3 -> (short)(ModularWorkBenchEntity.this.y >> 16);
                    case 4 -> (short)ModularWorkBenchEntity.this.y;
                    case 5 -> (short)(ModularWorkBenchEntity.this.z >> 16);
                    case 6 -> (short)ModularWorkBenchEntity.this.z;
                    default -> -1;
                };
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 7;
            }
        };
        this.method_5431();
    }

    public void setItem(class_1799 stack) {
        this.stack = stack == null ? class_1799.field_8037 : stack.method_7972();
    }

    public class_1799 getItem() {
        return this.stack;
    }

    public <T> T getStat(CraftingStat<T> stat) {
        return (T)this.stats.get(stat);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        super.method_11007(tag, wrapperLookup);
        class_2487 persisStatsNbt = new class_2487();
        class_2487 statsNbt = new class_2487();
        this.stats.forEach((stat, inst) -> statsNbt.method_10566(RegistryInventory.CRAFTING_STATS_REGISTRY.findKey((CraftingStat)stat).toString(), stat.saveToNbt(inst)));
        if (!this.getItem().method_7960()) {
            try {
                tag.method_10566("item", (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632(Miapi.BOOL_CORRECTED_OPS, (class_7225.class_7874)this.field_11863.method_30349()), (Object)this.getItem()).getOrThrow());
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Could not save Item in Workbench! this indicated the item is broken and will cause more crashese later on!", (Throwable)e);
                try {
                    Miapi.LOGGER.error(this.getItem().toString());
                }
                catch (RuntimeException runtimeException) {}
            }
        } else {
            tag.method_10551("item");
        }
        tag.method_10566("PersistentStats", (class_2520)persisStatsNbt);
        tag.method_10566("Stats", (class_2520)statsNbt);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 wrapperLookup) {
        super.method_11014(tag, wrapperLookup);
        this.persistentStats.clear();
        this.stats.clear();
        if (tag.method_10545("item")) {
            try {
                this.stack = (class_1799)class_1799.method_57360((class_7225.class_7874)wrapperLookup, (class_2520)tag.method_10562("item")).get();
                this.setItem(this.stack);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("sever encoding issue", (Throwable)e);
                this.stack = class_1799.field_8037;
                this.setItem(this.stack);
            }
        } else {
            this.stack = class_1799.field_8037;
            this.setItem(this.stack);
        }
        class_2487 persisStatsNbt = tag.method_10562("PersistentStats");
        persisStatsNbt.method_10541().forEach(key -> {});
        class_2487 statsNbt = tag.method_10562("Stats");
        statsNbt.method_10541().forEach(key -> {
            CraftingStat stat = RegistryInventory.CRAFTING_STATS_REGISTRY.get((String)key);
            if (stat == null) {
                Miapi.LOGGER.warn("Found unknown CraftingStat id '{}'!", key);
                return;
            }
            this.stats.put(stat, stat.createFromNbt(statsNbt.method_10580(key)));
        });
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_39026((class_2586)this, class_2586::method_38242);
    }

    public void saveAndSync() {
        this.method_5431();
        if (this.method_11002()) {
            this.field_11863.method_8413(this.field_11867, this.field_11863.method_8320(this.field_11867), this.method_11010(), 3);
        }
        this.handlers.forEach(weakReference -> {
            CraftingScreenHandler handler = (CraftingScreenHandler)((Object)((Object)weakReference.get()));
            if (handler != null && !class_1799.method_7973((class_1799)handler.inventory.method_5438(0), (class_1799)this.getItem())) {
                handler.inventory.method_5447(0, this.getItem());
            }
        });
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = new class_2487();
        this.method_11007(tag, registries);
        return tag;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"test");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        CraftingScreenHandler handler = new CraftingScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
        this.stats.clear();
        StatProvidersMap providers = new StatProvidersMap();
        ((MiapiEvents.StatUpdateEvent)MiapiEvents.STAT_UPDATE_EVENT.invoker()).update(this, providers, syncId, playerInventory, player, handler);
        this.persistentStats.forEach((key, map) -> providers.putAll((StatProvidersMap)map));
        this.stats.putAll(providers.evaluateAll());
        this.saveAndSync();
        this.handlers.add(new WeakReference<CraftingScreenHandler>(handler));
        return handler;
    }

    public class_5716 method_32946() {
        if (this.blockPositionSource == null) {
            this.blockPositionSource = new class_5707(this.field_11867);
        }
        return this.blockPositionSource;
    }

    public int method_32948() {
        return 16;
    }

    public boolean method_32947(class_3218 world, class_6880<class_5712> registryEntry, class_5712.class_7397 emitter, class_243 emitterPos) {
        CustomGameEventHandler handler = gameEventHandlers.get(registryEntry.comp_349());
        if (handler == null) {
            return false;
        }
        return handler.handle(this, world, (class_5712)registryEntry.comp_349(), emitter, emitterPos);
    }

    public static interface CustomGameEventHandler {
        public boolean handle(ModularWorkBenchEntity var1, class_3218 var2, class_5712 var3, class_5712.class_7397 var4, class_243 var5);
    }
}

