/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blueprint;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.datapack.ReloadHelpers;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.registries.MiapiRegistry;

public class BlueprintManager {
    public static MiapiRegistry<BlueprintComponent> RELOADED_BLUEPRINTS = MiapiRegistry.getInstance(BlueprintComponent.class);
    public static class_2960 ID = Miapi.id("reloaded_blueprint");

    public static void setup() {
        ReloadHelpers.registerReloadHandler("miapi/blueprint", () -> RELOADED_BLUEPRINTS.clear(), (id, blueprint) -> {
            if (blueprint.ingredient.left().isPresent() && ((Boolean)blueprint.ingredient.left().get()).booleanValue()) {
                Miapi.LOGGER.warn("Datapack Blueprints cannot set the Ingredient to True!, either use false ur a Ingredient with count");
            } else {
                RELOADED_BLUEPRINTS.register((class_2960)id, (BlueprintComponent)blueprint);
            }
        }, BlueprintComponent.CODEC, 5.0f);
        ReloadEvents.END.subscribe((isClient, registryAccess) -> Miapi.LOGGER.info("Loaded " + RELOADED_BLUEPRINTS.getFlatMap().size() + " Blueprints"));
    }

    public static CraftOption asCraftOption(CraftingScreenHandler screenHandler, class_2960 location, BlueprintComponent blueprint) {
        return new CraftOption(blueprint.toMerge.getModule(), () -> {
            JsonElement decodeResult = (JsonElement)class_2960.field_25139.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)location).getOrThrow();
            JsonElement booleanElement = (JsonElement)Miapi.FIXED_BOOL_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)blueprint.useMaterialCrafting()).getOrThrow();
            return Map.of(ID, decodeResult, AllowedMaterial.KEY, booleanElement);
        }, -100.0, blueprint.getName());
    }

    @Nullable
    public static BlueprintComponent getBlueprint(Map<class_2960, JsonElement> dataMap, CraftingScreenHandler screenHandler) {
        class_2960 decodeResult;
        JsonElement json = dataMap.get(ID);
        if (json != null && RELOADED_BLUEPRINTS.containsKey(decodeResult = (class_2960)((Pair)class_2960.field_25139.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst())) {
            return RELOADED_BLUEPRINTS.get(decodeResult);
        }
        return null;
    }
}

