/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.redpxnda.nucleus.config.ConfigManager;
import com.redpxnda.nucleus.config.ConfigObject;
import com.redpxnda.nucleus.event.RenderEvents;
import com.redpxnda.nucleus.facet.network.clientbound.FacetSyncPacket;
import com.redpxnda.nucleus.registry.effect.RenderingMobEffect;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchRenderer;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.blueprint.BlueprintManager;
import smartin.miapi.client.GlintShader;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.MiapiConfigScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.ReplaceView;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.client.renderer.SpriteLoader;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.editor.EditorCommands;
import smartin.miapi.editor.LiveDataPackManager;
import smartin.miapi.effects.CryoStatusEffect;
import smartin.miapi.entity.ItemProjectileRenderer;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialCommand;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.TierManager;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.MiapiPermissions;
import smartin.miapi.modules.abilities.key.ClientKeybinding;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class MiapiClient {
    public static MaterialAtlasManager materialAtlasManager;
    public static boolean shaderModLoaded;
    public static boolean VEIL_LOADED;
    public static boolean SODIUM_LOADED;
    public static boolean EMI_LOADED;
    public static boolean JER_LOADED;
    public static final MiapiRegistry<class_304> KEY_BINDINGS;

    private MiapiClient() {
    }

    public static void init() {
        ConfigObject config = ConfigManager.getConfigObject((class_2960)Miapi.id("server"));
        if (config.getInstance() == null) {
            config.load();
        }
        if (Platform.getMod((String)"nucleus").getVersion().equals("1.1.4")) {
            RenderEvents.LIVING_ENTITY_RENDER.register((stage, model, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight) -> {
                if (stage != RenderEvents.EntityRenderStage.PRE) {
                    return EventResult.pass();
                }
                for (Map.Entry entry : entity.method_6088().entrySet()) {
                    boolean result;
                    class_1293 instance = (class_1293)entry.getValue();
                    class_6880 effect = (class_6880)entry.getKey();
                    Object patt0$temp = effect.comp_349();
                    if (!(patt0$temp instanceof RenderingMobEffect)) continue;
                    RenderingMobEffect rendering = (RenderingMobEffect)patt0$temp;
                    if (instance.method_5584() <= 0 && !instance.method_48559() || !(result = rendering.renderPre(instance, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight))) continue;
                    return EventResult.interruptFalse();
                }
                return EventResult.pass();
            });
            RenderEvents.LIVING_ENTITY_RENDER.register((stage, model, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight) -> {
                if (stage != RenderEvents.EntityRenderStage.POST) {
                    return EventResult.pass();
                }
                entity.method_6088().forEach((effect, instance) -> {
                    Object patt0$temp = effect.comp_349();
                    if (patt0$temp instanceof RenderingMobEffect) {
                        RenderingMobEffect rendering = (RenderingMobEffect)patt0$temp;
                        if (instance.method_5584() > 0 || instance.method_48559()) {
                            rendering.renderPost(instance, entity, entityYaw, partialTick, matrixStack, multiBufferSource, packedLight);
                        }
                    }
                });
                return EventResult.pass();
            });
        }
        RegistryInventory.MODULAR_ITEMS.addCallback(MiapiClient::registerAnimations);
        ClientTickEvent.CLIENT_PRE.register(instance -> {
            if (MiapiConfig.getClientConfig().other.animatedMaterials) {
                class_310.method_1551().method_16011().method_15396("miapiMaterialAnimations");
                MaterialSpriteManager.tick();
                class_310.method_1551().method_16011().method_15407();
            }
            ClientKeybinding.clientTick(instance);
        });
        Networking.registerS2CPacket(MaterialCommand.SEND_MATERIAL_CLIENT, buf -> {
            String materialId = buf.method_19772();
            class_310.method_1551().execute(() -> {
                Material material = MaterialProperty.MATERIAL_REGISTRY.get(Miapi.id(materialId));
                if (material != null) {
                    String raw = Miapi.gson.newBuilder().setPrettyPrinting().create().toJson((JsonElement)material.getDebugJson());
                    class_5250 text = class_2561.method_43470((String)raw);
                    class_2558 event = new class_2558(class_2558.class_2559.field_21462, raw);
                    text = (class_2561)text.method_36136(class_2583.field_24360.method_10958(event)).get(0);
                    class_310.method_1551().field_1724.method_43496((class_2561)text);
                }
            });
        });
        Networking.registerS2CPacket(CacheCommands.SEND_MATERIAL_CLIENT, buf -> class_310.method_1551().execute(() -> ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload()));
        ClientReloadShadersEvent.EVENT.register((resourceFactory, shadersSink) -> {
            if (Platform.isForgeLike() && !NetworkAggregator.S2C_RECEIVER.containsKey(FacetSyncPacket.TYPE.comp_2242())) {
                NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_8710.class_9154)FacetSyncPacket.TYPE, (class_9139)FacetSyncPacket.STREAM_CODEC, (packet, context) -> context.queue(() -> packet.handle(context)));
            }
            ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
            if (class_310.method_1551().field_1687 != null) {
                ++ReloadEvents.reloadCounter;
                LinkedHashMap<class_2960, String> cacheDatapack = new LinkedHashMap<class_2960, String>(ReloadEvents.DATA_PACKS);
                ReloadEvents.START.fireEvent(true, class_310.method_1551().field_1687.method_30349());
                ReloadEvents.DataPackLoader.trigger(cacheDatapack);
                ReloadEvents.MAIN.fireEvent(true, class_310.method_1551().field_1687.method_30349());
                ReloadEvents.END.fireEvent(true, class_310.method_1551().field_1687.method_30349());
                --ReloadEvents.reloadCounter;
                ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
            }
        });
        ConfigManager.CONFIG_SCREENS_REGISTRY.register(registerer -> registerer.add("miapi", MiapiConfigScreen::new));
        MaterialRenderControllers.setup();
        MaterialIcons.setup();
        ColorProvider.setup();
        ClientLifecycleEvent.CLIENT_SETUP.register(MiapiClient::clientSetup);
        ClientLifecycleEvent.CLIENT_STARTED.register(MiapiClient::clientStart);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(MiapiClient::clientLevelLoad);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> new Thread(() -> MiapiPermissions.getPerms((class_1657)player)).start());
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> {
            String version;
            ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
            Miapi.clientRegistryAccess = player.method_56673();
            if (JER_LOADED && Miapi.server == null && ((version = Platform.getMod((String)"jeresources").getVersion()).equals("1.4.0.238") || version.equals("1.4.0.246") || version.equals("1.4.0.247"))) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Just Enough Resources 1.20.1-1.4.0.247 Release is broken on servers. Please Remove it."));
                class_2558 event = new class_2558(class_2558.class_2559.field_11749, "https://github.com/way2muchnoise/JustEnoughResources/issues/392");
                class_5250 link = class_2561.method_43470((String)"For more information you can read this");
                player.method_43496((class_2561)link.method_36136(class_2583.field_24360.method_10958(event).method_30938(Boolean.valueOf(true))).get(0));
                player.method_43496((class_2561)class_2561.method_43470((String)"This message was sent by Truly Modular."));
            }
        });
        ClientReloadShadersEvent.EVENT.register((resourceFactory, asd) -> {
            ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
            TierManager.setup();
        });
        RegistryInventory.MODULAR_ITEMS.addCallback(item -> {
            ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damage"), (stack, world, entity, seed) -> stack.method_7963() && stack.method_7919() > 0 ? (float)stack.method_7919() / (float)stack.method_7936() : 0.0f);
            ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damaged"), (stack, world, entity, seed) -> stack.method_7986() ? 1.0f : 0.0f);
            ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("use"), (stack, world, entity, seed) -> entity.method_6115() && stack.equals(entity.method_6030()) ? 1.0f : 0.0f);
            ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("use_ticks"), (stack, world, entity, seed) -> entity.method_6115() && stack.equals(entity.method_6030()) ? (float)entity.method_6048() : 0.0f);
        });
        ReloadEvents.START.subscribe((isClient, registryAccess) -> {
            if (isClient) {
                StatListWidget.onReload();
            }
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            if (isClient) {
                StatListWidget.reloadEnd();
            }
        });
        ReplaceView.optionSuppliers.add(option -> option.getScreenHandler().field_7761.stream().filter(a -> a.method_7677().method_57826(BlueprintComponent.BLUEPRINT_COMPONENT)).map(a -> (BlueprintComponent)a.method_7677().method_57824(BlueprintComponent.BLUEPRINT_COMPONENT)).filter(b -> {
            for (String id : AllowedSlots.getAllowedSlots(b.toMerge)) {
                if (!option.getSlot().allowed.contains(id)) continue;
                return true;
            }
            return false;
        }).map(a -> a.asCraftOption(option.getScreenHandler())).toList());
        ReplaceView.optionSuppliers.add(option -> {
            ArrayList options = new ArrayList();
            BlueprintManager.RELOADED_BLUEPRINTS.getFlatMap().forEach((id, blueprint) -> {
                boolean isAllowed = false;
                for (String slotID : AllowedSlots.getAllowedSlots(blueprint.toMerge)) {
                    if (!option.getSlot().allowed.contains(slotID)) continue;
                    isAllowed = true;
                }
                if (isAllowed) {
                    options.add(BlueprintManager.asCraftOption(option.getScreenHandler(), id, blueprint));
                }
            });
            return options;
        });
        GlintShader.registerShaders();
        if (Platform.getEnv() == EnvType.CLIENT) {
            EditorCommands.registerClient();
        }
        LiveDataPackManager.setup();
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerAnimations(class_1792 item) {
        ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damage"), (stack, world, entity, seed) -> stack.method_7963() && stack.method_7986() ? 0.0f : (float)stack.method_7936() / (float)(stack.method_7936() - stack.method_7919()));
        ModularModelPredicateProvider.registerModelOverride(item, Miapi.id("damaged"), (stack, world, entity, seed) -> stack.method_7986() ? 0.0f : 1.0f);
    }

    public static boolean isSodiumLikeLoaded() {
        return Platform.isModLoaded((String)"sodium") || Platform.isModLoaded((String)"embeddium") || Platform.isModLoaded((String)"magnesium") || Platform.isModLoaded((String)"rubidium");
    }

    public static boolean isSodiumLoaded() {
        return Platform.isModLoaded((String)"sodium");
    }

    public static boolean isHigherVersion(String version, String compareToVersion) {
        String[] versionParts = version.split("\\.");
        String[] compareToVersionParts = compareToVersion.split("\\.");
        for (int i = 0; i < versionParts.length && i < compareToVersionParts.length; ++i) {
            int part2;
            int part1 = Integer.parseInt(versionParts[i]);
            if (part1 > (part2 = Integer.parseInt(compareToVersionParts[i]))) {
                return true;
            }
            if (part1 >= part2) continue;
            return false;
        }
        return versionParts.length > compareToVersionParts.length;
    }

    protected static void clientSetup(class_310 client) {
        SpriteLoader.setup();
    }

    public static void runOnClientEnsured(Runnable runnable) {
        if (RenderSystem.isOnRenderThreadOrInit()) {
            runnable.run();
        } else {
            class_310 mc = class_310.method_1551();
            mc.execute(runnable);
        }
    }

    protected static void clientStart(class_310 client) {
        CryoStatusEffect.setupOnClient();
    }

    protected static void clientLevelLoad(class_638 clientWorld) {
        SpriteLoader.clientStart();
        ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
    }

    public static void registerScreenHandler() {
        MenuRegistry.registerScreenFactory(RegistryInventory.craftingScreenHandler, CraftingScreen::new);
    }

    public static void registerEntityRenderer() {
        EntityRendererRegistry.register(RegistryInventory.itemProjectileType, ItemProjectileRenderer::new);
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRendererRegistry.register(RegistryInventory.modularWorkBenchEntityType, ModularWorkBenchRenderer::new);
    }

    static {
        shaderModLoaded = Platform.isModLoaded((String)"iris") || Platform.isModLoaded((String)"optifine") || Platform.isModLoaded((String)"optifabric") || Platform.isModLoaded((String)"oculus");
        VEIL_LOADED = Platform.isModLoaded((String)"veil");
        SODIUM_LOADED = MiapiClient.isSodiumLoaded();
        EMI_LOADED = Platform.isModLoaded((String)"emi");
        JER_LOADED = Platform.isModLoaded((String)"jeresources");
        KEY_BINDINGS = MiapiRegistry.getInstance(class_304.class);
    }
}

