/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import dev.architectury.event.EventResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_7764;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.AnimatedTexturesManager;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.renderer.MovedVertexConsumer;
import smartin.miapi.client.renderer.RescaledVertexConsumer;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteColorer;
import smartin.miapi.mixin.client.SpriteContentsAccessor;

@Environment(value=EnvType.CLIENT)
public class MaterialSpriteManager {
    static Map<Holder, class_1043> animated_Textures = new HashMap<Holder, class_1043>();
    public static final long CACHE_SIZE = 10000L;
    public static final long CACHE_LIFETIME = 10L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.SECONDS;
    protected static Map<class_2960, class_1043> nativeImageBackedTextureMap = new HashMap<class_2960, class_1043>();
    public static Set<class_1058> animated = new HashSet<class_1058>();
    public static final Map<Integer, List<SpriteSlot>> ATLAS_SPRITE_POOL = new HashMap<Integer, List<SpriteSlot>>();
    public static final Map<Holder, SpriteSlot> FAST_CACHE = new HashMap<Holder, SpriteSlot>();
    public static final List<SpriteSlot> ANIMATED_ATLAS_SPRITES = new ArrayList<SpriteSlot>();
    protected static final Cache<Holder, class_2960> materialSpriteCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(10L, CACHE_LIFETIME_UNIT).removalListener(notification -> {
        if (notification.wasEvicted()) {
            Object patt1$temp;
            Object patt0$temp = notification.getValue();
            if (patt0$temp instanceof class_2960) {
                class_2960 removeId = (class_2960)patt0$temp;
                class_1043 texture = nativeImageBackedTextureMap.get(removeId);
                if (texture != null) {
                    texture.close();
                }
                class_310.method_1551().method_1531().method_4615(removeId);
            }
            if ((patt1$temp = notification.getKey()) instanceof Holder) {
                Holder holder = (Holder)patt1$temp;
                animated_Textures.remove(holder);
                try {
                    holder.colorer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }).build((CacheLoader)new CacheLoader<Holder, class_2960>(){

        @NotNull
        public class_2960 load(@NotNull Holder key) {
            return MaterialSpriteManager.getMaterialSprite(key);
        }
    });

    public static class_2960 getMaterialSprite(Holder holder) {
        class_2960 identifier = (class_2960)materialSpriteCache.getIfPresent((Object)holder);
        if (identifier == null) {
            SpriteColorer.MaterialRecoloredSpriteHolder colorer = holder.colorer().createSpriteManager(holder.sprite().method_45851());
            class_1043 nativeImageBackedTexture = new class_1043(colorer.recolor().method_48462(IntUnaryOperator.identity()));
            class_2960 spriteId = class_310.method_1551().method_1531().method_4617("miapi/dynmaterialsprites", nativeImageBackedTexture);
            if (colorer.requireTick()) {
                animated_Textures.put(holder, nativeImageBackedTexture);
            }
            materialSpriteCache.put((Object)holder, (Object)spriteId);
            return spriteId;
        }
        return identifier;
    }

    public static void clear() {
        materialSpriteCache.invalidateAll();
        ANIMATED_ATLAS_SPRITES.clear();
        FAST_CACHE.forEach((h, s) -> {
            s.used = 0;
        });
        FAST_CACHE.clear();
    }

    public static void tick() {
        if (!ReloadEvents.isInReload()) {
            ArrayList toRemove = new ArrayList();
            animated_Textures.forEach((holder, nativeImageBackedTexture) -> {
                try {
                    holder.colorer.tick(nativeImage -> {
                        Objects.requireNonNull(nativeImageBackedTexture.method_4525()).method_4317(nativeImage);
                        nativeImageBackedTexture.method_4524();
                    }, holder.sprite().method_45851());
                }
                catch (Exception e) {
                    toRemove.add(holder);
                }
            });
            ANIMATED_ATLAS_SPRITES.forEach(slot -> {
                AnimatedTexturesManager.markAnimated(slot.getSprite());
                slot.updateSprite();
            });
            toRemove.forEach(arg_0 -> materialSpriteCache.invalidate(arg_0));
            ArrayList toRemoveFAST = new ArrayList();
            FAST_CACHE.forEach((h, s) -> {
                --s.used;
                if (s.used < 1) {
                    toRemoveFAST.add(h);
                    s.clear();
                    ANIMATED_ATLAS_SPRITES.remove(s);
                }
            });
            toRemoveFAST.forEach(h -> {
                SpriteSlot slot = FAST_CACHE.remove(h);
                ATLAS_SPRITE_POOL.computeIfAbsent(MaterialSpriteManager.resToKey(slot.x, slot.y), s -> new ArrayList()).add(slot);
            });
            for (class_1058 sprite : animated) {
                AnimatedTexturesManager.markAnimated(sprite);
            }
        }
    }

    public static void markTextureAsAnimatedInUse(class_1058 sprite) {
        if (MiapiClient.isSodiumLoaded()) {
            animated.add(sprite);
        }
    }

    public static class_4588 getVertexConsumer(class_4597 vertexConsumers, class_1058 originalSprite, Material material, SpriteColorer materialSpriteColorer) {
        Holder holder = new Holder(originalSprite, material, materialSpriteColorer);
        if (!MiapiConfig.getClientConfig().other.disableFastRender) {
            SpriteSlot spriteSlot = FAST_CACHE.get(holder);
            if (spriteSlot == null && (spriteSlot = MaterialSpriteManager.getFreeAtlasSlot(((SpriteContentsAccessor)originalSprite.method_45851()).getWidth(), ((SpriteContentsAccessor)originalSprite.method_45851()).getHeight())) != null) {
                spriteSlot.used = 4;
                spriteSlot.holder = holder;
                FAST_CACHE.put(holder, spriteSlot);
                if (holder.colorer().doTick()) {
                    ANIMATED_ATLAS_SPRITES.add(spriteSlot);
                    AnimatedTexturesManager.markAnimated(spriteSlot.sprite);
                }
                spriteSlot.updateSprite();
            }
            if (spriteSlot != null && spriteSlot.used < 4) {
                return MaterialSpriteManager.getBlockAtlasVertexConsumer(vertexConsumers, originalSprite, holder, spriteSlot);
            }
        }
        return MaterialSpriteManager.getDynamicTextureVertexConsumer(vertexConsumers, originalSprite, holder);
    }

    @NotNull
    private static class_4588 getBlockAtlasVertexConsumer(class_4597 vertexConsumers, class_1058 originalSprite, Holder holder, SpriteSlot spriteSlot) {
        spriteSlot.used = 3;
        return new MovedVertexConsumer(class_918.method_29711((class_4597)vertexConsumers, (class_1921)class_4696.method_23678((class_1799)class_1799.field_8037, (boolean)false), (boolean)true, (boolean)false), originalSprite, spriteSlot.getSprite());
    }

    @NotNull
    private static RescaledVertexConsumer getDynamicTextureVertexConsumer(class_4597 vertexConsumers, class_1058 originalSprite, Holder holder) {
        class_2960 replaceId = MaterialSpriteManager.getMaterialSprite(holder);
        class_1921 atlasRenderLayer = class_1921.method_23689((class_2960)replaceId);
        class_4588 atlasConsumer = class_918.method_29711((class_4597)vertexConsumers, (class_1921)atlasRenderLayer, (boolean)true, (boolean)false);
        return new RescaledVertexConsumer(atlasConsumer, originalSprite);
    }

    @Nullable
    public static SpriteSlot getFreeAtlasSlot(int width, int height) {
        int key = width << 16 | height;
        List<SpriteSlot> slots = ATLAS_SPRITE_POOL.get(key);
        if (slots == null) {
            return null;
        }
        for (int i = 0; i < slots.size(); ++i) {
            SpriteSlot slot = slots.get(i);
            if (slot.used >= 1) continue;
            slots.remove(slot);
            return slot;
        }
        return null;
    }

    public static int resToKey(int width, int height) {
        return width << 16 | height;
    }

    static {
        MiapiEvents.CLEAR_CACHE.register(() -> {
            MaterialSpriteManager.clear();
            return EventResult.pass();
        });
    }

    public record Holder(class_1058 sprite, Material material, SpriteColorer colorer) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Holder holder = (Holder)o;
            return Objects.equals(this.sprite, holder.sprite) && Objects.equals(this.material, holder.material) && Objects.equals(this.colorer, holder.colorer);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.sprite, this.material, this.colorer);
        }
    }

    public static class SpriteSlot {
        public int used = 0;
        public class_2960 internalID;
        public Consumer<class_1011> update;
        public int x;
        public int y;
        public final class_7764 contents;
        public class_1058 sprite;
        public Holder holder;

        public SpriteSlot(class_2960 id, int x, int y, class_7764 contents, Consumer<class_1011> update) {
            this.contents = contents;
            this.internalID = id;
            this.x = x;
            this.y = y;
            this.update = update;
        }

        public class_1058 getSprite() {
            if (this.sprite == null) {
                this.sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(this.internalID);
            }
            return this.sprite;
        }

        public int width() {
            return this.x;
        }

        public int height() {
            return this.y;
        }

        public void updateSprite() {
            if (this.holder != null) {
                this.update.accept(this.holder.colorer().createSpriteManager(this.holder.sprite().method_45851()).recolor());
            }
        }

        public void clear() {
            class_1011 image = new class_1011(this.x, this.y, false);
            for (int x = 0; x < this.x; ++x) {
                for (int y = 0; y < this.y; ++y) {
                    image.method_4305(x, y, 0);
                }
            }
            this.update.accept(image);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SpriteSlot that = (SpriteSlot)object;
            return Objects.equals(this.internalID, that.internalID);
        }

        public int hashCode() {
            return Objects.hashCode(this.internalID);
        }
    }
}

