/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5253;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.joml.Vector2d;
import smartin.miapi.config.MiapiConfig;

@Environment(value=EnvType.CLIENT)
public abstract class InteractAbleWidget
extends class_339
implements class_4068,
class_364 {
    protected final List<class_364> children = new ArrayList<class_364>();
    protected final List<InteractAbleWidget> hoverElements = new ArrayList<InteractAbleWidget>();
    public boolean debug = false;
    public int randomColor = class_5253.class_5254.method_27764((int)180, (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)), (int)((int)(Math.random() * 255.0)));

    protected InteractAbleWidget(int x, int y, int width, int height, class_2561 title) {
        super(x, y, width, height, title);
    }

    public static void drawSquareBorder(class_332 drawContext, int x, int y, int width, int height, int borderWidth, int color) {
        drawContext.method_51737(x, y, x + width, y + borderWidth, 100, color);
        drawContext.method_51737(x, y + height, x + width, y + height - borderWidth, 100, color);
        drawContext.method_51737(x, y, x + borderWidth, y + height, 100, color);
        drawContext.method_51737(x + width, y, x + width - borderWidth, y + height, 100, color);
    }

    public static void drawTextureWithEdgeAndScale(class_332 context, class_2960 texture, int x, int y, int u, int v, int regionWidth, int regionHeight, int width, int height, int textureWidth, int textureHeight, int borderWidth, float scale) {
        context.method_51448().method_23760().method_23761().scale(1.0f / scale);
        InteractAbleWidget.drawTextureWithEdge(context, texture, (int)((float)x * scale), (int)((float)y * scale), u, v, regionWidth, regionHeight, (int)((float)width * scale), (int)((float)height * scale), textureWidth, textureHeight, borderWidth);
        context.method_51448().method_23760().method_23761().scale(scale);
    }

    public static void drawTextureWithEdge(class_332 drawContext, class_2960 texture, int x, int y, int u, int v, int regionWidth, int regionHeight, int width, int height, int textureWidth, int textureHeight, int borderWidth) {
        drawContext.method_25293(texture, x + borderWidth, y + borderWidth, width - 2 * borderWidth, height - 2 * borderWidth, (float)(u + borderWidth), (float)(v + borderWidth), regionWidth - borderWidth * 2, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.method_25293(texture, x, y, borderWidth, borderWidth, (float)u, (float)v, borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.method_25293(texture, x + width - borderWidth, y, borderWidth, borderWidth, (float)(u + regionWidth - borderWidth), (float)v, borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.method_25293(texture, x, y + height - borderWidth, borderWidth, borderWidth, (float)u, (float)(v + regionHeight - borderWidth), borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.method_25293(texture, x + width - borderWidth, y + height - borderWidth, borderWidth, borderWidth, (float)(u + regionWidth - borderWidth), (float)(v + regionHeight - borderWidth), borderWidth, borderWidth, textureWidth, textureHeight);
        drawContext.method_25293(texture, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, (float)(u + borderWidth), (float)(v + regionHeight - borderWidth), regionWidth - borderWidth * 2, borderWidth, textureWidth, textureHeight);
        drawContext.method_25293(texture, x + width - borderWidth, y + borderWidth, borderWidth, height - 2 * borderWidth, (float)(u + regionWidth - borderWidth), (float)(v + borderWidth), borderWidth, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.method_25293(texture, x, y + borderWidth, borderWidth, height - 2 * borderWidth, (float)u, (float)(v + borderWidth), borderWidth, regionHeight - borderWidth * 2, textureWidth, textureHeight);
        drawContext.method_25293(texture, x + borderWidth, y, width - 2 * borderWidth, borderWidth, (float)(u + borderWidth), (float)v, regionWidth - borderWidth * 2, borderWidth, textureWidth, textureHeight);
    }

    public static void drawTextureWithEdge(class_332 drawContext, class_2960 texture, int x, int y, int width, int height, int textureWidth, int textureHeight, int borderWidth) {
        InteractAbleWidget.drawTextureWithEdge(drawContext, texture, x, y, 0, 0, textureWidth, textureHeight, width, height, textureWidth, textureHeight, borderWidth);
    }

    public List<InteractAbleWidget> getHoverElements() {
        ArrayList<InteractAbleWidget> allHoverElements = new ArrayList<InteractAbleWidget>(this.hoverElements);
        this.children().forEach(currentChildren -> {
            if (currentChildren instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)currentChildren);
                allHoverElements.addAll(widget.getHoverElements());
            }
        });
        return allHoverElements;
    }

    public void addChild(class_364 element) {
        this.children().add(element);
    }

    public void removeChild(class_364 element) {
        this.children().remove(element);
    }

    public List<class_364> children() {
        return this.children;
    }

    public void method_16014(double mouseX, double mouseY) {
        for (class_364 child : this.children()) {
            if (!child.method_25405(mouseX, mouseY)) continue;
            child.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 child : this.children()) {
            if (!child.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public void playClickedSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (class_364 child : this.children()) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (class_364 child : this.children()) {
            if (!child.method_25405(mouseX, mouseY) || !child.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (class_364 child : this.children()) {
            if (!child.method_25401(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 child : this.children()) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        for (class_364 child : this.children()) {
            if (!child.method_16803(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        for (class_364 child : this.children()) {
            if (!child.method_25400(chr, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY);
    }

    public Vector2d getScaledMouseCoords() {
        class_310 client = class_310.method_1551();
        class_312 mouse = client.field_1729;
        double x = mouse.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double y = mouse.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        return new Vector2d(x, y);
    }

    public void method_53533(int height) {
        this.field_22759 = height;
    }

    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if ((this.debug || MiapiConfig.getServerConfig().other.developmentMode) && class_437.method_25443()) {
            InteractAbleWidget.drawSquareBorder(drawContext, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 1, this.randomColor);
        } else {
            InteractAbleWidget.drawSquareBorder(drawContext, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 1, 0);
        }
        ArrayList<class_364> reverse = new ArrayList<class_364>(this.children());
        Collections.reverse(reverse);
        for (class_364 element : reverse) {
            if (!(element instanceof class_4068)) continue;
            class_4068 drawable = (class_4068)element;
            drawable.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.hoverElements.forEach(widget -> widget.method_25394(drawContext, mouseX, mouseY, delta));
        this.children().forEach(element -> {
            if (element instanceof InteractAbleWidget) {
                InteractAbleWidget widget = (InteractAbleWidget)((Object)element);
                widget.renderHover(drawContext, mouseX, mouseY, delta);
            }
        });
    }

    protected void method_47399(class_6382 builder) {
    }
}

