/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3936;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ParentHandledScreen;
import smartin.miapi.client.gui.SimpleScreenHandlerListener;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.MinimizeButton;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.client.gui.crafting.crafter.DetailView;
import smartin.miapi.client.gui.crafting.crafter.ModuleCrafter;
import smartin.miapi.client.gui.crafting.slotdisplay.SlotDisplay;
import smartin.miapi.client.gui.crafting.slotdisplay.SmithDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.material.MaterialStatWidget;
import smartin.miapi.client.gui.crafting.statdisplay.material.StatDisplayWidget;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.registries.RegistryInventory;

@Environment(value=EnvType.CLIENT)
public class CraftingScreen
extends ParentHandledScreen<CraftingScreenHandler>
implements class_3936<CraftingScreenHandler> {
    public static final class_2960 BACKGROUND_TEXTURE = Miapi.id("textures/gui/crafter/background.png");
    private ModuleCrafter moduleCrafter;
    private StatDisplayWidget statDisplay;
    private MaterialStatWidget materialStatWidget;
    private SlotDisplay slotDisplay;
    private SmithDisplay smithDisplay;
    private MinimizeButton minimizer;
    private SlotProperty.ModuleSlot baseSlot;
    @Nullable
    public static SlotProperty.ModuleSlot slot;
    @Nullable
    public static EditOption editOption;
    private TransformableWidget editHolder;
    static int editSpace;
    @Nullable
    public InteractAbleWidget hoverElement = null;
    public class_2487 oldCompound = new class_2487();
    static WeakReference<CraftingScreen> craftingScreenWeakReference;
    public int overwriteMouseY = 0;
    public int overwriteMouseX = 0;
    public class_1799 currentStack = class_1799.field_8037;
    public boolean trueMinState = false;
    public boolean currentMinState = false;
    List<InteractAbleWidget> editOptionIcons = new ArrayList<InteractAbleWidget>();

    public CraftingScreen(CraftingScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, (class_2561)class_2561.method_43473());
        slot = null;
        this.field_2792 = 372;
        this.field_2779 = 199;
        DetailView.scrollPos = 0;
        craftingScreenWeakReference = new WeakReference<CraftingScreen>(this);
    }

    @Nullable
    public static CraftingScreen getInstance() {
        if (craftingScreenWeakReference != null && craftingScreenWeakReference.get() != null) {
            return (CraftingScreen)((Object)craftingScreenWeakReference.get());
        }
        return null;
    }

    public EditOption getEditOption() {
        return editOption;
    }

    public void selectSlot(SlotProperty.ModuleSlot slot) {
        CraftingScreen.slot = slot;
        this.updateEditOptions();
    }

    public void previewStack(class_1799 itemStack) {
        this.slotDisplay.setItem(itemStack);
        this.statDisplay.setCompareTo(itemStack);
        this.smithDisplay.setPreview(itemStack);
    }

    public void selectEditOption(EditOption editOption) {
        CraftingScreen.editOption = editOption;
        this.moduleCrafter.setSelectedSlot(slot);
        this.moduleCrafter.setEditMode(editOption, this.get(editOption));
        PreviewManager.resetCursorStack();
    }

    public void method_25426() {
        slot = null;
        editOption = null;
        ArrayList<String> allowedModules = new ArrayList<String>();
        allowedModules.add("melee");
        class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
        if (class_17032 instanceof CraftingScreenHandler) {
            CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)class_17032;
            craftingScreenHandler.clearSlots();
        }
        this.baseSlot = new SlotProperty.ModuleSlot(allowedModules);
        int centerX = (this.field_22789 - this.field_2792 - 6) / 2;
        int centerY = (this.field_22790 - this.field_2779) / 2;
        this.moduleCrafter = new ModuleCrafter(centerX + 51 - 15, centerY + 22 - 14, 144, 89, this::selectSlot, item -> {
            this.slotDisplay.setItem((class_1799)item);
            this.statDisplay.setCompareTo((class_1799)item);
            this.smithDisplay.setPreview((class_1799)item);
        }, ((CraftingScreenHandler)this.field_2797).inventory, ((CraftingScreenHandler)this.field_2797)::addSlotByClient, ((CraftingScreenHandler)this.field_2797)::removeSlotByClient);
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.field_2797).packetID);
        this.addChild(this.moduleCrafter);
        this.slotDisplay = new SlotDisplay(class_1799.field_8037, centerX + 51 - 15, centerY + 117 - 14, 68, 87, selected -> {});
        this.slotDisplay.setItem(this.getItem());
        this.addChild(this.slotDisplay);
        this.smithDisplay = new SmithDisplay(centerX + 140 - 15, centerY + 117 - 14, 55, 70);
        this.addChild(this.smithDisplay);
        this.statDisplay = new StatDisplayWidget(centerX + 213 - 15, centerY + 30 - 14, 161, 95);
        this.addChild(this.statDisplay);
        this.minimizer = new MinimizeButton(centerX + 178 - 15, centerY + 188 - 14, 18, 18, this::minimizeViewButton, this::maximizeViewButton);
        this.addChild(this.minimizer);
        super.method_25426();
        this.field_25269 = -1000;
        this.field_25270 = -1000;
        this.editHolder = new TransformableWidget(this.field_2776 - 15, this.field_2800 - 14, 0, 0, (class_2561)class_2561.method_43473());
        this.addChild(this.editHolder);
        this.updateItem(((CraftingScreenHandler)this.field_2797).inventory.method_5438(0));
        if (this.moduleCrafter != null) {
            this.moduleCrafter.handler = (CraftingScreenHandler)this.field_2797;
        }
        ((CraftingScreenHandler)this.field_2797).method_7596(new SimpleScreenHandlerListener((TriConsumer<class_1703, Integer, class_1799>)((TriConsumer)(handler, slotId, stack) -> {
            if (slotId == 36 && (!class_1799.method_31577((class_1799)stack, (class_1799)this.currentStack) || stack.method_7960() || this.currentStack.method_7960())) {
                this.currentStack = stack;
                this.updateItem((class_1799)stack);
            }
        })));
        this.addChild(new EditOptionIcon(this.moduleCrafter.method_46426() - 36, this.moduleCrafter.method_46427() + 4, 32, 28, this::selectEditOption, this::getEditOption, BACKGROUND_TEXTURE, 339, 25, 512, 512, "miapi.ui.edit_option.hover.info", null));
        this.selectEditOption(null);
        this.selectSlot(null);
        this.previewStack(((CraftingScreenHandler)this.field_2797).inventory.method_5438(0));
        PreviewManager.resetCursorStack();
        PreviewManager.resetPreview();
    }

    public int getBackgroundHeight() {
        return this.field_2779;
    }

    public int getBackgroundWidth() {
        return this.field_2792;
    }

    public void minimizeViewButton() {
        this.minimizeView();
        this.trueMinState = true;
    }

    public void minimizeView() {
        this.currentMinState = true;
        EditOption op = this.getEditOption();
        this.method_37066(this.moduleCrafter);
        SlotProperty.ModuleSlot slot1 = this.moduleCrafter.slot;
        this.editHolder.children().clear();
        this.moduleCrafter = new ModuleCrafter(this.moduleCrafter.method_46426(), this.moduleCrafter.method_46427(), this.moduleCrafter.method_25368(), this.moduleCrafter.method_25364() + 74, this.moduleCrafter);
        this.moduleCrafter.handler = (CraftingScreenHandler)this.field_2797;
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.field_2797).packetID);
        this.addChild(this.moduleCrafter);
        this.updateItem(this.getItem());
        this.moduleCrafter.setSelectedSlot(slot1);
        this.updateEditOptions();
        this.method_37066(this.slotDisplay);
        this.method_37066(this.smithDisplay);
        this.selectSlot(slot1);
        this.updateEditOptions();
        this.selectEditOption(op);
        class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
        if (class_17032 instanceof CraftingScreenHandler) {
            CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)class_17032;
            craftingScreenHandler.clearSlots();
        }
    }

    public void maximizeView() {
        this.currentMinState = false;
        EditOption op = this.getEditOption();
        this.method_37066(this.moduleCrafter);
        SlotProperty.ModuleSlot slot1 = this.moduleCrafter.slot;
        this.editHolder.children().clear();
        this.moduleCrafter = new ModuleCrafter(this.moduleCrafter.method_46426(), this.moduleCrafter.method_46427(), this.moduleCrafter.method_25368(), this.moduleCrafter.method_25364() - 74, this.moduleCrafter);
        this.moduleCrafter.handler = (CraftingScreenHandler)this.field_2797;
        this.moduleCrafter.setPacketIdentifier(((CraftingScreenHandler)this.field_2797).packetID);
        this.addChild(this.moduleCrafter);
        this.updateItem(this.getItem());
        this.moduleCrafter.setSelectedSlot(slot1);
        this.updateEditOptions();
        this.addChild(this.slotDisplay);
        this.addChild(this.smithDisplay);
        this.selectSlot(slot1);
        this.updateEditOptions();
        this.selectEditOption(op);
        class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
        if (class_17032 instanceof CraftingScreenHandler) {
            CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)class_17032;
            craftingScreenHandler.clearSlots();
        }
    }

    public void maximizeViewButton() {
        this.maximizeView();
        this.trueMinState = false;
    }

    public class_1799 getItem() {
        return ((CraftingScreenHandler)this.field_2797).inventory.method_5438(0);
    }

    public void setItem(class_1799 stack) {
        if (stack == null) {
            stack = class_1799.field_8037;
        }
        this.slotDisplay.setItem(stack);
        ((CraftingScreenHandler)this.field_2797).inventory.method_5447(0, stack);
    }

    public void updateItem(class_1799 stack) {
        PreviewManager.resetCursorStack();
        this.updatePreviewItemStack(stack);
    }

    public void updatePreviewItemStack(class_1799 stack) {
        stack = stack.method_7972();
        this.slotDisplay.setItem(stack);
        class_1799 converted = ModularItemStackConverter.getModularVersion(stack).method_7972();
        this.baseSlot.inSlot = ItemModule.getModules(converted);
        this.baseSlot.allowed = AllowedSlots.getAllowedSlots(this.baseSlot.inSlot.getModule());
        SlotProperty.ModuleSlot current = this.baseSlot;
        slot = null;
        if (this.baseSlot.inSlot.getModule().equals(ItemModule.empty)) {
            current = null;
        }
        if (!this.trueMinState || this.currentMinState || VisualModularItem.isVisualModularItem(stack) || MaterialProperty.getMaterialFromIngredient(stack) != null) {
            // empty if block
        }
        if (this.moduleCrafter != null) {
            this.moduleCrafter.setItem(converted);
            this.moduleCrafter.setBaseSlot(current);
            this.moduleCrafter.setSelectedSlot(null);
            this.moduleCrafter.setItem(converted);
            this.moduleCrafter.setBaseSlot(current);
            this.moduleCrafter.setSelectedSlot(null);
        }
        if (this.slotDisplay != null) {
            this.slotDisplay.setItem(converted);
            this.slotDisplay.select(current);
        }
        if (this.smithDisplay != null) {
            this.smithDisplay.setPreview(converted);
        }
        if (this.statDisplay != null) {
            this.statDisplay.setItemsOriginal(converted, converted);
        }
        this.updateEditOptions();
    }

    public void updateEditOptions() {
        int x = this.moduleCrafter.method_46426() - 36;
        int y = this.moduleCrafter.method_46427() + 4 + editSpace;
        for (InteractAbleWidget widget : this.editOptionIcons) {
            this.editHolder.removeChild(widget);
        }
        this.editHolder.children().clear();
        for (EditOption option : RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.getFlatMap().values()) {
            EditOption.EditContext context;
            if (!option.isVisible(context = this.get(option))) continue;
            InteractAbleWidget widget = option.getIconGui(x, y, 32, 28, this::selectEditOption, this::getEditOption);
            y += editSpace;
            this.editHolder.addChild(widget);
            this.editOptionIcons.add(widget);
        }
        if (!this.editHolder.children().contains(editOption)) {
            editOption = null;
        }
        PreviewManager.resetCursorStack();
        this.selectEditOption(editOption);
    }

    public EditOption.EditContext get(final EditOption editOption) {
        return new EditOption.EditContext(){

            @Override
            public void craft(class_2540 craftBuffer) {
                if (editOption != null) {
                    editOption.execute(craftBuffer, this);
                }
            }

            @Override
            public void preview(class_2540 preview) {
                if (editOption != null) {
                    CraftingScreen.this.previewStack(editOption.preview(preview, this));
                }
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return slot;
            }

            @Override
            public class_1799 getItemstack() {
                return CraftingScreen.this.moduleCrafter.stack;
            }

            @Override
            @Nullable
            public ModuleInstance getInstance() {
                if (this.getSlot() == null) {
                    return null;
                }
                return this.getSlot().inSlot;
            }

            @Override
            @Nullable
            public class_1657 getPlayer() {
                return class_310.method_1551().field_1724;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
                if (class_17032 instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)class_17032;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public class_1263 getLinkedInventory() {
                class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
                if (class_17032 instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)class_17032;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                class_1703 class_17032 = class_310.method_1551().field_1724.field_7512;
                if (class_17032 instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)class_17032;
                    return craftingScreenHandler;
                }
                return null;
            }
        };
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.overwriteMouseY = mouseY;
        this.overwriteMouseX = mouseX;
        if (this.hoverElement == null) {
            super.method_25394(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta);
        } else {
            this.hoverElement.method_25394(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta);
        }
        this.method_2380(drawContext, this.overwriteMouseX, this.overwriteMouseY);
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        if (this.hoverElement == null) {
            drawContext.method_51741(() -> this.renderHover(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta));
        } else {
            drawContext.method_51741(() -> this.hoverElement.renderHover(drawContext, this.overwriteMouseX, this.overwriteMouseY, delta));
        }
        drawContext.method_51448().method_22909();
        PreviewManager.tick();
    }

    public void method_25420(class_332 drawContext, int mouseX, int mouseY, float partialTick) {
        super.method_25420(drawContext, mouseX, mouseY, partialTick);
        int i = (this.field_22789 - this.field_2792 - 6) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        drawContext.method_25293(BACKGROUND_TEXTURE, i + 43 - 15, j + 14 - 14, 338, 199, 0.0f, 0.0f, 338, 199, 512, 512);
        if (this.minimizer.isEnabled()) {
            drawContext.method_25293(BACKGROUND_TEXTURE, i + 43 - 15, j + 111 - 14, 160, 95, 0.0f, 199.0f, 160, 95, 512, 512);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.hoverElement != null) {
            return this.hoverElement.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        if (this.hoverElement != null) {
            this.hoverElement.method_16014(mouseX, mouseY);
        } else {
            super.method_16014(mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.hoverElement != null) {
            return this.hoverElement.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.hoverElement != null && this.hoverElement.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount, double other) {
        if (this.hoverElement != null) {
            return this.hoverElement.method_25401(mouseX, mouseY, amount, other);
        }
        return super.method_25401(mouseX, mouseY, amount, other);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
    }

    static {
        editSpace = 30;
        craftingScreenWeakReference = new WeakReference<Object>(null);
    }
}

