/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.MutableSlot;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.SimpleScreenHandlerListener;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.client.gui.crafting.crafter.replace.EmptyCraftingWidget;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.network.Networking;

@Environment(value=EnvType.CLIENT)
public class CraftViewRework
extends InteractAbleWidget {
    public List<class_1735> currentSlots = new ArrayList<class_1735>();
    private int currentGuiIndex = 0;
    int backgroundWidth = 284;
    int backgroundHeight = 221;
    List<class_2561> warnings = new ArrayList<class_2561>();
    boolean firstRender = true;
    boolean isClosed = false;
    EditOption.EditContext editContext;
    CraftAction action;
    CraftOption craftOption;
    List<CraftingProperty> craftingProperties = new ArrayList<CraftingProperty>();
    List<InteractAbleWidget> craftingGuis = new ArrayList<InteractAbleWidget>();
    SimpleButton<Object> previousButton;
    SimpleButton<Object> nextButton;
    CraftButton<Object> craftButton;
    Matrix4f currentMatrix = new Matrix4f();
    public Map<class_2960, JsonElement> defaultMap = new HashMap<class_2960, JsonElement>();
    static class_1712 listener;
    EmptyCraftingWidget fallbackCraftingWidget;

    public CraftViewRework(int x, int y, int width, int height, int offset, CraftOption option, EditOption.EditContext editContext, Consumer<SlotProperty.ModuleSlot> back) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.editContext = editContext;
        this.craftOption = option;
        if (listener != null) {
            editContext.getScreenHandler().method_7603(listener);
        }
        listener = new SimpleScreenHandlerListener((TriConsumer<class_1703, Integer, class_1799>)((TriConsumer)(h, slotId, itemStack) -> {
            if (slotId != CraftingScreenHandler.CLIENT_SLOT_ID) {
                this.update();
            }
        }));
        this.defaultMap = option.data().get();
        this.action = new CraftAction(editContext.getItemstack(), editContext.getSlot(), option.module(), editContext.getPlayer(), editContext.getWorkbench(), option.data().get(), editContext.getScreenHandler());
        this.action.setItem(editContext.getItemstack());
        this.action.linkInventory(editContext.getLinkedInventory(), offset);
        this.setBuffers();
        class_1799 test = this.action.getPreview();
        this.action.forEachCraftingProperty(test, (craftingProperty, moduleInstance, itemStacks, invStart, invEnd, buf) -> {
            InteractAbleWidget guiScreen = craftingProperty.createGui(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759 - 30, this.action);
            if (guiScreen != null) {
                this.craftingGuis.add(guiScreen);
                this.craftingProperties.add(craftingProperty);
            }
        });
        this.fallbackCraftingWidget = new EmptyCraftingWidget(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.action);
        this.addChild(new SimpleButton<Object>(this.method_46426() + 2, this.method_46427() + this.field_22759 - 14, 40, 12, (class_2561)class_2561.method_43471((String)"miapi.ui.back"), null, moduleSlot -> {
            this.isClosed = true;
            this.closeSlot();
            back.accept(null);
        }));
        if (this.craftingGuis.size() > 1) {
            this.previousButton = new PageButton<Object>(this.method_46426() + this.field_22758 - 10, this.method_46427(), 10, 12, true, null, callback -> {
                if (this.currentGuiIndex > 0) {
                    this.removeChild(this.craftingGuis.get(this.currentGuiIndex));
                    --this.currentGuiIndex;
                    this.addGui(this.craftingGuis.get(this.currentGuiIndex));
                    if (this.currentGuiIndex == 0) {
                        this.previousButton.isEnabled = false;
                    }
                    this.nextButton.isEnabled = true;
                }
            });
            this.nextButton = new PageButton<Object>(this.method_46426() + 10, this.method_46427(), 10, 12, false, null, callback -> {
                if (this.currentGuiIndex < this.craftingGuis.size() - 1) {
                    this.removeChild(this.craftingGuis.get(this.currentGuiIndex));
                    ++this.currentGuiIndex;
                    this.addGui(this.craftingGuis.get(this.currentGuiIndex));
                    if (this.currentGuiIndex == this.craftingGuis.size() - 1) {
                        this.nextButton.isEnabled = false;
                    }
                    this.previousButton.isEnabled = true;
                }
            });
        }
        this.craftButton = new CraftButton<Object>(this.method_46426() + this.field_22758 - 42, this.method_46427() + this.field_22759 - 14, 40, 12, (class_2561)class_2561.method_43471((String)"miapi.ui.craft"), null, callback -> {
            this.setBuffers();
            this.action.setData(option.data().get());
            if (this.action.canPerform()) {
                this.isClosed = true;
                class_1799 craftedStack = this.action.getPreview();
                if (!class_1799.method_7973((class_1799)editContext.getItemstack(), (class_1799)craftedStack)) {
                    editContext.craft(this.action.toPacket(Networking.createBuffer()));
                    CraftingScreen.getInstance().setItem(craftedStack);
                }
                editContext.getScreenHandler().method_7603(listener);
            }
        });
        this.addChild(this.craftButton);
        editContext.getScreenHandler().method_7596(listener);
    }

    private void update() {
        try {
            if (!this.isClosed) {
                this.action.setData(this.craftOption.data().get());
                class_1799 previewStack = this.action.getPreview();
                this.action.setData(this.craftOption.data().get());
                this.setBuffers();
                this.action.setData(this.craftOption.data().get());
                this.editContext.preview(this.action.toPacket(Networking.createBuffer()));
                Pair<Map<CraftingProperty, Boolean>, Boolean> canPerform = this.action.fullCanPerform();
                this.craftButton.isEnabled = (Boolean)canPerform.getSecond();
                this.warnings.clear();
                class_1799 crafted = this.editContext.getItemstack();
                if (class_1799.method_7973((class_1799)previewStack, (class_1799)crafted)) {
                    this.warnings.add((class_2561)class_2561.method_43471((String)"miapi.ui.craft.result_equal_warning"));
                    this.craftButton.isEnabled = false;
                }
                if (previewStack.method_7919() > previewStack.method_7936()) {
                    this.warnings.add((class_2561)class_2561.method_43471((String)"miapi.ui.craft.warning.durability_negative"));
                    this.craftButton.isEnabled = false;
                }
                ((Map)canPerform.getFirst()).forEach((property, result) -> {
                    class_2561 warning;
                    if (!result.booleanValue() && (warning = property.getWarning()) != null && !warning.getString().isEmpty()) {
                        this.warnings.add(warning);
                    }
                });
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("surpressed", (Throwable)e);
        }
    }

    public void closeSlot() {
        this.currentSlots.forEach(slot -> {
            if (slot instanceof MutableSlot) {
                MutableSlot mutableSlot = (MutableSlot)((Object)slot);
                mutableSlot.setEnabled(true);
            }
            this.editContext.removeSlot((class_1735)slot);
        });
    }

    public void addGui(InteractAbleWidget widget) {
        if (this.children.contains((Object)widget)) {
            return;
        }
        widget.method_46421(this.method_46426());
        widget.method_46419(this.method_46427());
        widget.method_25358(this.field_22758);
        widget.method_53533(this.field_22759);
        this.currentSlots.forEach(slot -> {
            if (slot instanceof MutableSlot) {
                MutableSlot mutableSlot = (MutableSlot)((Object)slot);
                mutableSlot.setEnabled(false);
            }
        });
        CraftingProperty property = this.craftingProperties.get(this.craftingGuis.indexOf((Object)widget));
        this.action.forEachCraftingProperty(this.action.getPreview(), (craftingProperty, module, inventory, start, end, buffer) -> {
            if (craftingProperty.equals(property)) {
                AtomicInteger counter = new AtomicInteger(0);
                property.getSlotPositions().forEach(vec2f -> {
                    int guiX = widget.method_46426() + (int)vec2f.field_1343;
                    int guiY = widget.method_46427() + (int)vec2f.field_1342;
                    Matrix4f inverse = new Matrix4f((Matrix4fc)this.currentMatrix);
                    Vector4f vector4f = TransformableWidget.transFormMousePos(guiX, guiY, inverse);
                    guiX = (int)(vector4f.x() - (float)((class_310.method_1551().field_1755.field_22789 - this.backgroundWidth) / 2));
                    guiY = (int)(vector4f.y() - (float)((class_310.method_1551().field_1755.field_22790 - this.backgroundHeight) / 2));
                    MutableSlot slot = new MutableSlot(this.editContext.getLinkedInventory(), start + counter.getAndAdd(1), guiX, guiY);
                    this.currentSlots.add(slot);
                    this.editContext.addSlot(slot);
                });
            }
        });
        this.addChild(widget);
    }

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.currentMatrix = drawContext.method_51448().method_23760().method_23761();
        if (this.firstRender) {
            this.update();
            this.firstRender = false;
        }
        if (!this.craftingGuis.isEmpty()) {
            this.addGui(this.craftingGuis.get(this.currentGuiIndex));
        } else {
            this.addChild(this.fallbackCraftingWidget);
        }
        super.method_48579(drawContext, mouseX, mouseY, delta);
    }

    public void setBuffers() {
        HashMap<class_2960, JsonElement> data = new HashMap<class_2960, JsonElement>(this.defaultMap);
        this.action.data = this.craftOption.data().get();
        this.action.forEachCraftingProperty(this.editContext.getItemstack(), (craftingProperty, moduleInstance, itemStacks, invStart, invEnd, buf) -> {
            int index = this.craftingProperties.indexOf(craftingProperty);
            if (index >= 0) {
                craftingProperty.writeData(data, this.craftingGuis.get(this.craftingProperties.indexOf(craftingProperty)), this.editContext);
            } else {
                craftingProperty.writeData(data, null, this.editContext);
            }
        });
        this.action.setData(data);
    }

    public static class PageButton<T>
    extends SimpleButton<T> {
        private final boolean isLeft;
        private final class_2960 texture;
        private boolean isClicked;
        private final class_2960 right = class_2960.method_60655((String)"miapi", (String)"textures/button_right.png");
        private final class_2960 left = class_2960.method_60655((String)"miapi", (String)"textures/button_left.png");

        public PageButton(int x, int y, int width, int height, boolean isLeft, T toCallBack, Consumer<T> callback) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), toCallBack, callback);
            this.isLeft = isLeft;
            this.texture = isLeft ? this.left : this.right;
        }

        @Override
        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            int textureOffset = 0;
            if (this.isClicked) {
                textureOffset = 20;
                if (!this.method_25405(mouseX, mouseY)) {
                    this.isClicked = false;
                }
            } else if (this.method_25405(mouseX, mouseY)) {
                textureOffset = 10;
            }
            if (!this.isEnabled) {
                textureOffset = 30;
            }
            context.method_25291(this.texture, this.method_46426(), this.method_46427(), 0, (float)textureOffset, 0.0f, this.field_22758, this.field_22759, 40, this.field_22759);
        }
    }

    public class CraftButton<T>
    extends SimpleButton<T> {
        public HoverDescription hover;

        public CraftButton(int x, int y, int width, int height, class_2561 title, T toCallback, Consumer<T> callback) {
            super(x, y, width, height, title, toCallback, callback);
            this.hover = new HoverDescription(x, y + height, List.of());
        }

        @Override
        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            super.method_48579(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
            if (!this.isEnabled && this.method_25405(mouseX, mouseY)) {
                class_5250 text = class_2561.method_43471((String)"miapi.ui.craft.warning").method_27692(class_124.field_1079);
                this.hover.addText((class_2561)text);
                this.hover.method_46421(this.method_46426());
                this.hover.method_46419(this.method_46427() + this.method_25364());
                for (class_2561 warning : CraftViewRework.this.warnings) {
                    this.hover.addText((class_2561)class_2561.method_43470((String)" - ").method_10852(warning).method_27692(class_124.field_1061));
                }
                this.hover.method_25394(drawContext, mouseX, mouseY, delta);
                this.hover.reset();
            }
        }
    }
}

