/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5253;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.CraftingConditionProperty;
import smartin.miapi.modules.properties.PriorityProperty;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.slot.CanChildBeEmpty;
import smartin.miapi.modules.properties.slot.SlotProperty;

@Environment(value=EnvType.CLIENT)
public class ReplaceView
extends InteractAbleWidget {
    Consumer<CraftOption> craft;
    Consumer<CraftOption> preview;
    SlotButton lastPreview;
    public static List<CraftOptionSupplier> optionSuppliers = new ArrayList<CraftOptionSupplier>();
    public SlotProperty.ModuleSlot currentSlot;

    public ReplaceView(int x, int y, int width, int height, SlotProperty.ModuleSlot slot, EditOption.EditContext editContext, Consumer<SlotProperty.ModuleSlot> back, Consumer<CraftOption> craft, Consumer<CraftOption> preview) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.craft = craft;
        this.preview = preview;
        float headerScale = 1.0f;
        this.currentSlot = slot;
        TransformableWidget headerHolder = new TransformableWidget(x, y, width, height, headerScale);
        this.addChild(headerHolder);
        ScrollingTextWidget header = new ScrollingTextWidget((int)((float)(this.method_46426() + 5) / headerScale), (int)((float)this.method_46427() / headerScale) + 3, (int)((float)(this.field_22758 - 10) / headerScale), (class_2561)class_2561.method_43471((String)"miapi.ui.replace.header"), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        headerHolder.addChild(header);
        ScrollList list = new ScrollList(x, y + 14, width, height - 16, new ArrayList<InteractAbleWidget>());
        this.addChild(list);
        list.children().clear();
        ArrayList<InteractAbleWidget> toList = new ArrayList<InteractAbleWidget>();
        if (editContext.getInstance() == null || CanChildBeEmpty.property.isTrue(editContext.getInstance())) {
            toList.add(new SlotButton(0, 0, this.field_22758, 15, new CraftOption(ItemModule.empty, new HashMap<class_2960, JsonElement>(), -1000.0)));
        }
        ArrayList craftOptions = new ArrayList();
        AllowedSlots.allowedIn(slot).forEach(module -> {
            if (CraftingConditionProperty.isVisible(slot, module, (class_1657)class_310.method_1551().field_1724, null)) {
                craftOptions.add(new CraftOption((ItemModule)module, (Map<class_2960, JsonElement>)new HashMap<class_2960, JsonElement>(), PriorityProperty.getFor(module)));
            }
        });
        optionSuppliers.forEach(craftOptionSupplier -> craftOptions.addAll(craftOptionSupplier.getOption(editContext)));
        List<CraftOption> sortedCraftOptions = craftOptions.stream().sorted(Comparator.comparingDouble(CraftOption::priority)).toList();
        sortedCraftOptions.forEach(craftOption -> toList.add(new SlotButton(0, 0, this.field_22758, 15, (CraftOption)craftOption)));
        list.setList(toList);
    }

    public void setPreview(CraftOption option) {
        this.preview.accept(option);
    }

    class SlotButton
    extends InteractAbleWidget {
        private final ScrollingTextWidget textWidget;
        private final CraftOption option;
        private boolean isAllowed;
        private final HoverDescription hoverDescription;

        public SlotButton(int x, int y, int width, int height, CraftOption option) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.isAllowed = true;
            this.option = option;
            this.textWidget = new ScrollingTextWidget(0, 0, this.field_22758, option.displayName(), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.isAllowed = CraftingConditionProperty.isSelectAble(ReplaceView.this.currentSlot, option.module(), (class_1657)class_310.method_1551().field_1724, null);
            List<class_2561> texts = new ArrayList<class_2561>();
            if (!this.isAllowed) {
                texts = CraftingConditionProperty.getReasonsForSelectable(ReplaceView.this.currentSlot, option.module(), (class_1657)class_310.method_1551().field_1724, null);
            }
            this.hoverDescription = new HoverDescription(x, y, texts);
        }

        @Override
        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            int hoverOffset = 0;
            if (this.method_25405(mouseX, mouseY)) {
                hoverOffset = 14;
            }
            if (!this.isAllowed) {
                hoverOffset = 28;
            }
            SlotButton.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.method_46426(), this.method_46427(), 404, 54 + hoverOffset, 108, 14, this.method_25368(), this.method_25364(), 512, 512, 3);
            this.textWidget.method_46421(this.method_46426() + 2);
            this.textWidget.method_46419(this.method_46427() + 3);
            this.textWidget.method_25358(this.field_22758 - 4);
            this.textWidget.method_25394(drawContext, mouseX, mouseY, delta);
            if (this.method_25405(mouseX, mouseY) && !this.isAllowed && this.hoverDescription != null) {
                this.hoverDescription.method_25394(drawContext, mouseX, mouseY, delta);
            }
        }

        @Override
        public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
            if (this.method_25405(mouseX, mouseY) && !this.isAllowed && this.hoverDescription != null) {
                this.hoverDescription.method_46421(this.method_46426());
                this.hoverDescription.method_46419(this.method_46427() + this.method_25364());
                this.hoverDescription.method_25394(drawContext, mouseX, mouseY, delta);
            }
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            boolean isOver = super.method_25405(mouseX, mouseY);
            if (!((Object)((Object)this)).equals((Object)ReplaceView.this.lastPreview) && isOver) {
                ReplaceView.this.lastPreview = this;
                ReplaceView.this.setPreview(this.option);
            }
            return isOver;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY) && button == 0 && this.isAllowed) {
                this.playClickedSound();
                ReplaceView.this.craft.accept(this.option);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    public static interface CraftOptionSupplier {
        public List<CraftOption> getOption(EditOption.EditContext var1);
    }
}

