/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@Environment(value=EnvType.CLIENT)
public class DoubleResolvableStatDisplay
extends SingleStatDisplayDouble {
    protected Function<class_1799, Optional<DoubleOperationResolvable>> resolvableGetter;
    public BiFunction<class_1799, class_1799, Boolean> condition = (old, compare) -> true;

    protected DoubleResolvableStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, Function<class_1799, Optional<DoubleOperationResolvable>> resolvableGetter) {
        super(0, 0, 51, 19, title, hover);
        this.resolvableGetter = resolvableGetter;
    }

    @Override
    public boolean shouldRender(class_1799 original, class_1799 compareTo) {
        super.shouldRender(original, compareTo);
        if (!this.condition.apply(original, compareTo).booleanValue()) {
            return false;
        }
        return this.resolvableGetter.apply(original).isPresent() && !this.resolvableGetter.apply((class_1799)original).get().operations.isEmpty() && this.resolvableGetter.apply(original).get().getValue() != this.resolvableGetter.apply(original).get().getFallback() || this.resolvableGetter.apply(compareTo).isPresent() && !this.resolvableGetter.apply((class_1799)compareTo).get().operations.isEmpty() && this.resolvableGetter.apply(compareTo).get().getValue() != this.resolvableGetter.apply(compareTo).get().getFallback();
    }

    @Override
    public double getValue(class_1799 stack) {
        return this.resolvableGetter.apply(stack).map(DoubleOperationResolvable::getValue).orElse(0.0);
    }

    @Override
    public DoubleOperationResolvable getResolvable(class_1799 stack) {
        return this.resolvableGetter.apply(stack).orElse(null);
    }

    public static String getStringName(class_1322.class_1323 operation) {
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case class_1322.class_1323.field_6328 -> "+";
            case class_1322.class_1323.field_6330 -> "*";
            case class_1322.class_1323.field_6331 -> "**";
        };
    }

    public static Builder builder(Function<class_1799, Optional<DoubleOperationResolvable>> getter) {
        return new Builder(getter);
    }

    public static class Builder {
        Function<class_1799, Optional<DoubleOperationResolvable>> getter;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> class_2561.method_43473();
        public DecimalFormat modifierFormat;
        public DecimalFormat hoverFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public BiFunction<class_1799, class_1799, Boolean> condition = (old, compare) -> this.getter.apply((class_1799)old).isPresent() && !this.getter.apply((class_1799)old).get().operations.isEmpty() || this.getter.apply((class_1799)compare).isPresent() && !this.getter.apply((class_1799)compare).get().operations.isEmpty();

        private Builder(Function<class_1799, Optional<DoubleOperationResolvable>> getter) {
            this.getter = getter;
            this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("##.##"), df -> df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        }

        public Builder setInverse(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setCondition(BiFunction<class_1799, class_1799, Boolean> condition) {
            this.condition = condition;
            return this;
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setName(class_2561 name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(class_2960 key) {
            String translationKey = Miapi.toLangString(key);
            this.name = stack -> class_2561.method_43469((String)("miapi.stat." + translationKey), (Object[])new Object[]{this.modifierFormat.format(this.getter.apply(stack).map(DoubleOperationResolvable::getValue).orElse(0.0))});
            this.hoverDescription = stack -> class_2561.method_43469((String)("miapi.stat." + translationKey + ".description"), (Object[])new Object[]{this.modifierFormat.format(this.getter.apply(stack).map(DoubleOperationResolvable::getValue).orElse(0.0))});
            return this;
        }

        public Builder setHoverDescription(class_2561 hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat(format), df -> df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setHoverFormat(String format) {
            this.hoverFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat(format), df -> df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public DoubleResolvableStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.getter == null) {
                throw new IllegalStateException("Resolvable getter is required");
            }
            DoubleResolvableStatDisplay display = new DoubleResolvableStatDisplay(this.name, this.hoverDescription, this.getter);
            display.maxValue = this.max;
            display.minValue = this.min;
            display.modifierFormat = this.modifierFormat;
            display.inverse = this.inverse;
            display.condition = this.condition;
            display.hoverFormat = this.hoverFormat != null ? this.hoverFormat : this.modifierFormat;
            return display;
        }
    }
}

