/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ParentHandledScreen;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.StatBar;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.statdisplay.SinglePropertyStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@Environment(value=EnvType.CLIENT)
public abstract class SingleStatDisplayDouble
extends InteractAbleWidget
implements SingleStatDisplay,
class_4068 {
    public class_2960 texture = CraftingScreen.BACKGROUND_TEXTURE;
    public class_1799 original = class_1799.field_8037;
    public class_1799 compareTo = class_1799.field_8037;
    public StatBar statBar;
    public ScrollingTextWidget currentValue;
    public ScrollingTextWidget compareValue;
    public ScrollingTextWidget centerValue;
    public ScrollingTextWidget textWidget;
    public double maxValue = 100.0;
    public double minValue = 0.0;
    public DecimalFormat modifierFormat;
    public DecimalFormat hoverFormat;
    public StatListWidget.TextGetter text;
    public StatListWidget.TextGetter hover;
    public class_2561 postfix = class_2561.method_30163((String)"");
    public boolean inverse = false;
    double oldValue = 0.0;
    double compareToValue = 0.0;

    protected SingleStatDisplayDouble(int x, int y, int width, int height, StatListWidget.TextGetter title, StatListWidget.TextGetter hover) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.text = title;
        this.hover = hover;
        this.textWidget = new ScrollingTextWidget(x, y, 80, (class_2561)class_2561.method_43473(), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        this.currentValue = new ScrollingTextWidget(x, y, 50, (class_2561)class_2561.method_43473(), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        this.centerValue = new ScrollingTextWidget(x, y, 70, (class_2561)class_2561.method_43473(), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        this.centerValue.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        this.compareValue = new ScrollingTextWidget(x, y, 70, (class_2561)class_2561.method_43473(), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
        this.statBar = new StatBar(0, 0, width, 1, class_5253.class_5254.method_27764((int)255, (int)0, (int)0, (int)0));
        this.modifierFormat = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public int getRed() {
        if (this.inverse) {
            return MiapiConfig.getClientConfig().guiColors.green.argb();
        }
        return MiapiConfig.getClientConfig().guiColors.red.argb();
    }

    public int getGreen() {
        if (this.inverse) {
            return MiapiConfig.getClientConfig().guiColors.red.argb();
        }
        return MiapiConfig.getClientConfig().guiColors.green.argb();
    }

    @Override
    public boolean shouldRender(class_1799 original, class_1799 compareTo) {
        class_1799 mainStack = compareTo.method_7960() ? original : compareTo;
        this.original = original;
        this.compareTo = compareTo;
        this.compareToValue = this.getValue(compareTo);
        this.oldValue = this.getValue(original);
        this.textWidget.setText(this.text.resolve(mainStack));
        this.compareValue.setText(class_2561.method_30163((String)this.modifierFormat.format(this.compareToValue)));
        int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.text.resolve(original));
        int numberWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.compareValue.getText());
        int size = Math.min(3, Math.max(1, (textWidth + numberWidth) / 47));
        this.method_25358(51 * size);
        return true;
    }

    @Override
    public int getHeightDesired() {
        return 19;
    }

    @Override
    public int getWidthDesired() {
        int textWidth = class_310.method_1551().field_1772.method_1727(this.text.resolve(this.original).getString());
        int numberWidth = class_310.method_1551().field_1772.method_1727(this.compareValue.getText().getString());
        int size = 1;
        if (textWidth + numberWidth > 70) {
            size = 2;
        }
        return 76 * size;
    }

    public abstract double getValue(class_1799 var1);

    @Override
    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        double min = Math.min(this.minValue, Math.min(this.oldValue, this.compareToValue));
        double max = Math.max(this.maxValue, Math.max(this.oldValue, this.compareToValue));
        SingleStatDisplayDouble.drawTextureWithEdge(drawContext, this.texture, this.method_46426(), this.method_46427(), 339, 6, 51, 19, this.field_22758, this.field_22759, 512, 512, 2);
        this.textWidget.method_46421(this.method_46426() + 3);
        this.textWidget.method_46419(this.method_46427() + 3);
        this.textWidget.method_25358(this.field_22758 - 25);
        this.statBar.method_46421(this.method_46426() + 2);
        this.statBar.method_46419(this.method_46427() + 15);
        this.statBar.method_25358(this.field_22758 - 4);
        this.statBar.method_53533(1);
        if (this.oldValue < this.compareToValue) {
            this.statBar.setPrimary((this.oldValue - min) / (max - min), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.compareToValue - min) / (max - min), this.getGreen());
            this.compareValue.textColor = this.getGreen();
        } else {
            this.statBar.setPrimary((this.compareToValue - min) / (max - min), class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            this.statBar.setSecondary((this.oldValue - min) / (max - min), this.getRed());
            this.compareValue.textColor = this.getRed();
        }
        if (this.oldValue == this.compareToValue) {
            this.currentValue.method_46421(this.method_46426() - 3);
            this.currentValue.method_46419(this.method_46427() + 5);
            this.currentValue.method_25358(this.method_25368());
            this.currentValue.setText((class_2561)class_2561.method_43470((String)(this.modifierFormat.format(this.oldValue) + this.postfix.getString())));
            this.currentValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.currentValue.method_25394(drawContext, mouseX, mouseY, delta);
        } else {
            this.compareValue.method_46421(this.method_46426() - 3);
            this.compareValue.method_46419(this.method_46427() + 5);
            this.compareValue.method_25358(this.method_25368());
            this.compareValue.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            this.compareValue.setText((class_2561)class_2561.method_43470((String)(class_2561.method_30163((String)this.modifierFormat.format(this.compareToValue)).getString() + this.postfix.getString())));
            this.compareValue.method_25394(drawContext, mouseX, mouseY, delta);
        }
        this.statBar.method_25394(drawContext, mouseX, mouseY, delta);
        this.textWidget.method_25394(drawContext, mouseX, mouseY, delta);
    }

    @Override
    public void renderHover(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.method_25405(mouseX, mouseY)) {
            drawContext.method_51434(class_310.method_1551().field_1772, this.getHoverLines(drawContext, mouseX, mouseY, delta), mouseX, mouseY);
        }
    }

    public List<class_2561> getHoverLines(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.method_25405(mouseX, mouseY)) {
            class_2561 text1 = this.hover.resolve(this.compareTo);
            ArrayList<class_2561> components = new ArrayList<class_2561>();
            if (!text1.getString().isEmpty()) {
                components.addAll(Arrays.stream(text1.getString().split("\n")).map(class_2561::method_43470).toList());
            }
            components.addAll(this.additionalHoverLines());
            components.addAll(this.getLinesForDouble(this.getResolvable(this.compareTo == null ? this.original : this.compareTo)));
            return components;
        }
        return List.of();
    }

    public List<class_2561> additionalHoverLines() {
        return List.of();
    }

    public DoubleOperationResolvable getResolvable(class_1799 stack) {
        return null;
    }

    public DecimalFormat getHoverFormat() {
        if (this.hoverFormat == null) {
            return this.modifierFormat;
        }
        return this.hoverFormat;
    }

    public List<class_2561> getLinesForDouble(@Nullable DoubleOperationResolvable resolvable) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (resolvable != null) {
            if (ParentHandledScreen.method_25442()) {
                if (resolvable != null) {
                    resolvable.operations.forEach(operation1 -> {
                        if (operation1.solve() != 0.0) {
                            list.add((class_2561)class_2561.method_43470((String)SinglePropertyStatDisplay.stringForOperation(this.getHoverFormat(), operation1)).method_27692(class_124.field_1080));
                            if (ParentHandledScreen.method_25443()) {
                                operation1.source.ifPresent(list::add);
                                list.add((class_2561)class_2561.method_43470((String)("  " + operation1.value)).method_27692(class_124.field_1063));
                            }
                        }
                    });
                }
                list.add((class_2561)class_2561.method_43471((String)"miapi.ui.stat_detail.shift_alt").method_27692(class_124.field_1063));
            } else {
                list.add((class_2561)class_2561.method_43471((String)"miapi.ui.stat_detail.shift").method_27692(class_124.field_1063));
            }
        }
        return list;
    }

    @Override
    public InteractAbleWidget getHoverWidget() {
        return null;
    }

    public static interface StatReaderHelper {
        public double getValue(class_1799 var1);

        public boolean hasValue(class_1799 var1);
    }
}

