/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay.material;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.client.gui.crafting.statdisplay.material.MaterialGroupTitleWidget;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.mixin.RegistryOpsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

@Environment(value=EnvType.CLIENT)
public class MaterialStatWidget
extends InteractAbleWidget {
    ScrollList list;
    Material original;

    public MaterialStatWidget(Material original, Material compareTo, int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.original = original;
        this.list = new ScrollList(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), List.of());
        this.list.alwaysEnableScrollbar = true;
        this.list.altDesign = true;
        this.addChild(this.list);
        this.setup(original, compareTo);
    }

    private void setup(Material original, Material compareTo) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(original.getAllDisplayPropertyKeys());
        keys.addAll(compareTo.getAllDisplayPropertyKeys());
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        for (String propertyKey : keys) {
            class_1799 compareStack;
            class_1799 originalStack = MaterialStatWidget.getDisplayStack(original, propertyKey);
            List<InteractAbleWidget> stats = StatListWidget.collectWidgets(originalStack, compareStack = MaterialStatWidget.getDisplayStack(compareTo, propertyKey));
            if (stats.isEmpty()) continue;
            widgets.add(new MaterialGroupTitleWidget(0, 0, this.field_22758, propertyKey, stats, originalStack, compareStack));
            widgets.addAll(stats);
        }
        this.list.setList(widgets);
    }

    public void setCompareTo(class_1799 compareTo) {
        Material compareToMaterial = MaterialProperty.getMaterialFromIngredient(compareTo);
        if (compareToMaterial != null) {
            this.setup(this.original, compareToMaterial);
        }
    }

    @NotNull
    private static class_1799 getDisplayStack(Material original, String propertyKey) {
        ModuleInstance moduleInstance = new ModuleInstance(ItemModule.internal);
        class_1799 compareMaterial = RegistryInventory.modularStackableItem.method_7854();
        ModuleDataPropertiesManager.setProperties(moduleInstance, original.getDisplayMaterialProperties(propertyKey));
        moduleInstance.clearCaches();
        moduleInstance.writeToItem(compareMaterial);
        moduleInstance.lookup = ((RegistryOpsAccessor)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)Miapi.registryAccess)).getLookupProvider();
        moduleInstance.contextStack = compareMaterial;
        moduleInstance.registryAccess = Miapi.registryAccess;
        StatListWidget.setAttributeCaches(compareMaterial, compareMaterial);
        return compareMaterial;
    }
}

