/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.client.GlintShader;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModuleModel;
import smartin.miapi.client.model.item.DualKeyCache;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;

@Environment(value=EnvType.CLIENT)
public class MiapiItemModel
implements MiapiModel {
    public static List<ModelSupplier> modelSuppliers = new ArrayList<ModelSupplier>();
    public static List<ModelTransformerSupplier> modelTransformersSuppler = new ArrayList<ModelTransformerSupplier>();
    private static final String CACHE_KEY = "miapi_model_rework";
    public final DualKeyCache<String, class_811, List<ModelTransformer>> transformerCache = new DualKeyCache();
    public final DualKeyCache<String, class_811, ModuleModel> modelCache = new DualKeyCache();
    public static final WeakHashMap<class_1799, MiapiItemModel> fallbackLookup = new WeakHashMap();

    @Nullable
    public static MiapiItemModel getItemModel(class_1799 stack) {
        return (MiapiItemModel)ModularItemCache.getRaw(stack, CACHE_KEY);
    }

    private MiapiItemModel(class_1799 stack) {
        if (!(stack.method_7909() instanceof VisualModularItem) && !VisualModularItem.isVisualModularItem(stack)) {
            throw new RuntimeException("Can only make MiapiModel for Modular Items");
        }
    }

    public void render(class_4587 matrices, class_1799 stack, class_811 mode, float tickDelta, class_4597 vertexConsumers, int light, int overlay) {
        this.render(null, stack, matrices, mode, tickDelta, vertexConsumers, light, overlay);
    }

    @Override
    public void render(class_4587 matrices, class_1799 stack, class_811 mode, float tickDelta, class_4597 vertexConsumers, class_1309 entity, int light, int overlay) {
        this.render(null, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
    }

    public void render(String modelType, class_1799 stack, class_4587 matrices, class_811 mode, float tickDelta, class_4597 vertexConsumers, int light, int overlay) {
        this.render(modelType, stack, matrices, mode, tickDelta, vertexConsumers, null, light, overlay);
    }

    public void render(String modelTypeRaw, class_1799 stack, class_4587 matrices, class_811 mode, float tickDelta, class_4597 vertexConsumers, class_1309 entity, int light, int overlay) {
        if (ReloadEvents.isInReload()) {
            ModuleInstance instance = ItemModule.getModules(stack);
            if (instance != null) {
                instance.clearCaches();
            }
            return;
        }
        assert (class_310.method_1551().field_1687 != null);
        class_310.method_1551().method_16011().method_15396("modular_item");
        class_310.method_1551().method_16011().method_15396("root-logic");
        String modelType = modelTypeRaw == null ? "item" : modelTypeRaw;
        ModuleModel rootModel = this.modelCache.getNullSave(modelType, mode, (s, k) -> new ModuleModel(ItemModule.getModules(stack), stack, (String)s, (class_811)k));
        matrices.method_22903();
        class_310.method_1551().method_16011().method_15396("model-transformers");
        List transformers = this.transformerCache.getNullSave(modelType, mode, (s, t) -> MiapiItemModel.getTransfomers(stack, mode, modelType));
        for (ModelTransformer transformer : transformers) {
            matrices = transformer.transform(matrices, tickDelta);
        }
        class_310.method_1551().method_16011().method_15407();
        if (entity == null) {
            entity = class_310.method_1551().field_1724;
        }
        class_310.method_1551().method_16011().method_15396("glint-setup");
        GlintShader.setupItem(matrices.method_23760().method_23761());
        class_310.method_1551().method_16011().method_15407();
        class_310.method_1551().method_16011().method_15407();
        rootModel.render(modelType, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
        matrices.method_22909();
        matrices.method_23760().method_23761().invert();
        class_310.method_1551().method_16011().method_15407();
    }

    @NotNull
    private static List<ModelTransformer> getTransfomers(class_1799 stack, class_811 mode, String modelType) {
        ArrayList<ModelTransformer> transformersList = new ArrayList<ModelTransformer>();
        modelTransformersSuppler.forEach(modelSupplier -> {
            ModelTransformer transformer = modelSupplier.get(stack, modelType, mode);
            if (transformer != null) {
                transformersList.add(transformer);
            }
        });
        return transformersList;
    }

    @Override
    @Nullable
    public Matrix4f subModuleMatrix() {
        return null;
    }

    static {
        ModularItemCache.setSupplier(CACHE_KEY, s -> {
            if (fallbackLookup.containsKey(s)) {
                return fallbackLookup.get(s);
            }
            MiapiItemModel model = new MiapiItemModel(s);
            fallbackLookup.put(s, model);
            return model;
        });
        MiapiEvents.CLEAR_CACHE.register(() -> {
            new ArrayList<class_1799>(fallbackLookup.keySet()).forEach(i -> {
                ModuleInstance moduleInstance = ItemModule.getModules(i);
                if (moduleInstance != null) {
                    moduleInstance.clearCaches();
                }
            });
            fallbackLookup.clear();
            return EventResult.pass();
        });
    }

    public static interface ModelTransformer {
        public class_4587 transform(class_4587 var1, float var2);
    }

    public static interface ModelTransformerSupplier {
        public ModelTransformer get(class_1799 var1, String var2, @Nullable class_811 var3);
    }

    public static interface ModelSupplier {
        public List<MiapiModel> getModels(String var1, @Nullable class_811 var2, ModuleInstance var3, class_1799 var4);

        default public List<Pair<Matrix4f, MiapiModel>> filter(List<Pair<Matrix4f, MiapiModel>> models, class_1799 stack, ModuleInstance module, String key, class_811 context) {
            return models;
        }
    }
}

