/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_5819;
import net.minecraft.class_777;

@Environment(value=EnvType.CLIENT)
public class ModelTransformer {
    private static final Map<class_1087, List<class_777>> inverseMap = new WeakHashMap<class_1087, List<class_777>>();
    private static final Map<class_1087, List<class_777>> reScaledMap = new WeakHashMap<class_1087, List<class_777>>();
    private static final Map<class_1087, List<class_777>> inversedRescaledMap = new WeakHashMap<class_1087, List<class_777>>();

    public static void clearCaches() {
        inverseMap.clear();
        reScaledMap.clear();
        inversedRescaledMap.clear();
    }

    public static List<class_777> getInverse(class_1087 bakedModel, class_5819 random) {
        return inverseMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (class_2350 direction : class_2350.values()) {
                rawQuads.addAll(model.method_4707(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> redoneQuads.add(new class_777(ModelTransformer.inverse(bakedQuad.method_3357()), bakedQuad.method_3359(), bakedQuad.method_3358(), bakedQuad.method_35788(), bakedQuad.method_24874())));
            return redoneQuads;
        });
    }

    public static List<class_777> getRescale(class_1087 bakedModel, class_5819 random) {
        return reScaledMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (class_2350 direction : class_2350.values()) {
                rawQuads.addAll(model.method_4707(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> {
                float uStart = bakedQuad.method_35788().method_4594();
                float uScale = 1.0f / (bakedQuad.method_35788().method_4577() - bakedQuad.method_35788().method_4594());
                float vStart = bakedQuad.method_35788().method_4593();
                float vScale = 1.0f / (bakedQuad.method_35788().method_4575() - bakedQuad.method_35788().method_4593());
                redoneQuads.add(new class_777(ModelTransformer.rescale(bakedQuad.method_3357(), uStart, uScale, vStart, vScale), bakedQuad.method_3359(), bakedQuad.method_3358(), bakedQuad.method_35788(), bakedQuad.method_24874()));
            });
            return redoneQuads;
        });
    }

    public static List<class_777> getRescaleInverse(class_1087 bakedModel, class_5819 random) {
        return inversedRescaledMap.computeIfAbsent(bakedModel, model -> {
            ArrayList rawQuads = new ArrayList();
            for (class_2350 direction : class_2350.values()) {
                rawQuads.addAll(model.method_4707(null, direction, random));
            }
            ArrayList redoneQuads = new ArrayList();
            rawQuads.forEach(bakedQuad -> {
                float uStart = bakedQuad.method_35788().method_4594();
                float uScale = 1.0f / (bakedQuad.method_35788().method_4577() - bakedQuad.method_35788().method_4594());
                float vStart = bakedQuad.method_35788().method_4593();
                float vScale = 1.0f / (bakedQuad.method_35788().method_4575() - bakedQuad.method_35788().method_4593());
                redoneQuads.add(new class_777(ModelTransformer.inverse(ModelTransformer.rescale(bakedQuad.method_3357(), uStart, uScale, vStart, vScale)), bakedQuad.method_3359(), bakedQuad.method_3358(), bakedQuad.method_35788(), bakedQuad.method_24874()));
            });
            return redoneQuads;
        });
    }

    private static int[] rescale(int[] raw, float uStart, float uScale, float vStart, float vScale) {
        int[] copiedArray = new int[raw.length];
        System.arraycopy(raw, 0, copiedArray, 0, raw.length);
        for (int i = 0; i < raw.length / 8; ++i) {
            copiedArray[i * 8 + 4] = Float.floatToRawIntBits((Float.intBitsToFloat(raw[i * 8 + 4]) - uStart) * uScale);
            copiedArray[i * 8 + 5] = Float.floatToRawIntBits((Float.intBitsToFloat(raw[i * 8 + 5]) - vStart) * vScale);
        }
        return copiedArray;
    }

    private static int[] inverse(int[] raw) {
        int[] copiedArray = new int[raw.length];
        System.arraycopy(raw, 0, copiedArray, 0, raw.length);
        for (int j = 0; j < 8; ++j) {
            copiedArray[j] = raw[16 + j];
            copiedArray[8 + j] = raw[8 + j];
            copiedArray[16 + j] = raw[j];
            copiedArray[24 + j] = raw[24 + j];
        }
        return copiedArray;
    }
}

