/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.item;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.minecraft.class_799;
import net.minecraft.class_806;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.model.DynamicBakery;

@Environment(value=EnvType.CLIENT)
public class BakedSingleModelOverrides
extends class_806 {
    public final DynamicBakedOverride[] dynamicOverrides;
    public final class_2960[] dynamicConditionTypes;

    public BakedSingleModelOverrides(Map<ConditionHolder, class_1087> modelHashMap) {
        super(DynamicBakery.dynamicBaker, null, new ArrayList());
        this.dynamicConditionTypes = (class_2960[])modelHashMap.keySet().stream().flatMap(conditionHolder -> conditionHolder.conditions.stream()).map(Condition::getType).distinct().toArray(class_2960[]::new);
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        for (int i = 0; i < this.dynamicConditionTypes.length; ++i) {
            object2IntMap.put((Object)this.dynamicConditionTypes[i], i);
        }
        ArrayList list = Lists.newArrayList();
        modelHashMap.forEach((arg_0, arg_1) -> BakedSingleModelOverrides.lambda$new$4((Object2IntMap)object2IntMap, list, arg_0, arg_1));
        DynamicBakedOverride[] dynamicCondition = new DynamicBakedOverride[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dynamicCondition[i] = (DynamicBakedOverride)list.get(i);
        }
        this.dynamicOverrides = dynamicCondition;
    }

    public class_1087 method_3495(@NotNull class_1087 model, @NotNull class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
        if (this.dynamicOverrides.length != 0) {
            int j;
            int i = this.dynamicConditionTypes.length;
            float[] fs = new float[i];
            for (j = 0; j < i; ++j) {
                class_2960 identifier = this.dynamicConditionTypes[j];
                class_1800 modelPredicateProvider = class_5272.method_27878((class_1799)stack, (class_2960)identifier);
                fs[j] = modelPredicateProvider != null ? modelPredicateProvider.call(stack, world, entity, seed) : Float.NEGATIVE_INFINITY;
            }
            for (j = 0; j < this.dynamicOverrides.length; ++j) {
                DynamicBakedOverride bakedOverride = this.dynamicOverrides[j];
                if (!bakedOverride.test(fs) || bakedOverride.model == null) continue;
                return bakedOverride.model;
            }
        }
        return model;
    }

    private static /* synthetic */ void lambda$new$4(Object2IntMap object2IntMap, List list, ConditionHolder conditionHolder, class_1087 bakedModel) {
        InlinedCondition[] inlinedConditions = (InlinedCondition[])conditionHolder.conditions.stream().map(condition -> {
            int i = object2IntMap.getInt((Object)condition.getType());
            return new InlinedCondition(i, condition.getThreshold());
        }).toArray(InlinedCondition[]::new);
        list.add(new DynamicBakedOverride(inlinedConditions, bakedModel));
    }

    @Environment(value=EnvType.CLIENT)
    static class DynamicBakedOverride {
        private final InlinedCondition[] conditions;
        @Nullable
        final class_1087 model;

        DynamicBakedOverride(InlinedCondition[] conditions, @Nullable class_1087 model) {
            this.conditions = conditions;
            this.model = model;
        }

        boolean test(float[] values) {
            for (InlinedCondition inlinedCondition : this.conditions) {
                float f = values[inlinedCondition.index];
                if (!(f < inlinedCondition.threshold)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ConditionHolder {
        public class_2960 identifier;
        public List<Condition> conditions;

        public ConditionHolder(class_799 override) {
            this.identifier = override.method_3472();
            this.conditions = override.method_33690().map(condition -> new Condition((class_799.class_5826)condition)).toList();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConditionHolder) {
                ConditionHolder otherCondition = (ConditionHolder)obj;
                if (this.conditions.size() == otherCondition.conditions.size()) {
                    for (Condition condition : this.conditions) {
                        if (otherCondition.conditions.contains(condition)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isAcceptable(ConditionHolder other) {
            for (Condition condition : other.conditions) {
                Optional<Condition> exist = this.conditions.stream().filter(condition1 -> condition1.type.equals((Object)condition.type)).findFirst();
                if (!exist.isPresent() || !(condition.threshold < exist.get().threshold)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.conditions.size();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConditionHolder-" + this.identifier.toString() + "\n");
            for (Condition condition : this.conditions) {
                builder.append(condition.toString() + ",");
            }
            return builder.toString();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record InlinedCondition(int index, float threshold) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class Condition {
        private final class_2960 type;
        private final float threshold;

        public Condition(class_799.class_5826 condition) {
            this.type = condition.method_33692();
            this.threshold = condition.method_33693();
        }

        public Condition(class_2960 type, float threshold) {
            this.type = type;
            this.threshold = threshold;
        }

        public class_2960 getType() {
            return this.type;
        }

        public float getThreshold() {
            return this.threshold;
        }

        public boolean equals(Object obj) {
            Condition otherCondition;
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof Condition) {
                otherCondition = (Condition)obj;
                if (otherCondition.type.equals((Object)this.type) && otherCondition.threshold == this.threshold) {
                    return true;
                }
            }
            if (obj instanceof class_799.class_5826) {
                otherCondition = (class_799.class_5826)obj;
                return otherCondition.method_33692().equals((Object)this.type) && otherCondition.method_33693() == this.threshold;
            }
            return false;
        }

        public String toString() {
            return "Condition - " + this.type.toString() + " - " + this.threshold;
        }
    }
}

