/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.module;

import com.redpxnda.nucleus.util.Color;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.GlintShader;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.model.ModelTransformer;
import smartin.miapi.client.renderer.RescaledVertexConsumer;
import smartin.miapi.client.renderer.TrimRenderer;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.mixin.BufferBuilderAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.GlintProperty;
import smartin.miapi.modules.properties.render.AlphaOverwriteProperty;
import smartin.miapi.modules.properties.render.ColorProperty;
import smartin.miapi.modules.properties.render.EmissivityProperty;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@Environment(value=EnvType.CLIENT)
public class BakedMiapiModel
implements MiapiModel {
    ModuleInstance instance;
    class_1087 model;
    Matrix4f modelMatrix;
    ModelHolder modelHolder;
    class_5819 random = class_5819.method_43047();
    float[] colors;
    GlintProperty.GlintSettings settings;
    int skyLight;
    int blockLight;
    float alpha;
    static class_4588 lastVC;
    static ColorProvider lastColor;
    static class_1058 textureAtlasSprite;

    public BakedMiapiModel(ModelHolder holder, ModuleInstance moduleInstance, class_1799 stack) {
        this.modelHolder = holder;
        this.instance = holder.colorProvider().adapt(moduleInstance);
        Color color = holder.colorProvider().getVertexColor().orElse(ColorProperty.getColor(stack, this.instance));
        this.colors = new float[]{color.redAsFloat(), color.greenAsFloat(), color.blueAsFloat()};
        this.modelMatrix = holder.matrix4f();
        this.model = holder.model();
        this.settings = GlintProperty.property.getGlintSettings(this.instance, stack);
        this.skyLight = holder.lightValues()[0];
        this.blockLight = holder.lightValues()[1];
        int[] propertyLight = EmissivityProperty.getLightValues(this.instance);
        int propertySky = propertyLight[0];
        int propertyBlock = propertyLight[1];
        this.alpha = AlphaOverwriteProperty.property.getData(moduleInstance).map(DoubleOperationResolvable::getValue).orElse(1.0).floatValue();
        if (propertySky > this.skyLight) {
            this.skyLight = propertySky;
        }
        if (propertyBlock > this.blockLight) {
            this.blockLight = propertyBlock;
        }
    }

    @Override
    public void render(class_4587 matrices, class_1799 stack, class_811 transformationMode, float tickDelta, class_4597 vertexConsumers, class_1309 entity, int packedLight, int overlay) {
        class_6880 armorMaterial;
        assert (class_310.method_1551().field_1687 != null);
        HashMap lookup = new HashMap();
        class_310.method_1551().method_16011().method_15396("BakedModel");
        class_310.method_1551().method_16011().method_15396("BakedModel-logic");
        matrices.method_22903();
        int sky = class_765.method_24187((int)packedLight);
        int block = class_765.method_24186((int)packedLight);
        if (this.skyLight > sky) {
            sky = this.skyLight;
        }
        if (this.blockLight > block) {
            block = this.blockLight;
        }
        int light = class_765.method_23687((int)block, (int)sky);
        Transform.applyPosition(matrices, this.modelMatrix);
        class_1087 currentModel = this.resolve(this.model, stack, entity, light);
        class_310.method_1551().method_16011().method_15407();
        class_310.method_1551().method_16011().method_15396("BakedModel - quads");
        try {
            for (class_2350 dir : class_2350.values()) {
                List quads = currentModel.method_4707(null, dir, class_5819.method_43047());
                for (class_777 quad2 : quads) {
                    class_4588 consumer = this.getConsumer(this.modelHolder.colorProvider(), quad2.method_35788(), vertexConsumers, stack, this.instance, transformationMode);
                    consumer.method_22919(matrices.method_23760(), quad2, this.colors[0], this.colors[1], this.colors[2], this.alpha, light, overlay);
                }
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("rendering error in module " + String.valueOf(this.instance.moduleID) + " " + String.valueOf(MaterialProperty.getMaterial(this.instance)), (Throwable)e);
            MaterialSpriteManager.clear();
        }
        class_310.method_1551().method_16011().method_15407();
        class_310.method_1551().method_16011().method_15396("BakedModel Glint");
        if (stack.method_7958() && MiapiConfig.getClientConfig().enchantingGlint.enabled) {
            try {
                class_4588 altConsumer = vertexConsumers.getBuffer(GlintShader.modularItemGlint);
                for (class_2350 dir : class_2350.values()) {
                    currentModel.method_4707(null, dir, class_5819.method_43047()).forEach(quad -> {
                        Color glintColor = this.settings.getColor();
                        altConsumer.method_22919(matrices.method_23760(), quad, glintColor.redAsFloat(), glintColor.greenAsFloat(), glintColor.blueAsFloat(), this.alpha, light, overlay);
                    });
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("rendering glint error in module " + String.valueOf(this.instance.moduleID) + " " + String.valueOf(MaterialProperty.getMaterial(this.instance)), (Throwable)e);
            }
        }
        class_310.method_1551().method_16011().method_15407();
        class_310.method_1551().method_16011().method_15396("TrimModel");
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            v0 = armorItem.method_7686();
        } else {
            v0 = armorMaterial = null;
        }
        if (armorMaterial != null && !this.modelHolder.trimMode().equals((Object)TrimRenderer.TrimMode.NONE)) {
            ModelTransformer.getRescale(currentModel, this.random).forEach(quad -> TrimRenderer.renderTrims(matrices, quad, this.modelHolder.trimMode(), light, vertexConsumers, (class_6880<class_1741>)armorMaterial, stack));
        }
        class_310.method_1551().method_16011().method_15407();
        lookup.clear();
        if (this.modelHolder.entityRendering()) {
            class_310.method_1551().method_16011().method_15396("EntityModel");
            ModelTransformer.getInverse(currentModel, this.random).forEach(quad -> {
                class_4588 vertexConsumer = this.getConsumer(this.modelHolder.colorProvider(), quad.method_35788(), vertexConsumers, stack, this.instance, transformationMode);
                vertexConsumer.method_22919(matrices.method_23760(), quad, this.colors[0], this.colors[1], this.colors[2], this.alpha, light, overlay);
            });
            class_310.method_1551().method_16011().method_15407();
        }
        matrices.method_22909();
        class_310.method_1551().method_16011().method_15407();
    }

    public boolean isStillValid(class_4588 vertexConsumer) {
        if (vertexConsumer instanceof RescaledVertexConsumer) {
            RescaledVertexConsumer rescaledVertexConsumer = (RescaledVertexConsumer)vertexConsumer;
            return this.isStillValid(rescaledVertexConsumer.delegate);
        }
        if (vertexConsumer instanceof class_287) {
            class_287 buffer = (class_287)vertexConsumer;
            return ((BufferBuilderAccessor)buffer).isBuilding();
        }
        return false;
    }

    public class_4588 getConsumer(ColorProvider provider, class_1058 sprite, class_4597 source, class_1799 itemStack, ModuleInstance instance, class_811 context) {
        if (provider.equals(lastColor) && sprite.equals(textureAtlasSprite) && this.isStillValid(lastVC)) {
            return lastVC;
        }
        lastVC = provider.getConsumer(source, sprite, itemStack, instance, context);
        lastColor = provider;
        textureAtlasSprite = sprite;
        return lastVC;
    }

    public class_1087 resolve(class_1087 model, class_1799 stack, @Nullable class_1309 entity, int light) {
        if (model.method_4710() != null && !model.method_4710().equals(class_806.field_4292)) {
            class_1087 override = model.method_4710().method_3495(model, stack, class_310.method_1551().field_1687, entity, light);
            if (model != null) {
                model = override;
            }
        }
        return model;
    }
}

