/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.config;

import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.auto.ConfigAutoCodec;
import com.redpxnda.nucleus.util.Color;
import com.redpxnda.nucleus.util.Comment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import smartin.miapi.modules.abilities.key.MiapiBinding;

@ConfigAutoCodec.ConfigClassMarker
public class MiapiClientConfig {
    public static MiapiClientConfig INSTANCE = new MiapiClientConfig();
    @AutoCodec.Name(value="gui_colors")
    public GuiColorsCategory guiColors = new GuiColorsCategory();
    public OtherCategory other = new OtherCategory();
    @AutoCodec.Name(value="shielding_armor")
    public ShieldingArmorCategory shieldingArmor = new ShieldingArmorCategory();
    @AutoCodec.Name(value="lore")
    public LoreConfig loreConfig = new LoreConfig();
    @AutoCodec.Name(value="enchanting_glint")
    public EnchantingGlint enchantingGlint = new EnchantingGlint();

    @ConfigAutoCodec.ConfigClassMarker
    public static class GuiColorsCategory {
        @Comment(value="The color Miapi uses for its red/invalid/negative color in the workbench gui")
        public Color red = new Color(196, 19, 19, 255);
        @Comment(value="The color Miapi uses for its green/valid/positive color in the workbench gui")
        public Color green = new Color(0, 255, 0, 255);
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class OtherCategory {
        @Comment(value="Whether Miapi materials can be animated")
        @AutoCodec.Name(value="animated_materials")
        public boolean animatedMaterials = true;
        @Comment(value="If Editor is enabled despite nucleus not being loaded")
        @AutoCodec.Name(value="allow_editor_no_nucleus")
        public boolean allowEditorNoNucleus = false;
        @Comment(value="If a custom render mixin should be used to substitute nucleus editor")
        @AutoCodec.Name(value="enable_editor_mixin")
        public boolean enableEditorMixin = false;
        @Comment(value="Can split into new lines on every character, not just space")
        @AutoCodec.Name(value="split_new_line")
        public boolean splitNewLineAlways = false;
        public Map<class_2960, MiapiBinding> bindings = new HashMap<class_2960, MiapiBinding>();
        @AutoCodec.Name(value="cache_sprites")
        public List<CacheSprites> cacheSprites = List.of(new CacheSprites(16, 16, 30), new CacheSprites(32, 32, 10), new CacheSprites(64, 64, 20));
        @AutoCodec.Name(value="disable_fast_render")
        public boolean disableFastRender = false;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class ShieldingArmorCategory {
        @Comment(value="If the Health bar is used to offset the Armor Shielding Bar")
        @AutoCodec.Name(value="respect_health")
        public boolean respectHealth = true;
        @Comment(value="If the Health bar is used to offset the Armor Shielding Bar")
        @AutoCodec.Name(value="respect_armor")
        public boolean respectArmor = true;
        @Comment(value="the amount of other bars to be offset by")
        @AutoCodec.Name(value="other_offset")
        public int otherOffsets = 0;
        @Comment(value="other attributes that if the player has more than 0 will offset the Armor shielding for every 20")
        @AutoCodec.Name(value="other_attributes")
        public List<class_2960> attributesSingleLine = new ArrayList<class_2960>();
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class LoreConfig {
        @Comment(value="Whether Miapi displays \"Modular Material\" when no groups are present")
        @AutoCodec.Name(value="inject_lore_without_material_group")
        public boolean injectLoreWithoutGroup = false;
        @Comment(value="Whether Miapi displays \"Modular Item\" at all")
        @AutoCodec.Name(value="inject_lore_modular item")
        public boolean injectLoreModularItem = true;
        @Comment(value="Whether Miapi displays \"Modular Material\" at all")
        @AutoCodec.Name(value="inject_lore_material")
        public boolean injectLoreModularMaterial = true;
        @Comment(value="Whether Miapi displays \"Modular Smithing Template\" at all")
        @AutoCodec.Name(value="inject_lore_template")
        public boolean injectLoreModularTemplate = true;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class EnchantingGlint {
        @Comment(value="If Miapi glint is rendered at all.\nDisable this if your having issues with glint")
        @AutoCodec.Name(value="enabled")
        public boolean enabled = true;
        @Comment(value="Overwrites other glint settings, forces glint to be rendered like vanilla.\nWE RECOMMEND TO TURN THIS OFF\n")
        @AutoCodec.Name(value="force_vanilla_like")
        public boolean vanillaLike = true;
        @Comment(value="The colors Miapi uses for its default enchanting glint\n- DISABLE VANILLA LIKE!\n")
        @AutoCodec.Name(value="enchanting_glint_colors")
        public List<Color> enchantColors = List.of(new Color("A755FF80"));
        @Comment(value="Default speed of Color Change on enchanting Glint\n- DISABLE VANILLA LIKE!\n")
        @AutoCodec.Name(value="enchanting_glint_speed")
        public float enchantingGlintSpeed = 1.0f;
        @Comment(value="Default speed of Color Change on enchanting Glint\n- DISABLE VANILLA LIKE!\n")
        @AutoCodec.Name(value="material_color_brightening")
        public float materialColorBrigtening = 0.3f;
        @Comment(value="The Ratio of default color to Material Color.\n1.0 = only material, 0.0 is no material color.\nWe recommend experiment with this setting, as it allows material colors\nto shine through much more when enchanted.\n- DISABLE VANILLA LIKE!\n")
        @AutoCodec.Name(value="enchanting_material_ratio")
        public float materialRatioColor = 0.4f;
    }

    @ConfigAutoCodec.ConfigClassMarker
    public static class CacheSprites {
        public int x;
        public int y;
        public int count;

        public CacheSprites() {
        }

        public CacheSprites(int x, int y, int count) {
            this.x = x;
            this.y = y;
            this.count = count;
        }
    }
}

