/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.mixin.RegistryOpsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.registries.RegistryInventory;

public class CraftAction {
    public final ItemModule toAdd;
    public final class_1657 player;
    public final List<String> slotLocation = new ArrayList<String>();
    private class_1799 old;
    private final ModularWorkBenchEntity blockEntity;
    private class_1263 linkedInventory;
    private int inventoryOffset;
    public Map<class_2960, JsonElement> data = new ConcurrentHashMap<class_2960, JsonElement>();
    public static final List<CraftingEvent> events = new ArrayList<CraftingEvent>();
    public CraftingScreenHandler screenHandler;

    public CraftAction(class_1799 old, SlotProperty.ModuleSlot slot, @Nullable ItemModule toAdd, class_1657 player, ModularWorkBenchEntity bench, Map<class_2960, JsonElement> data, CraftingScreenHandler craftingScreenHandler) {
        this.screenHandler = craftingScreenHandler;
        this.old = ModularItemStackConverter.getModularVersion(old);
        this.toAdd = toAdd;
        this.slotLocation.addAll(slot.getAsLocation());
        this.player = player;
        this.blockEntity = bench;
        this.data = data;
    }

    public CraftAction(class_2540 buf, ModularWorkBenchEntity bench, CraftingScreenHandler craftingScreenHandler) {
        int size = buf.readInt();
        this.screenHandler = craftingScreenHandler;
        for (int i = 0; i < size; ++i) {
            this.slotLocation.add(buf.method_19772());
        }
        String modules = buf.method_19772();
        this.toAdd = !modules.equals("null") ? RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(modules) : null;
        this.player = CraftAction.getPlayerFromUuid(buf.method_10790());
        this.blockEntity = bench;
        int numBuffers = buf.readInt();
        for (int i = 0; i < numBuffers; ++i) {
            String key = buf.method_19772();
            String value = buf.method_19772();
            JsonElement element = (JsonElement)Miapi.gson.fromJson(value, JsonElement.class);
            this.data.put(class_2960.method_60654((String)key), element);
        }
    }

    public class_2540 toPacket(class_2540 buf) {
        buf.method_53002(this.slotLocation.size());
        for (String slot : this.slotLocation) {
            buf.method_10814(slot);
        }
        if (this.toAdd != null) {
            buf.method_10814(this.toAdd.id().toString());
        } else {
            buf.method_10814("null");
        }
        buf.method_10797(this.player.method_5667());
        buf.method_53002(this.data.size());
        this.data.forEach((key, value) -> {
            buf.method_10814(key.toString());
            String jsonString = Miapi.gson.toJson(value);
            buf.method_10814(jsonString);
        });
        return buf;
    }

    public void setItem(class_1799 stack) {
        this.old = ModularItemStackConverter.getModularVersion(stack);
    }

    public boolean canPerform() {
        class_1799 crafted = this.getPreview();
        AtomicBoolean test = new AtomicBoolean(true);
        this.forEachCraftingProperty(crafted, (guiCraftingProperty, module, inventory, start, end, buffer) -> {
            if (test.get()) {
                test.set(guiCraftingProperty.canPerform(this.old, crafted, this.blockEntity, this.player, this, this.toAdd, inventory, buffer));
            }
        });
        return test.get();
    }

    public Pair<Map<CraftingProperty, Boolean>, Boolean> fullCanPerform() {
        HashMap map = new HashMap();
        class_1799 crafted = this.getPreview();
        AtomicBoolean test = new AtomicBoolean(true);
        this.forEachCraftingProperty(crafted, (guiCraftingProperty, module, inventory, start, end, dataMap) -> {
            boolean result = guiCraftingProperty.canPerform(this.old, crafted, this.blockEntity, this.player, this, this.toAdd, inventory, dataMap);
            map.put(guiCraftingProperty, result);
            if (test.get()) {
                test.set(result);
            }
        });
        return Pair.of(map, (Object)test.get());
    }

    protected void updateItem(class_1799 stack, ModuleInstance instance) {
        instance.getRoot().writeToItem(stack);
    }

    public void linkInventory(class_1263 inventory, int offset) {
        this.linkedInventory = inventory;
        this.inventoryOffset = offset;
    }

    public class_1799 perform() {
        class_1799[] craftingStack = new class_1799[]{this.craft()};
        ComponentApplyProperty.updateItemStack(craftingStack[0], this.player.method_37908().method_30349());
        this.forEachCraftingProperty(craftingStack[0], (craftingProperty, module, inventory, start, end, buffer) -> {
            List<class_1799> itemStacks = craftingProperty.performCraftAction(this.old, craftingStack[0], this.player, this.blockEntity, this, this.toAdd, inventory, buffer);
            craftingStack[0] = itemStacks.removeFirst();
            if (module != null) {
                // empty if block
            }
            for (int i = start; i < end; ++i) {
                this.linkedInventory.method_5447(i, itemStacks.get(i - start));
            }
        });
        ComponentApplyProperty.updateItemStack(craftingStack[0], this.player.method_37908().method_30349());
        ModuleInstance parsingInstance = ItemModule.getModules(craftingStack[0]);
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                return craftingStack[0];
            }
            parsingInstance = parsingInstance.getSubModuleMap().get(this.slotLocation.get(i));
        }
        for (CraftingEvent eventHandler : events) {
            craftingStack[0] = eventHandler.onCraft(this.old, craftingStack[0], parsingInstance);
        }
        this.linkedInventory.method_5431();
        if (this.player != null && this.player.method_37908() != null) {
            class_6903.class_7863 lookup = ((RegistryOpsAccessor)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.player.method_37908().method_30349())).getLookupProvider();
            ItemModule.getModules(craftingStack[0]).allSubModules().forEach(m -> {
                m.lookup = lookup;
                m.registryAccess = this.player.method_37908().method_30349();
            });
        }
        return craftingStack[0];
    }

    private class_1799 craft() {
        class_1799 craftingStack = this.old.method_7972();
        ModuleInstance oldBaseModule = ItemModule.getModules(this.old);
        ModuleInstance newBaseModule = oldBaseModule.copy();
        Map<Object, Object> subModuleMap = new HashMap();
        if (this.slotLocation.isEmpty()) {
            if (this.toAdd == null || this.toAdd == ItemModule.empty || this.toAdd.id().equals((Object)Miapi.id("empty"))) {
                return class_1799.field_8037;
            }
            subModuleMap = oldBaseModule.getSubModuleMap();
            ModuleInstance newModule = new ModuleInstance(this.toAdd);
            subModuleMap.forEach((id, module) -> {
                SlotProperty.ModuleSlot slot = SlotProperty.getSlots(newModule).get(id);
                if (slot != null && slot.allowedIn((ModuleInstance)module)) {
                    newModule.setSubModule((String)id, (ModuleInstance)module);
                    newModule.sortSubModule();
                }
            });
            newModule.writeToItem(craftingStack);
            newModule.clearCaches();
            return craftingStack;
        }
        ModuleInstance parsingInstance = newBaseModule;
        for (int i = this.slotLocation.size() - 1; i > 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step craft slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return this.old;
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        if ((this.toAdd == null || this.toAdd == ItemModule.empty || this.toAdd.id().equals((Object)Miapi.id("empty"))) && parsingInstance != null) {
            parsingInstance.removeSubModule(this.slotLocation.getFirst());
        } else {
            ModuleInstance newModule = new ModuleInstance(this.toAdd);
            ModuleInstance moduleMapInstance = parsingInstance.getSubModule(this.slotLocation.getFirst());
            if (moduleMapInstance != null) {
                subModuleMap = moduleMapInstance.getSubModuleMap();
            }
            subModuleMap.forEach((id, module) -> {
                SlotProperty.ModuleSlot slot = SlotProperty.getSlots(newModule).get(id);
                if (slot != null && slot.allowedIn((ModuleInstance)module)) {
                    newModule.setSubModule((String)id, (ModuleInstance)module);
                }
            });
            parsingInstance.setSubModule(this.slotLocation.getFirst(), newModule);
        }
        newBaseModule.writeToItem(craftingStack);
        craftingStack = craftingStack.method_7972();
        return craftingStack;
    }

    public class_1799 getPreview() {
        AtomicReference<class_1799> craftingStack = new AtomicReference<class_1799>(this.craft());
        this.forEachCraftingProperty(craftingStack.get(), (guiCraftingProperty, module, inventory, start, end, buffer) -> craftingStack.set(guiCraftingProperty.preview(this.old, (class_1799)craftingStack.get(), this.player, this.blockEntity, this, this.toAdd, inventory, buffer)));
        ComponentApplyProperty.updateItemStack(craftingStack.get(), Miapi.registryAccess);
        ModuleInstance parsingInstance = ItemModule.getModules(craftingStack.get());
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step preview slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return this.old;
            }
            if (this.player != null && this.player.method_37908() != null) {
                parsingInstance.registryAccess = this.player.method_37908().method_30349();
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        for (CraftingEvent eventHandler : events) {
            craftingStack.set(eventHandler.onPreview(this.old, craftingStack.get(), parsingInstance));
        }
        ItemModule.getModules(craftingStack.get()).clearCaches();
        this.linkedInventory.method_5431();
        try {
            if (this.player != null && this.player.method_37908() != null) {
                ModuleInstance moduleInstance = ItemModule.getModules(craftingStack.get());
                class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.player.method_37908().method_30349());
                class_1799 stack = craftingStack.get();
                ((ModuleInstance)((Pair)ModuleInstance.CODEC.decode((DynamicOps)ops, (Object)((class_2520)ModuleInstance.CODEC.encodeStart((DynamicOps)ops, (Object)moduleInstance).result().get())).result().get()).getFirst()).writeToItem(stack);
                return stack;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return craftingStack.get();
    }

    public void setData(Map<class_2960, JsonElement> dataMap) {
        this.data = dataMap;
    }

    @Nullable
    public ModuleInstance getModifyingModuleInstance(class_1799 itemStack) {
        ModuleInstance parsingInstance = ItemModule.getModules(itemStack);
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step modifiying module slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return parsingInstance;
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        return parsingInstance;
    }

    public void forEachCraftingProperty(class_1799 crafted, PropertyConsumer propertyConsumer) {
        ModuleInstance parsingInstance = ItemModule.getModules(crafted);
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step crafting property slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return;
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        AtomicInteger integer = new AtomicInteger(this.inventoryOffset);
        ModuleInstance newInstance = parsingInstance;
        List<CraftingProperty> sortedProperties = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.getFlatMap().values().stream().filter(CraftingProperty.class::isInstance).filter(property -> ((CraftingProperty)((Object)property)).shouldExecuteOnCraft(newInstance, ItemModule.getModules(crafted), crafted, this)).map(CraftingProperty.class::cast).sorted(Comparator.comparingDouble(CraftingProperty::getPriority)).toList();
        for (CraftingProperty craftingProperty : sortedProperties) {
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            int startPos = integer.get();
            int endPos = startPos + craftingProperty.getSlotPositions().size();
            for (int i = startPos; i < endPos; ++i) {
                itemStacks.add(this.linkedInventory.method_5438(i));
            }
            propertyConsumer.accept(craftingProperty, newInstance, itemStacks, startPos, endPos, this.data);
            integer.set(endPos);
        }
    }

    protected static class_1657 getPlayerFromUuid(UUID uuid) {
        if (Miapi.server != null) {
            return Miapi.server.method_3760().method_14602(uuid);
        }
        if (class_310.method_1551() != null && class_310.method_1551().field_1687 != null) {
            return class_310.method_1551().field_1687.method_18470(uuid);
        }
        return null;
    }

    public static interface PropertyConsumer {
        public void accept(CraftingProperty var1, ModuleInstance var2, List<class_1799> var3, int var4, int var5, Map<class_2960, JsonElement> var6);
    }

    public static interface CraftingEvent {
        public class_1799 onCraft(class_1799 var1, class_1799 var2, @Nullable ModuleInstance var3);

        public class_1799 onPreview(class_1799 var1, class_1799 var2, @Nullable ModuleInstance var3);
    }
}

